/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.MelsecQnA3EBinaryMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Melsec.MelsecHelper;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class MelsecMcNet
extends NetworkDeviceBase {
    private byte NetworkNumber = 0;
    private byte NetworkStationNumber = 0;

    public MelsecMcNet() {
        this.WordLength = 1;
        this.setByteTransform(new RegularByteTransform());
    }

    public MelsecMcNet(String ipAddress, int port) {
        this.WordLength = 1;
        super.setIpAddress(ipAddress);
        super.setPort(port);
        this.setByteTransform(new RegularByteTransform());
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new MelsecQnA3EBinaryMessage();
    }

    public byte getNetworkNumber() {
        return this.NetworkNumber;
    }

    public void setNetworkNumber(byte networkNumber) {
        this.NetworkNumber = networkNumber;
    }

    public byte getNetworkStationNumber() {
        return this.NetworkStationNumber;
    }

    public void setNetworkStationNumber(byte networkStationNumber) {
        this.NetworkStationNumber = networkStationNumber;
    }

    protected OperateResultExOne<McAddressData> McAnalysisAddress(String address, short length) {
        return McAddressData.ParseMelsecFrom(address, length);
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        int readLength;
        if (address.startsWith("s=") || address.startsWith("S=")) {
            return this.ReadTags(address.substring(2), (short)length);
        }
        if (Pattern.matches("ext=[0-9]+;", address)) {
            String extStr = Pattern.compile("ext=[0-9]+;").matcher(address).group();
            short ext = Short.parseShort(Pattern.compile("[0-9]+").matcher(extStr).group());
            return this.ReadExtend(ext, address.substring(extStr.length()), (short)length);
        }
        if (Pattern.matches("mem=", address)) {
            return this.ReadMemory(address.substring(4), (short)length);
        }
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ArrayList<Byte> bytesContent = new ArrayList<Byte>();
        for (int alreadyFinished = 0; alreadyFinished < length; alreadyFinished += readLength) {
            readLength = Math.min(length - alreadyFinished, 900);
            ((McAddressData)addressResult.Content).setLength(readLength);
            OperateResultExOne<byte[]> read = this.ReadAddressData((McAddressData)addressResult.Content);
            if (!read.IsSuccess) {
                return read;
            }
            Utilities.ArrayListAddArray(bytesContent, (byte[])read.Content);
            if (((McAddressData)addressResult.Content).getMcDataType().getDataType() == 0) {
                ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength);
                continue;
            }
            ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength * 16);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(bytesContent));
    }

    private OperateResultExOne<byte[]> ReadAddressData(McAddressData addressData) {
        byte[] coreResult = MelsecHelper.BuildReadMcCoreCommand(addressData, false);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(MelsecHelper.BuildReadMcCoreCommand((McAddressData)addressResult.Content, true), this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExOne<byte[]> extract = MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), true);
        if (!extract.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extract);
        }
        boolean[] result = new boolean[length];
        for (int i = 0; i < result.length; ++i) {
            if (((byte[])extract.Content)[i] != 1) continue;
            result[i] = true;
        }
        return OperateResultExOne.CreateSuccessResult(result);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        return this.WriteAddressData((McAddressData)addressResult.Content, value);
    }

    private OperateResult WriteAddressData(McAddressData addressData, byte[] value) {
        byte[] coreResult = MelsecHelper.BuildWriteWordCoreCommand(addressData, value);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return addressResult;
        }
        byte[] coreResult = MelsecHelper.BuildWriteBitCoreCommand((McAddressData)addressResult.Content, values);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address) {
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], 1);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = MelsecHelper.BuildReadRandomWordCommand(mcAddressDatas);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address, short[] length) {
        if (length.length != address.length) {
            return new OperateResultExOne<byte[]>(StringResources.Language.TwoParametersLengthIsNotSame());
        }
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], length[i]);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = MelsecHelper.BuildReadRandomCommand(mcAddressDatas);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    public OperateResultExOne<short[]> ReadRandomInt16(String[] address) {
        OperateResultExOne<byte[]> read = this.ReadRandom(address);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(this.getByteTransform().TransInt16((byte[])read.Content, 0, address.length));
    }

    public OperateResultExOne<byte[]> ReadTags(String tag, short length) {
        return this.ReadTags(new String[]{tag}, new short[]{length});
    }

    public OperateResultExOne<byte[]> ReadTags(String[] tags, short[] length) {
        byte[] coreResult = new byte[]{};
        try {
            coreResult = MelsecHelper.BuildReadTag(tags, length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExOne<byte[]> extract = MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
        if (!extract.IsSuccess) {
            return extract;
        }
        return MelsecHelper.ExtraTagData((byte[])extract.Content);
    }

    public OperateResultExOne<byte[]> ReadExtend(short extend, String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = MelsecHelper.BuildReadMcCoreExtendCommand((McAddressData)addressResult.Content, extend, false);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExOne<byte[]> extract = MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
        if (!extract.IsSuccess) {
            return extract;
        }
        return MelsecHelper.ExtraTagData((byte[])extract.Content);
    }

    public OperateResultExOne<byte[]> ReadMemory(String address, short length) {
        OperateResultExOne<byte[]> coreResult = MelsecHelper.BuildReadMemoryCommand(address, length);
        if (!coreResult.IsSuccess) {
            return coreResult;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand((byte[])coreResult.Content, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    public OperateResult RemoteRun() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{1, 16, 0, 0, 1, 0, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResult RemoteStop() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{2, 16, 0, 0, 1, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResult RemoteReset() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{6, 16, 0, 0, 1, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<String> ReadPlcType() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{1, 1, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return OperateResultExOne.CreateSuccessResult(new String(SoftBasic.BytesArraySelectMiddle((byte[])read.Content, 11, 16), StandardCharsets.US_ASCII).trim());
    }

    public OperateResult ErrorStateReset() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{23, 22, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public String toString() {
        return "MelsecMcNet";
    }

    public static byte[] PackMcCommand(byte[] mcCore, byte networkNumber, byte networkStationNumber) {
        byte[] _PLCCommand = new byte[11 + mcCore.length];
        _PLCCommand[0] = 80;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = networkNumber;
        _PLCCommand[3] = -1;
        _PLCCommand[4] = -1;
        _PLCCommand[5] = 3;
        _PLCCommand[6] = networkStationNumber;
        _PLCCommand[7] = (byte)((_PLCCommand.length - 9) % 256);
        _PLCCommand[8] = (byte)((_PLCCommand.length - 9) / 256);
        _PLCCommand[9] = 10;
        _PLCCommand[10] = 0;
        System.arraycopy(mcCore, 0, _PLCCommand, 11, mcCore.length);
        return _PLCCommand;
    }

    public static OperateResultExOne<byte[]> ExtractActualData(byte[] response, boolean isBit) {
        if (isBit) {
            byte[] Content = new byte[response.length * 2];
            for (int i = 0; i < response.length; ++i) {
                if ((response[i] & 0x10) == 16) {
                    Content[i * 2 + 0] = 1;
                }
                if ((response[i] & 1) != 1) continue;
                Content[i * 2 + 1] = 1;
            }
            return OperateResultExOne.CreateSuccessResult(Content);
        }
        byte[] Content = new byte[response.length];
        System.arraycopy(response, 0, Content, 0, Content.length);
        return OperateResultExOne.CreateSuccessResult(Content);
    }

    public static OperateResult CheckResponseContent(byte[] content) {
        int errorCode = Utilities.getUShort(content, 9);
        if (errorCode != 0) {
            return new OperateResult(errorCode, MelsecHelper.GetErrorDescription(errorCode));
        }
        return OperateResult.CreateSuccessResult();
    }
}

