/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.Net.NetworkBase.NetworkUdpDeviceBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Melsec.MelsecHelper;
import HslCommunication.Profinet.Melsec.MelsecMcNet;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class MelsecMcUdp
extends NetworkUdpDeviceBase {
    private byte NetworkNumber = 0;
    private byte NetworkStationNumber = 0;

    public MelsecMcUdp() {
        this.WordLength = 1;
        this.setByteTransform(new RegularByteTransform());
    }

    public MelsecMcUdp(String ipAddress, int port) {
        this.WordLength = 1;
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.setByteTransform(new RegularByteTransform());
    }

    public byte getNetworkNumber() {
        return this.NetworkNumber;
    }

    public void setNetworkNumber(byte networkNumber) {
        this.NetworkNumber = networkNumber;
    }

    public byte getNetworkStationNumber() {
        return this.NetworkStationNumber;
    }

    public void setNetworkStationNumber(byte networkStationNumber) {
        this.NetworkStationNumber = networkStationNumber;
    }

    protected OperateResultExOne<McAddressData> McAnalysisAddress(String address, short length) {
        return McAddressData.ParseMelsecFrom(address, length);
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ArrayList<Byte> bytesContent = new ArrayList<Byte>();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            short readLength = (short)Math.min(length - alreadyFinished, 900);
            ((McAddressData)addressResult.Content).setLength(readLength);
            OperateResultExOne<byte[]> read = this.ReadAddressData((McAddressData)addressResult.Content);
            if (!read.IsSuccess) {
                return read;
            }
            Utilities.ArrayListAddArray(bytesContent, (byte[])read.Content);
            alreadyFinished = (short)(alreadyFinished + readLength);
            if (((McAddressData)addressResult.Content).getMcDataType().getDataType() == 0) {
                ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength);
                continue;
            }
            ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength * 16);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(bytesContent));
    }

    private OperateResultExOne<byte[]> ReadAddressData(McAddressData addressData) {
        byte[] coreResult = MelsecHelper.BuildReadMcCoreCommand(addressData, false);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        return this.WriteAddressData((McAddressData)addressResult.Content, value);
    }

    private OperateResult WriteAddressData(McAddressData addressData, byte[] value) {
        byte[] coreResult = MelsecHelper.BuildWriteWordCoreCommand(addressData, value);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address) {
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], 1);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = MelsecHelper.BuildReadRandomWordCommand(mcAddressDatas);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address, short[] length) {
        if (length.length != address.length) {
            return new OperateResultExOne<byte[]>(StringResources.Language.TwoParametersLengthIsNotSame());
        }
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], length[i]);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = MelsecHelper.BuildReadRandomCommand(mcAddressDatas);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), false);
    }

    public OperateResultExOne<short[]> ReadRandomInt16(String[] address) {
        OperateResultExOne<byte[]> read = this.ReadRandom(address);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(this.getByteTransform().TransInt16((byte[])read.Content, 0, address.length));
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = MelsecHelper.BuildReadMcCoreCommand((McAddressData)addressResult.Content, true);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExOne<byte[]> extract = MelsecMcNet.ExtractActualData(SoftBasic.BytesArrayRemoveBegin((byte[])read.Content, 11), true);
        if (!extract.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extract);
        }
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            if (((byte[])extract.Content)[i] != 1) continue;
            result[i] = true;
        }
        return OperateResultExOne.CreateSuccessResult(result);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return addressResult;
        }
        byte[] coreResult = MelsecHelper.BuildWriteBitCoreCommand((McAddressData)addressResult.Content, values);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResult RemoteRun() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{1, 16, 0, 0, 1, 0, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResult RemoteStop() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{2, 16, 0, 0, 1, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResult RemoteReset() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{6, 16, 0, 0, 1, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<String> ReadPlcType() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{1, 1, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return OperateResultExOne.CreateSuccessResult(new String(SoftBasic.BytesArraySelectMiddle((byte[])read.Content, 11, 16), StandardCharsets.US_ASCII).trim());
    }

    public OperateResult ErrorStateReset() {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcNet.PackMcCommand(new byte[]{23, 22, 0, 0}, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public String toString() {
        return "MelsecMcUdp[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

