/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Omron;

import HslCommunication.Core.IMessage.FinsMessage;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.ReverseWordTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Omron.OmronFinsNetHelper;
import HslCommunication.Utilities;
import java.net.Socket;

public class OmronFinsNet
extends NetworkDeviceBase {
    public byte ICF = (byte)-128;
    public byte RSV = 0;
    public byte GCT = (byte)2;
    public byte DNA = 0;
    public byte DA1 = (byte)19;
    public byte DA2 = 0;
    public byte SNA = 0;
    private byte computerSA1 = (byte)11;
    public byte SA2 = 0;
    public byte SID = 0;
    private final byte[] handSingle = new byte[]{70, 73, 78, 83, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private boolean IsChangeSA1AfterReadFailed = false;

    public OmronFinsNet() {
        this.WordLength = 1;
        ReverseWordTransform transform = new ReverseWordTransform();
        transform.setDataFormat(DataFormat.CDAB);
        transform.setIsStringReverse(true);
        this.setByteTransform(transform);
    }

    public OmronFinsNet(String ipAddress, int port) {
        this.WordLength = 1;
        this.setIpAddress(ipAddress);
        this.setPort(port);
        ReverseWordTransform transform = new ReverseWordTransform();
        transform.setDataFormat(DataFormat.CDAB);
        transform.setIsStringReverse(true);
        this.setByteTransform(transform);
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new FinsMessage();
    }

    public byte getSA1() {
        return this.computerSA1;
    }

    public void setSA1(byte computerSA1) {
        this.computerSA1 = computerSA1;
        this.handSingle[19] = computerSA1;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        super.setIpAddress(ipAddress);
        this.DA1 = (byte)Integer.parseInt(ipAddress.substring(ipAddress.lastIndexOf(".") + 1));
    }

    public boolean isChangeSA1AfterReadFailed() {
        return this.IsChangeSA1AfterReadFailed;
    }

    public void setChangeSA1AfterReadFailed(boolean changeSA1AfterReadFailed) {
        this.IsChangeSA1AfterReadFailed = changeSA1AfterReadFailed;
    }

    public DataFormat getDataFormat() {
        return this.getByteTransform().getDataFormat();
    }

    public boolean isStringReverse() {
        return this.getByteTransform().getIsStringReverse();
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.getByteTransform().setDataFormat(dataFormat);
    }

    public void setStringReverse(boolean stringReverse) {
        this.getByteTransform().setIsStringReverse(stringReverse);
    }

    private byte[] PackCommand(byte[] cmd) {
        byte[] buffer = new byte[26 + cmd.length];
        System.arraycopy(this.handSingle, 0, buffer, 0, 4);
        byte[] tmp = Utilities.getBytes(buffer.length - 8);
        Utilities.bytesReverse(tmp);
        System.arraycopy(tmp, 0, buffer, 4, tmp.length);
        buffer[11] = 2;
        buffer[16] = this.ICF;
        buffer[17] = this.RSV;
        buffer[18] = this.GCT;
        buffer[19] = this.DNA;
        buffer[20] = this.DA1;
        buffer[21] = this.DA2;
        buffer[22] = this.SNA;
        buffer[23] = this.getSA1();
        buffer[24] = this.SA2;
        buffer[25] = this.SID;
        System.arraycopy(cmd, 0, buffer, 26, cmd.length);
        return buffer;
    }

    public OperateResultExOne<byte[]> BuildReadCommand(String address, short length, boolean isBit) {
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildReadCommand(address, length, isBit);
        if (!command.IsSuccess) {
            return command;
        }
        return OperateResultExOne.CreateSuccessResult(this.PackCommand((byte[])command.Content));
    }

    public OperateResultExOne<byte[]> BuildWriteCommand(String address, byte[] value, boolean isBit) {
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildWriteWordCommand(address, value, isBit);
        if (!command.IsSuccess) {
            return command;
        }
        return OperateResultExOne.CreateSuccessResult(this.PackCommand((byte[])command.Content));
    }

    @Override
    protected OperateResult InitializationOnConnect(Socket socket) {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(socket, this.handSingle);
        if (!read.IsSuccess) {
            return read;
        }
        byte[] buffer = new byte[]{((byte[])read.Content)[15], ((byte[])read.Content)[14], ((byte[])read.Content)[13], ((byte[])read.Content)[12]};
        int status = Utilities.getInt(buffer, 0);
        if (status != 0) {
            return new OperateResult(status, OmronFinsNetHelper.GetStatusDescription(status));
        }
        if (((byte[])read.Content).length >= 24) {
            this.DA1 = ((byte[])read.Content)[23];
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    protected void ExtraAfterReadFromCoreServer(OperateResult read) {
        super.ExtraAfterReadFromCoreServer(read);
        if (!read.IsSuccess && this.IsChangeSA1AfterReadFailed) {
            this.computerSA1 = (byte)(this.computerSA1 + 1);
            if ((this.computerSA1 & 0xFF) > 253) {
                this.computerSA1 = 1;
            }
            if (this.computerSA1 == this.DA1) {
                this.computerSA1 = (byte)(this.computerSA1 + 1);
            }
            if ((this.computerSA1 & 0xFF) > 253) {
                this.computerSA1 = 1;
            }
        }
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length, false);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.ResponseValidAnalysis((byte[])read.Content, true);
        if (!valid.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(valid);
        }
        return OperateResultExOne.CreateSuccessResult(valid.Content);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, value, false);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.ResponseValidAnalysis((byte[])read.Content, false);
        if (!valid.IsSuccess) {
            return valid;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length, true);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.ResponseValidAnalysis((byte[])read.Content, true);
        if (!valid.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(valid);
        }
        boolean[] buffer = new boolean[((byte[])valid.Content).length];
        for (int i = 0; i < ((byte[])valid.Content).length; ++i) {
            buffer[i] = ((byte[])valid.Content)[i] != 0;
        }
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        byte[] buffer = new byte[values.length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = values[i] ? (byte)1 : 0;
        }
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, buffer, true);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.ResponseValidAnalysis((byte[])read.Content, false);
        if (!valid.IsSuccess) {
            return valid;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public String toString() {
        return "OmronFinsNet[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

