/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Omron;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.Omron.OmronFinsDataType;
import HslCommunication.StringResources;
import HslCommunication.Utilities;

public class OmronFinsNetHelper {
    public static OperateResultExTwo<OmronFinsDataType, byte[]> AnalysisAddress(String address, boolean isBit) {
        OperateResultExTwo<OmronFinsDataType, byte[]> result = new OperateResultExTwo<OmronFinsDataType, byte[]>();
        try {
            int addr;
            String[] splits;
            switch (address.charAt(0)) {
                case 'D': 
                case 'd': {
                    result.Content1 = OmronFinsDataType.DM;
                    break;
                }
                case 'C': 
                case 'c': {
                    result.Content1 = OmronFinsDataType.CIO;
                    break;
                }
                case 'W': 
                case 'w': {
                    result.Content1 = OmronFinsDataType.WR;
                    break;
                }
                case 'H': 
                case 'h': {
                    result.Content1 = OmronFinsDataType.HR;
                    break;
                }
                case 'A': 
                case 'a': {
                    result.Content1 = OmronFinsDataType.AR;
                    break;
                }
                case 'E': 
                case 'e': {
                    splits = address.split("\\.");
                    int block = Integer.parseInt(splits[0].substring(1), 16);
                    if (block < 16) {
                        result.Content1 = new OmronFinsDataType((byte)(32 + block), (byte)(160 + block));
                        break;
                    }
                    result.Content1 = new OmronFinsDataType((byte)(224 + block - 16), (byte)(96 + block - 16));
                    break;
                }
                default: {
                    throw new Exception(StringResources.Language.NotSupportedDataType());
                }
            }
            if (address.charAt(0) == 'E' || address.charAt(0) == 'e') {
                splits = address.split("\\.");
                if (isBit) {
                    addr = Integer.parseInt(splits[1]);
                    result.Content2 = new byte[3];
                    ((byte[])result.Content2)[0] = Utilities.getBytes(addr)[1];
                    ((byte[])result.Content2)[1] = Utilities.getBytes(addr)[0];
                    if (splits.length > 2) {
                        ((byte[])result.Content2)[2] = Byte.parseByte(splits[2]);
                        if (((byte[])result.Content2)[2] > 15) {
                            throw new Exception(StringResources.Language.OmronAddressMustBeZeroToFifteen());
                        }
                    }
                } else {
                    addr = Integer.parseInt(splits[1]);
                    result.Content2 = new byte[3];
                    ((byte[])result.Content2)[0] = Utilities.getBytes(addr)[1];
                    ((byte[])result.Content2)[1] = Utilities.getBytes(addr)[0];
                }
            } else if (isBit) {
                splits = address.substring(1).split("\\.");
                addr = Integer.parseInt(splits[0]);
                result.Content2 = new byte[3];
                ((byte[])result.Content2)[0] = Utilities.getBytes(addr)[1];
                ((byte[])result.Content2)[1] = Utilities.getBytes(addr)[0];
                if (splits.length > 1) {
                    ((byte[])result.Content2)[2] = Byte.parseByte(splits[1]);
                    if (((byte[])result.Content2)[2] > 15) {
                        throw new Exception(StringResources.Language.OmronAddressMustBeZeroToFifteen());
                    }
                }
            } else {
                int addr2 = Integer.parseInt(address.substring(1));
                result.Content2 = new byte[3];
                ((byte[])result.Content2)[0] = Utilities.getBytes(addr2)[1];
                ((byte[])result.Content2)[1] = Utilities.getBytes(addr2)[0];
            }
        }
        catch (Exception ex) {
            result.Message = ex.getMessage();
            return result;
        }
        result.IsSuccess = true;
        return result;
    }

    public static OperateResultExOne<byte[]> BuildReadCommand(String address, short length, boolean isBit) {
        OperateResultExTwo<OmronFinsDataType, byte[]> analysis = OmronFinsNetHelper.AnalysisAddress(address, isBit);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        byte[] _PLCCommand = new byte[8];
        _PLCCommand[0] = 1;
        _PLCCommand[1] = 1;
        _PLCCommand[2] = isBit ? ((OmronFinsDataType)analysis.Content1).getBitCode() : ((OmronFinsDataType)analysis.Content1).getWordCode();
        System.arraycopy(analysis.Content2, 0, _PLCCommand, 3, ((byte[])analysis.Content2).length);
        _PLCCommand[6] = Utilities.getBytes(length)[1];
        _PLCCommand[7] = Utilities.getBytes(length)[0];
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> BuildWriteWordCommand(String address, byte[] value, boolean isBit) {
        OperateResultExTwo<OmronFinsDataType, byte[]> analysis = OmronFinsNetHelper.AnalysisAddress(address, isBit);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        byte[] _PLCCommand = new byte[8 + value.length];
        _PLCCommand[0] = 1;
        _PLCCommand[1] = 2;
        _PLCCommand[2] = isBit ? ((OmronFinsDataType)analysis.Content1).getBitCode() : ((OmronFinsDataType)analysis.Content1).getWordCode();
        System.arraycopy(analysis.Content2, 0, _PLCCommand, 3, ((byte[])analysis.Content2).length);
        if (isBit) {
            _PLCCommand[6] = (byte)(value.length / 256);
            _PLCCommand[7] = (byte)(value.length % 256);
        } else {
            _PLCCommand[6] = (byte)(value.length / 2 / 256);
            _PLCCommand[7] = (byte)(value.length / 2 % 256);
        }
        System.arraycopy(value, 0, _PLCCommand, 8, value.length);
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> ResponseValidAnalysis(byte[] response, boolean isRead) {
        if (response.length >= 16) {
            byte[] buffer = new byte[]{response[15], response[14], response[13], response[12]};
            int err = Utilities.getInt(buffer, 0);
            if (err > 0) {
                return new OperateResultExOne<byte[]>(err, OmronFinsNetHelper.GetStatusDescription(err));
            }
            byte[] result = new byte[response.length - 16];
            System.arraycopy(response, 16, result, 0, result.length);
            return OmronFinsNetHelper.UdpResponseValidAnalysis(result, isRead);
        }
        return new OperateResultExOne<byte[]>(StringResources.Language.OmronReceiveDataError());
    }

    public static OperateResultExOne<byte[]> UdpResponseValidAnalysis(byte[] response, boolean isRead) {
        if (response.length >= 14) {
            int err = response[12] * 256 + response[13];
            if (!isRead) {
                OperateResultExOne<byte[]> success = OperateResultExOne.CreateSuccessResult(new byte[0]);
                success.ErrorCode = err;
                success.Message = OmronFinsNetHelper.GetStatusDescription(err) + " Received:" + SoftBasic.ByteToHexString(response, ' ');
                return success;
            }
            byte[] content = new byte[response.length - 14];
            if (content.length > 0) {
                System.arraycopy(response, 14, content, 0, content.length);
            }
            OperateResultExOne<byte[]> success = OperateResultExOne.CreateSuccessResult(content);
            if (content.length == 0) {
                success.IsSuccess = false;
            }
            success.ErrorCode = err;
            success.Message = OmronFinsNetHelper.GetStatusDescription(err) + " Received:" + SoftBasic.ByteToHexString(response, ' ');
            return success;
        }
        return new OperateResultExOne<byte[]>(StringResources.Language.OmronReceiveDataError());
    }

    public static String GetStatusDescription(int err) {
        switch (err) {
            case 0: {
                return StringResources.Language.OmronStatus0();
            }
            case 1: {
                return StringResources.Language.OmronStatus1();
            }
            case 2: {
                return StringResources.Language.OmronStatus2();
            }
            case 3: {
                return StringResources.Language.OmronStatus3();
            }
            case 20: {
                return StringResources.Language.OmronStatus20();
            }
            case 21: {
                return StringResources.Language.OmronStatus21();
            }
            case 22: {
                return StringResources.Language.OmronStatus22();
            }
            case 23: {
                return StringResources.Language.OmronStatus23();
            }
            case 24: {
                return StringResources.Language.OmronStatus24();
            }
            case 25: {
                return StringResources.Language.OmronStatus25();
            }
        }
        return StringResources.Language.UnknownError();
    }
}

