/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Omron;

import HslCommunication.Core.Net.NetworkBase.NetworkUdpDeviceBase;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.ReverseWordTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Omron.OmronFinsNetHelper;

public class OmronFinsUdp
extends NetworkUdpDeviceBase {
    public byte ICF = (byte)-128;
    public byte RSV = 0;
    public byte GCT = (byte)2;
    public byte DNA = 0;
    public byte DA1 = (byte)19;
    public byte DA2 = 0;
    public byte SNA = 0;
    public byte SA1 = (byte)11;
    public byte SA2 = 0;
    public byte SID = 0;

    public OmronFinsUdp(String ipAddress, int port) {
        this.WordLength = 1;
        this.setIpAddress(ipAddress);
        this.setPort(port);
        ReverseWordTransform transform = new ReverseWordTransform();
        transform.setDataFormat(DataFormat.CDAB);
        transform.setIsStringReverse(true);
        this.setByteTransform(transform);
    }

    public OmronFinsUdp() {
        this.WordLength = 1;
        ReverseWordTransform transform = new ReverseWordTransform();
        transform.setDataFormat(DataFormat.CDAB);
        transform.setIsStringReverse(true);
        this.setByteTransform(transform);
    }

    @Override
    public void setIpAddress(String ipAddress) {
        super.setIpAddress(ipAddress);
        this.DA1 = (byte)Integer.parseInt(ipAddress.substring(ipAddress.lastIndexOf(".") + 1));
    }

    private byte[] PackCommand(byte[] cmd) {
        byte[] buffer = new byte[10 + cmd.length];
        buffer[0] = this.ICF;
        buffer[1] = this.RSV;
        buffer[2] = this.GCT;
        buffer[3] = this.DNA;
        buffer[4] = this.DA1;
        buffer[5] = this.DA2;
        buffer[6] = this.SNA;
        buffer[7] = this.SA1;
        buffer[8] = this.SA2;
        buffer[9] = this.SID;
        System.arraycopy(cmd, 0, buffer, 10, cmd.length);
        return buffer;
    }

    public OperateResultExOne<byte[]> BuildReadCommand(String address, short length, boolean isBit) {
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildReadCommand(address, length, isBit);
        if (!command.IsSuccess) {
            return command;
        }
        return OperateResultExOne.CreateSuccessResult(this.PackCommand((byte[])command.Content));
    }

    public OperateResultExOne<byte[]> BuildWriteCommand(String address, byte[] value, boolean isBit) {
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildWriteWordCommand(address, value, isBit);
        if (!command.IsSuccess) {
            return command;
        }
        return OperateResultExOne.CreateSuccessResult(this.PackCommand((byte[])command.Content));
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length, false);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.UdpResponseValidAnalysis((byte[])read.Content, true);
        if (!valid.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(valid);
        }
        return OperateResultExOne.CreateSuccessResult(valid.Content);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, value, false);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.UdpResponseValidAnalysis((byte[])read.Content, false);
        if (!valid.IsSuccess) {
            return valid;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length, true);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.UdpResponseValidAnalysis((byte[])read.Content, true);
        if (!valid.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(valid);
        }
        boolean[] result = new boolean[((byte[])valid.Content).length];
        for (int i = 0; i < result.length; ++i) {
            if (((byte[])valid.Content)[i] == 0) continue;
            result[i] = true;
        }
        return OperateResultExOne.CreateSuccessResult(result);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        byte[] result = new byte[values.length];
        for (int i = 0; i < result.length; ++i) {
            if (!values[i]) continue;
            result[i] = 1;
        }
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, result, true);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResultExOne<byte[]> valid = OmronFinsNetHelper.UdpResponseValidAnalysis((byte[])read.Content, false);
        if (!valid.IsSuccess) {
            return valid;
        }
        return OperateResult.CreateSuccessResult();
    }

    public String ToString() {
        return "OmronFinsUdp[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

