/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Siemens;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.S7Message;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.ByteTransformHelper;
import HslCommunication.Core.Transfer.ReverseBytesTransform;
import HslCommunication.Core.Types.FunctionOperateExOne;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.Profinet.Siemens.SiemensDateTime;
import HslCommunication.Profinet.Siemens.SiemensPLCS;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;

public class SiemensS7Net
extends NetworkDeviceBase {
    private byte[] plcHead1 = new byte[]{3, 0, 0, 22, 17, -32, 0, 0, 0, 1, 0, -64, 1, 10, -63, 2, 1, 2, -62, 2, 1, 0};
    private byte[] plcHead2 = new byte[]{3, 0, 0, 25, 2, -16, -128, 50, 1, 0, 0, 4, 0, 0, 8, 0, 0, -16, 0, 0, 1, 0, 1, 1, -32};
    private byte[] plcOrderNumber = new byte[]{3, 0, 0, 33, 2, -16, -128, 50, 7, 0, 0, 0, 1, 0, 8, 0, 8, 0, 1, 18, 4, 17, 68, 1, 0, -1, 9, 0, 4, 0, 17, 0, 0};
    private SiemensPLCS CurrentPlc = SiemensPLCS.S1200;
    private byte[] plcHead1_200smart = new byte[]{3, 0, 0, 22, 17, -32, 0, 0, 0, 1, 0, -63, 2, 16, 0, -62, 2, 3, 0, -64, 1, 10};
    private byte[] plcHead2_200smart = new byte[]{3, 0, 0, 25, 2, -16, -128, 50, 1, 0, 0, -52, -63, 0, 8, 0, 0, -16, 0, 0, 1, 0, 1, 3, -64};
    private byte[] plcHead1_200 = new byte[]{3, 0, 0, 22, 17, -32, 0, 0, 0, 1, 0, -63, 2, 77, 87, -62, 2, 77, 87, -64, 1, 9};
    private byte[] plcHead2_200 = new byte[]{3, 0, 0, 25, 2, -16, -128, 50, 1, 0, 0, 0, 0, 0, 8, 0, 0, -16, 0, 0, 1, 0, 1, 3, -64};
    private byte plc_slot = 0;
    private byte plc_rack = 0;

    public SiemensS7Net(SiemensPLCS siemens) {
        this.Initialization(siemens, "");
    }

    public SiemensS7Net(SiemensPLCS siemens, String ipAddress) {
        this.Initialization(siemens, ipAddress);
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new S7Message();
    }

    private void Initialization(SiemensPLCS siemens, String ipAddress) {
        this.WordLength = (short)2;
        this.setIpAddress(ipAddress);
        this.setPort(102);
        this.CurrentPlc = siemens;
        this.setByteTransform(new ReverseBytesTransform());
        switch (siemens) {
            case S1200: {
                this.plcHead1[21] = 0;
                break;
            }
            case S300: {
                this.plcHead1[21] = 2;
                break;
            }
            case S400: {
                this.plcHead1[21] = 3;
                this.plcHead1[17] = 0;
                break;
            }
            case S1500: {
                this.plcHead1[21] = 0;
                break;
            }
            case S200Smart: {
                this.plcHead1 = this.plcHead1_200smart;
                this.plcHead2 = this.plcHead2_200smart;
                break;
            }
            case S200: {
                this.plcHead1 = this.plcHead1_200;
                this.plcHead2 = this.plcHead2_200;
            }
            default: {
                this.plcHead1[18] = 0;
            }
        }
    }

    public byte getSlot() {
        return this.plc_slot;
    }

    public void setSlot(byte value) {
        this.plc_slot = value;
        this.plcHead1[21] = (byte)(this.plc_rack * 32 + this.plc_slot);
    }

    public byte getRack() {
        return this.plc_rack;
    }

    public void setRack(byte value) {
        this.plc_rack = value;
        this.plcHead1[21] = (byte)(this.plc_rack * 32 + this.plc_slot);
    }

    @Override
    protected OperateResult InitializationOnConnect(Socket socket) {
        OperateResultExOne<byte[]> read_first = this.ReadFromCoreServer(socket, this.plcHead1);
        if (!read_first.IsSuccess) {
            return read_first;
        }
        OperateResultExOne<byte[]> read_second = this.ReadFromCoreServer(socket, this.plcHead2);
        if (!read_second.IsSuccess) {
            return read_second;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<String> ReadOrderNumber() {
        OperateResultExOne<String> result = new OperateResultExOne<String>();
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(this.plcOrderNumber);
        if (read.IsSuccess && ((byte[])read.Content).length > 100) {
            result.IsSuccess = true;
            result.Content = Utilities.getString(Arrays.copyOfRange((byte[])read.Content, 71, 91), "ASCII");
        }
        if (!result.IsSuccess) {
            result.CopyErrorFromOther(read);
        }
        return result;
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExThree<Byte, Integer, Integer> addressResult = SiemensS7Net.AnalysisAddress(address);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            short readLength = (short)Math.min(length - alreadyFinished, 200);
            OperateResultExThree[] list = new OperateResultExThree[]{addressResult};
            OperateResultExOne<byte[]> read = this.Read(list, new short[]{readLength});
            if (read.IsSuccess) {
                try {
                    outputStream.write((byte[])read.Content);
                }
                catch (Exception exception) {}
            } else {
                return read;
            }
            alreadyFinished = (short)(alreadyFinished + readLength);
            OperateResultExThree<Byte, Integer, Integer> operateResultExThree = addressResult;
            Integer.valueOf((Integer)operateResultExThree.Content2 + readLength * 8);
            operateResultExThree.Content2 = operateResultExThree.Content2;
        }
        byte[] buffer = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> ReadBitFromPLC(String address) {
        OperateResultExOne<byte[]> command = SiemensS7Net.BuildBitReadCommand(address);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        int receiveCount = 1;
        if (((byte[])read.Content).length >= 21 && ((byte[])read.Content)[20] == 1) {
            byte[] buffer = new byte[receiveCount];
            if (22 < ((byte[])read.Content).length && ((byte[])read.Content)[21] == -1 && ((byte[])read.Content)[22] == 3) {
                buffer[0] = ((byte[])read.Content)[25];
            }
            return OperateResultExOne.CreateSuccessResult(buffer);
        }
        return new OperateResultExOne<byte[]>(read.ErrorCode, StringResources.Language.SiemensDataLengthCheckFailed());
    }

    public OperateResultExOne<byte[]> Read(String[] address, short[] length) {
        OperateResultExThree[] list = new OperateResultExThree[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExThree<Byte, Integer, Integer> tmp = SiemensS7Net.AnalysisAddress(address[i]);
            if (!tmp.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(tmp);
            }
            list[i] = tmp;
        }
        return this.Read(list, length);
    }

    private OperateResultExOne<byte[]> Read(OperateResultExThree<Byte, Integer, Integer>[] address, short[] length) {
        OperateResultExOne<byte[]> command = SiemensS7Net.BuildReadCommand(address, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        int receiveCount = 0;
        for (int i = 0; i < length.length; ++i) {
            receiveCount += length[i];
        }
        if (((byte[])read.Content).length >= 21 && ((byte[])read.Content)[20] == length.length) {
            byte[] buffer = new byte[receiveCount];
            int kk = 0;
            int ll = 0;
            for (int ii = 21; ii < ((byte[])read.Content).length; ++ii) {
                if (ii + 1 >= ((byte[])read.Content).length || ((byte[])read.Content)[ii] != -1 || ((byte[])read.Content)[ii + 1] != 4) continue;
                System.arraycopy(read.Content, ii + 4, buffer, ll, length[kk]);
                ii += length[kk] + 3;
                ll += length[kk];
                ++kk;
            }
            return OperateResultExOne.CreateSuccessResult(buffer);
        }
        return new OperateResultExOne<byte[]>(read.ErrorCode, StringResources.Language.SiemensDataLengthCheckFailed());
    }

    @Override
    public OperateResultExOne<Boolean> ReadBool(String address) {
        return ByteTransformHelper.GetResultFromBytes(this.ReadBitFromPLC(address), new FunctionOperateExOne<byte[], Boolean>(){

            @Override
            public Boolean Action(byte[] content) {
                return content[0] != 0;
            }
        });
    }

    public OperateResultExOne<Byte> ReadByte(String address) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, (short)1), new FunctionOperateExOne<byte[], Byte>(){

            @Override
            public Byte Action(byte[] content) {
                return content[0];
            }
        });
    }

    private OperateResult WriteBase(byte[] entireValue) {
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(entireValue);
        if (!write.IsSuccess) {
            return write;
        }
        if (((byte[])write.Content)[((byte[])write.Content).length - 1] != -1) {
            return new OperateResult(((byte[])write.Content)[((byte[])write.Content).length - 1], StringResources.Language.SiemensWriteError() + ((byte[])write.Content)[((byte[])write.Content).length - 1]);
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        short writeLength;
        OperateResultExThree<Byte, Integer, Integer> analysis = SiemensS7Net.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        int length = value.length;
        for (int alreadyFinished = 0; alreadyFinished < length; alreadyFinished += writeLength) {
            writeLength = (short)Math.min(length - alreadyFinished, 200);
            byte[] buffer = this.getByteTransform().TransByte(value, alreadyFinished, writeLength);
            OperateResultExOne<byte[]> command = SiemensS7Net.BuildWriteByteCommand(analysis, buffer);
            if (!command.IsSuccess) {
                return command;
            }
            OperateResult write = this.WriteBase((byte[])command.Content);
            if (!write.IsSuccess) {
                return write;
            }
            OperateResultExThree<Byte, Integer, Integer> operateResultExThree = analysis;
            Integer.valueOf((Integer)operateResultExThree.Content2 + writeLength * 8);
            operateResultExThree.Content2 = operateResultExThree.Content2;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        OperateResultExOne<byte[]> command = SiemensS7Net.BuildWriteBitCommand(address, value);
        if (!command.IsSuccess) {
            return command;
        }
        return this.WriteBase((byte[])command.Content);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        return this.Write(address, SoftBasic.BoolArrayToByte(values));
    }

    public OperateResult Write(String address, byte value) {
        return this.Write(address, new byte[]{value});
    }

    public OperateResultExOne<String> ReadString(String address) {
        if (this.CurrentPlc != SiemensPLCS.S200Smart) {
            OperateResultExOne<byte[]> read = this.Read(address, (short)2);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            if (((byte[])read.Content)[0] != -2) {
                return new OperateResultExOne<String>("Value in plc is not string type");
            }
            OperateResultExOne<byte[]> readString = this.Read(address, (short)(2 + ((byte[])read.Content)[1]));
            if (!readString.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(readString);
            }
            try {
                byte[] buffer = new byte[((byte[])read.Content)[1]];
                System.arraycopy(readString.Content, 2, buffer, 0, buffer.length);
                return OperateResultExOne.CreateSuccessResult(new String(buffer, StandardCharsets.US_ASCII));
            }
            catch (Exception ex) {
                return new OperateResultExOne<String>(ex.getMessage());
            }
        }
        OperateResultExOne<byte[]> read = this.Read(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> readString = this.Read(address, (short)(1 + ((byte[])read.Content)[0]));
        if (!readString.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(readString);
        }
        try {
            byte[] buffer = new byte[((byte[])read.Content)[0]];
            System.arraycopy(readString.Content, 1, buffer, 0, buffer.length);
            return OperateResultExOne.CreateSuccessResult(new String(buffer, StandardCharsets.US_ASCII));
        }
        catch (Exception ex) {
            return new OperateResultExOne<String>(ex.getMessage());
        }
    }

    @Override
    public OperateResult Write(String address, String value) {
        byte[] temp = this.getByteTransform().TransByte(value, "US-ASCII");
        if (this.WordLength == 1) {
            temp = SoftBasic.ArrayExpandToLengthEven(temp);
        }
        if (this.CurrentPlc != SiemensPLCS.S200Smart) {
            return this.Write(address, SoftBasic.SpliceTwoByteArray(new byte[]{-2, (byte)temp.length}, temp));
        }
        return this.Write(address, SoftBasic.SpliceTwoByteArray(new byte[]{(byte)temp.length}, temp));
    }

    public OperateResultExOne<Date> ReadDateTime(String address) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)8);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        try {
            return OperateResultExOne.CreateSuccessResult(SiemensDateTime.FromByteArray((byte[])read.Content));
        }
        catch (Exception ex) {
            return new OperateResultExOne<Date>(ex.getMessage());
        }
    }

    public OperateResult Write(String address, Date dateTime) {
        try {
            return this.Write(address, SiemensDateTime.ToByteArray(dateTime));
        }
        catch (Exception ex) {
            return new OperateResult(ex.getMessage());
        }
    }

    @Override
    public String toString() {
        return "SiemensS7Net";
    }

    public static int CalculateAddressStarted(String address) {
        if (address.indexOf(46) < 0) {
            return Integer.parseInt(address) * 8;
        }
        String[] temp = address.split("\\.");
        return Integer.parseInt(temp[0]) * 8 + Integer.parseInt(temp[1]);
    }

    public static OperateResultExThree<Byte, Integer, Integer> AnalysisAddress(String address) {
        OperateResultExThree<Byte, Integer, Integer> result;
        block9: {
            result = new OperateResultExThree<Byte, Integer, Integer>();
            try {
                result.Content3 = 0;
                if (address.charAt(0) == 'I') {
                    result.Content1 = (byte)-127;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                if (address.charAt(0) == 'Q') {
                    result.Content1 = (byte)-126;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                if (address.charAt(0) == 'M') {
                    result.Content1 = (byte)-125;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                if (address.charAt(0) == 'D' || address.substring(0, 2) == "DB") {
                    result.Content1 = (byte)-124;
                    String[] adds = address.split("\\.");
                    result.Content3 = address.charAt(1) == 'B' ? Integer.valueOf(Integer.parseInt(adds[0].substring(2))) : Integer.valueOf(Integer.parseInt(adds[0].substring(1)));
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(address.indexOf(46) + 1));
                    break block9;
                }
                if (address.charAt(0) == 'T') {
                    result.Content1 = 29;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                if (address.charAt(0) == 'C') {
                    result.Content1 = 28;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                if (address.charAt(0) == 'V') {
                    result.Content1 = (byte)-124;
                    result.Content3 = 1;
                    result.Content2 = SiemensS7Net.CalculateAddressStarted(address.substring(1));
                    break block9;
                }
                return new OperateResultExThree<Byte, Integer, Integer>(StringResources.Language.NotSupportedDataType());
            }
            catch (Exception ex) {
                result.Message = ex.getMessage();
                return result;
            }
        }
        result.IsSuccess = true;
        return result;
    }

    public static OperateResultExOne<byte[]> BuildReadCommand(String address, short length) {
        OperateResultExThree<Byte, Integer, Integer> analysis = SiemensS7Net.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        OperateResultExThree[] addressList = new OperateResultExThree[]{analysis};
        short[] lengthList = new short[]{length};
        return SiemensS7Net.BuildReadCommand(addressList, lengthList);
    }

    public static OperateResultExOne<byte[]> BuildReadCommand(OperateResultExThree<Byte, Integer, Integer>[] address, short[] length) {
        if (address == null) {
            throw new RuntimeException("address is null");
        }
        if (length == null) {
            throw new RuntimeException("count is null");
        }
        if (address.length != length.length) {
            throw new RuntimeException(StringResources.Language.TwoParametersLengthIsNotSame());
        }
        if (length.length > 19) {
            throw new RuntimeException(StringResources.Language.SiemensReadLengthCannotLargerThan19());
        }
        int readCount = length.length;
        byte[] _PLCCommand = new byte[19 + readCount * 12];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)(_PLCCommand.length / 256);
        _PLCCommand[3] = (byte)(_PLCCommand.length % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = (byte)((_PLCCommand.length - 17) / 256);
        _PLCCommand[14] = (byte)((_PLCCommand.length - 17) % 256);
        _PLCCommand[15] = 0;
        _PLCCommand[16] = 0;
        _PLCCommand[17] = 4;
        _PLCCommand[18] = (byte)readCount;
        for (int ii = 0; ii < readCount; ++ii) {
            _PLCCommand[19 + ii * 12] = 18;
            _PLCCommand[20 + ii * 12] = 10;
            _PLCCommand[21 + ii * 12] = 16;
            _PLCCommand[22 + ii * 12] = 2;
            _PLCCommand[23 + ii * 12] = (byte)(length[ii] / 256);
            _PLCCommand[24 + ii * 12] = (byte)(length[ii] % 256);
            _PLCCommand[25 + ii * 12] = (byte)((Integer)address[ii].Content3 / 256);
            _PLCCommand[26 + ii * 12] = (byte)((Integer)address[ii].Content3 % 256);
            _PLCCommand[27 + ii * 12] = (Byte)address[ii].Content1;
            _PLCCommand[28 + ii * 12] = (byte)((Integer)address[ii].Content2 / 256 / 256 % 256);
            _PLCCommand[29 + ii * 12] = (byte)((Integer)address[ii].Content2 / 256 % 256);
            _PLCCommand[30 + ii * 12] = (byte)((Integer)address[ii].Content2 % 256);
        }
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> BuildBitReadCommand(String address) {
        byte[] _PLCCommand = new byte[31];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)(_PLCCommand.length / 256);
        _PLCCommand[3] = (byte)(_PLCCommand.length % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = (byte)((_PLCCommand.length - 17) / 256);
        _PLCCommand[14] = (byte)((_PLCCommand.length - 17) % 256);
        _PLCCommand[15] = 0;
        _PLCCommand[16] = 0;
        _PLCCommand[17] = 4;
        _PLCCommand[18] = 1;
        OperateResultExThree<Byte, Integer, Integer> analysis = SiemensS7Net.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 1;
        _PLCCommand[23] = 0;
        _PLCCommand[24] = 1;
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256 % 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256 % 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> BuildWriteByteCommand(String address, byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        OperateResultExThree<Byte, Integer, Integer> analysis = SiemensS7Net.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        return SiemensS7Net.BuildWriteByteCommand(analysis, data);
    }

    public static OperateResultExOne<byte[]> BuildWriteByteCommand(OperateResultExThree<Byte, Integer, Integer> analysis, byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        byte[] _PLCCommand = new byte[35 + data.length];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)((35 + data.length) / 256);
        _PLCCommand[3] = (byte)((35 + data.length) % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = 0;
        _PLCCommand[14] = 14;
        _PLCCommand[15] = (byte)((4 + data.length) / 256);
        _PLCCommand[16] = (byte)((4 + data.length) % 256);
        _PLCCommand[17] = 5;
        _PLCCommand[18] = 1;
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 2;
        _PLCCommand[23] = (byte)(data.length / 256);
        _PLCCommand[24] = (byte)(data.length % 256);
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256 % 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256 % 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        _PLCCommand[31] = 0;
        _PLCCommand[32] = 4;
        _PLCCommand[33] = (byte)(data.length * 8 / 256);
        _PLCCommand[34] = (byte)(data.length * 8 % 256);
        System.arraycopy(data, 0, _PLCCommand, 35, data.length);
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> BuildWriteBitCommand(String address, boolean data) {
        OperateResultExThree<Byte, Integer, Integer> analysis = SiemensS7Net.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        byte[] buffer = new byte[]{data ? (byte)1 : 0};
        byte[] _PLCCommand = new byte[35 + buffer.length];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)((35 + buffer.length) / 256);
        _PLCCommand[3] = (byte)((35 + buffer.length) % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = 0;
        _PLCCommand[14] = 14;
        _PLCCommand[15] = (byte)((4 + buffer.length) / 256);
        _PLCCommand[16] = (byte)((4 + buffer.length) % 256);
        _PLCCommand[17] = 5;
        _PLCCommand[18] = 1;
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 1;
        _PLCCommand[23] = (byte)(buffer.length / 256);
        _PLCCommand[24] = (byte)(buffer.length % 256);
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        _PLCCommand[31] = 0;
        _PLCCommand[32] = 3;
        _PLCCommand[33] = (byte)(buffer.length / 256);
        _PLCCommand[34] = (byte)(buffer.length % 256);
        System.arraycopy(buffer, 0, _PLCCommand, 35, buffer.length);
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }
}

