/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OutputFileInfo {
    private String fileType;
    private String outputLocation;
    private String templateName;
    private String templatePath;
    private boolean builtIn;

    public String getOutputPackage() {
        if (Strings.isNullOrEmpty((String)this.outputLocation)) {
            return "";
        }
        if (this.outputLocation.startsWith("resources:")) {
            return this.outputLocation.replaceFirst("resources:", "");
        }
        if (this.outputLocation.startsWith("java:")) {
            return this.outputLocation.replaceFirst("java:", "");
        }
        return this.outputLocation;
    }

    @JsonIgnore
    public String getAvailableTemplatePath() {
        if (!Strings.isNullOrEmpty((String)this.templatePath)) {
            return this.templatePath;
        }
        if (this.fileType.equals("Entity")) {
            return "classpath:codetpls/entity.java.btl";
        }
        if (this.fileType.equals("Mapper.java")) {
            return "classpath:codetpls/mapper.java.btl";
        }
        if (this.fileType.equals("Mapper.xml")) {
            return "classpath:codetpls/mapper.xml.btl";
        }
        if (this.fileType.equals("Service")) {
            return "classpath:codetpls/service.java.btl";
        }
        if (this.fileType.equals("ServiceImpl")) {
            return "classpath:codetpls/serviceImpl.java.btl";
        }
        if (this.fileType.equals("Controller")) {
            return "classpath:codetpls/controller.java.btl";
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof OutputFileInfo) {
            OutputFileInfo file = (OutputFileInfo)obj;
            if (file.getFileType() == null || this.getFileType() == null) {
                return false;
            }
            return file.getFileType().equalsIgnoreCase(this.getFileType());
        }
        return false;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public String toString() {
        return "OutputFileInfo(fileType=" + this.getFileType() + ", outputLocation=" + this.getOutputLocation() + ", templateName=" + this.getTemplateName() + ", templatePath=" + this.getTemplatePath() + ", builtIn=" + this.isBuiltIn() + ")";
    }
}

