/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.mbp;

import cn.hutool.core.util.StrUtil;
import com.google.common.base.Strings;

public interface NameConverter {
    default public String entityNameConvert(String tableName, String tablePrefix) {
        if (Strings.isNullOrEmpty((String)tableName)) {
            return "";
        }
        if (!StrUtil.isBlank((CharSequence)tablePrefix) && tableName.startsWith(tablePrefix)) {
            tableName = tableName.substring(tablePrefix.length());
        }
        return StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)tableName.toLowerCase()));
    }

    default public String propertyNameConvert(String fieldName) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            return "";
        }
        if (fieldName.contains("_")) {
            return StrUtil.toCamelCase((CharSequence)fieldName.toLowerCase());
        }
        return fieldName;
    }

    default public String mapperNameConvert(String entityName) {
        return entityName + "Mapper";
    }

    default public String mapperXmlNameConvert(String entityName) {
        return entityName + "Mapper";
    }

    default public String serviceNameConvert(String entityName) {
        return "I" + entityName + "Service";
    }

    default public String serviceImplNameConvert(String entityName) {
        return entityName + "ServiceImpl";
    }

    default public String controllerNameConvert(String entityName) {
        return entityName + "Controller";
    }

    default public String customFileNameConvert(String fileType, String entityName) {
        return entityName + fileType;
    }
}

