/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;

public class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String obj2json(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u5c06\u5bf9\u8c61\u8f6c\u6362\u4e3aJSON\u65f6\u53d1\u751f\u9519\u8bef\uff01", e);
        }
    }

    public static <T> T json2obj(String jsonStr, Class<T> clazz) {
        try {
            return (T)mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u5c06JSON\u8f6c\u6362\u4e3a\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef:" + jsonStr, e);
        }
    }

    public static <T> T json2obj(String jsonStr, TypeReference<T> clazzType) {
        try {
            return (T)mapper.readValue(jsonStr, clazzType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u5c06JSON\u8f6c\u6362\u4e3a\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef:" + jsonStr, e);
        }
    }

    public static <T> T json2obj(String content, String path, Class<T> clazz) throws IOException {
        if (!Strings.isNullOrEmpty((String)path)) {
            String[] pathes;
            JsonNode node = mapper.readTree(content);
            for (String p : pathes = path.split("\\.")) {
                node = node.get(p);
            }
            content = node.toString();
        }
        return JsonUtil.json2obj(content, clazz);
    }

    public static <T> T json2obj(String content, String path, TypeReference<T> clazzType) throws IOException {
        if (!Strings.isNullOrEmpty((String)path)) {
            String[] pathes;
            JsonNode node = mapper.readTree(content);
            for (String p : pathes = path.split("\\.")) {
                node = node.get(p);
            }
            content = node.toString();
        }
        return JsonUtil.json2obj(content, clazzType);
    }
}

