/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree.internal.Line2D;
import com.github.davidmoten.rtree.internal.RectangleUtil;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class LineFloat
implements Line {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    private LineFloat(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static LineFloat create(double x1, double y1, double x2, double y2) {
        return new LineFloat(x1, y1, x2, y2);
    }

    @Override
    public double distance(Rectangle r) {
        if (r.contains(this.x1, this.y1) || r.contains(this.x2, this.y2)) {
            return 0.0;
        }
        double d1 = this.distance(r.x1(), r.y1(), r.x1(), r.y2());
        if (d1 == 0.0) {
            return 0.0;
        }
        double d2 = this.distance(r.x1(), r.y2(), r.x2(), r.y2());
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.distance(r.x2(), r.y2(), r.x2(), r.y1());
        double d4 = this.distance(r.x2(), r.y1(), r.x1(), r.y1());
        return Math.min(d1, Math.min(d2, Math.min(d3, d4)));
    }

    private double distance(double x1, double y1, double x2, double y2) {
        Line2D line = new Line2D(x1, y1, x2, y2);
        double d1 = line.ptSegDist(this.x1, this.y1);
        double d2 = line.ptSegDist(this.x2, this.y2);
        Line2D line2 = new Line2D(this.x1, this.y1, this.x2, this.y2);
        double d3 = line2.ptSegDist(x1, y1);
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = line2.ptSegDist(x2, y2);
        if (d4 == 0.0) {
            return 0.0;
        }
        return Math.min(d1, Math.min(d2, Math.min(d3, d4)));
    }

    @Override
    public Rectangle mbr() {
        return Geometries.rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.max(this.x1, this.x2), Math.max(this.y1, this.y2));
    }

    @Override
    public boolean intersects(Rectangle r) {
        return RectangleUtil.rectangleIntersectsLine(r.x1(), r.y1(), r.x2() - r.x1(), r.y2() - r.y1(), this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public double x1() {
        return this.x1;
    }

    @Override
    public double y1() {
        return this.y1;
    }

    @Override
    public double x2() {
        return this.x2;
    }

    @Override
    public double y2() {
        return this.y2;
    }

    @Override
    public boolean intersects(Line b) {
        Line2D line1 = new Line2D(this.x1, this.y1, this.x2, this.y2);
        Line2D line2 = new Line2D(b.x1(), b.y1(), b.x2(), b.y2());
        return line2.intersectsLine(line1);
    }

    @Override
    public boolean intersects(Point point) {
        return this.intersects(point.mbr());
    }

    @Override
    public boolean intersects(Circle circle) {
        return GeometryUtil.lineIntersects(this.x1, this.y1, this.x2, this.y2, circle);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x1, this.y1, this.x2, this.y2});
    }

    public boolean equals(Object obj) {
        Optional<LineFloat> other = ObjectsHelper.asClass(obj, LineFloat.class);
        if (other.isPresent()) {
            return Objects.equal((Object)this.x1, (Object)((LineFloat)other.get()).x1) && Objects.equal((Object)this.x2, (Object)((LineFloat)other.get()).x2) && Objects.equal((Object)this.y1, (Object)((LineFloat)other.get()).y1) && Objects.equal((Object)this.y2, (Object)((LineFloat)other.get()).y2);
        }
        return false;
    }

    @Override
    public boolean isDoublePrecision() {
        return false;
    }
}

