/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class EntryDefault<T, S extends Geometry>
implements Entry<T, S> {
    private final T value;
    private final S geometry;

    public EntryDefault(T value, S geometry) {
        Preconditions.checkNotNull(geometry);
        this.value = value;
        this.geometry = geometry;
    }

    public static <T, S extends Geometry> Entry<T, S> entry(T value, S geometry) {
        return new EntryDefault<T, S>(value, geometry);
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public S geometry() {
        return this.geometry;
    }

    public String toString() {
        String builder = "Entry [value=" + this.value + ", geometry=" + this.geometry + "]";
        return builder;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.geometry});
    }

    public boolean equals(Object obj) {
        Optional<EntryDefault> other = ObjectsHelper.asClass(obj, EntryDefault.class);
        if (other.isPresent()) {
            return Objects.equal(this.value, ((EntryDefault)other.get()).value) && Objects.equal(this.geometry, ((EntryDefault)other.get()).geometry);
        }
        return false;
    }
}

