/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerBeanMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.builder.BeanMappingsBuilder;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.builder.xml.BeanMappingXMLBuilder;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.config.Settings;
import org.dozer.config.processors.DefaultSettingsProcessor;
import org.dozer.config.processors.SettingsProcessor;
import org.dozer.el.DefaultELEngine;
import org.dozer.el.ELEngine;
import org.dozer.el.ELExpressionFactory;
import org.dozer.el.NoopELEngine;
import org.dozer.el.TcclELEngine;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.MappingsParser;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.ElementReader;
import org.dozer.loader.xml.ExpressionElementReader;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParser;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.osgi.Activator;
import org.dozer.osgi.OSGiClassLoader;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingValidator;
import org.dozer.util.RuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DozerBeanMapperBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DozerBeanMapperBuilder.class);
    private List<String> mappingFiles = new ArrayList<String>(1);
    private DozerClassLoader classLoader;
    private List<CustomConverter> customConverters = new ArrayList<CustomConverter>(0);
    private List<Supplier<InputStream>> xmlMappingSuppliers = new ArrayList<Supplier<InputStream>>(0);
    private List<BeanMappingBuilder> mappingBuilders = new ArrayList<BeanMappingBuilder>(0);
    private List<BeanMappingsBuilder> beanMappingsBuilders = new ArrayList<BeanMappingsBuilder>(0);
    private List<DozerEventListener> eventListeners = new ArrayList<DozerEventListener>(0);
    private CustomFieldMapper customFieldMapper;
    private Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>(0);
    private Map<String, BeanFactory> beanFactories = new HashMap<String, BeanFactory>(0);
    private SettingsProcessor settingsProcessor;
    private ELEngine elEngine;
    private ElementReader elementReader;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;

    private DozerBeanMapperBuilder() {
    }

    public static DozerBeanMapperBuilder create() {
        return new DozerBeanMapperBuilder();
    }

    public static Mapper buildDefault() {
        DozerBeanMapperBuilder builder = DozerBeanMapperBuilder.create();
        DozerClassLoader classLoader = builder.getClassLoader();
        URL defaultMappingFile = classLoader.loadResource("dozerBeanMapping.xml");
        if (defaultMappingFile != null) {
            builder.withMappingFiles("dozerBeanMapping.xml");
        }
        return builder.withClassLoader(classLoader).build();
    }

    public DozerBeanMapperBuilder withMappingFiles(String ... mappingFiles) {
        return this.withMappingFiles(Arrays.asList(mappingFiles));
    }

    public DozerBeanMapperBuilder withMappingFiles(List<String> mappingFiles) {
        if (mappingFiles != null) {
            this.mappingFiles.addAll(mappingFiles);
        }
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(DozerClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = new DefaultClassLoader(classLoader);
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverter(CustomConverter customConverter) {
        return this.withCustomConverters(customConverter);
    }

    public DozerBeanMapperBuilder withCustomConverters(CustomConverter ... customConverters) {
        return this.withCustomConverters(Arrays.asList(customConverters));
    }

    public DozerBeanMapperBuilder withCustomConverters(List<CustomConverter> customConverters) {
        if (customConverters != null) {
            this.customConverters.addAll(customConverters);
        }
        return this;
    }

    public DozerBeanMapperBuilder withXmlMapping(Supplier<InputStream> xmlMappingSupplier) {
        this.xmlMappingSuppliers.add(xmlMappingSupplier);
        return this;
    }

    public DozerBeanMapperBuilder withMappingBuilder(BeanMappingBuilder mappingBuilder) {
        return this.withMappingBuilders(mappingBuilder);
    }

    public DozerBeanMapperBuilder withMappingBuilders(BeanMappingBuilder ... mappingBuilders) {
        return this.withMappingBuilders(Arrays.asList(mappingBuilders));
    }

    public DozerBeanMapperBuilder withMappingBuilders(List<BeanMappingBuilder> mappingBuilders) {
        if (mappingBuilders != null) {
            this.mappingBuilders.addAll(mappingBuilders);
        }
        return this;
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(BeanMappingsBuilder beanMappingsBuilder) {
        return this.withBeanMappingsBuilders(Arrays.asList(beanMappingsBuilder));
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(BeanMappingsBuilder ... beanMappingsBuilder) {
        return this.withBeanMappingsBuilders(Arrays.asList(beanMappingsBuilder));
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(List<BeanMappingsBuilder> beanMappingsBuilder) {
        if (beanMappingsBuilder != null) {
            this.beanMappingsBuilders.addAll(beanMappingsBuilder);
        }
        return this;
    }

    public DozerBeanMapperBuilder withEventListener(DozerEventListener eventListener) {
        return this.withEventListeners(eventListener);
    }

    public DozerBeanMapperBuilder withEventListeners(DozerEventListener ... eventListeners) {
        return this.withEventListeners(Arrays.asList(eventListeners));
    }

    public DozerBeanMapperBuilder withEventListeners(List<DozerEventListener> eventListeners) {
        if (eventListeners != null) {
            this.eventListeners.addAll(eventListeners);
        }
        return this;
    }

    public DozerBeanMapperBuilder withCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverterWithId(String converterId, CustomConverter converter) {
        this.customConvertersWithId.put(converterId, converter);
        return this;
    }

    public DozerBeanMapperBuilder withCustomConvertersWithIds(Map<String, CustomConverter> customConvertersWithId) {
        if (customConvertersWithId != null) {
            this.customConvertersWithId.putAll(customConvertersWithId);
        }
        return this;
    }

    public DozerBeanMapperBuilder withBeanFactory(String factoryName, BeanFactory beanFactory) {
        this.beanFactories.put(factoryName, beanFactory);
        return this;
    }

    public DozerBeanMapperBuilder withBeanFactorys(Map<String, BeanFactory> beanFactories) {
        if (beanFactories != null) {
            this.beanFactories.putAll(beanFactories);
        }
        return this;
    }

    public DozerBeanMapperBuilder withSettingsProcessor(SettingsProcessor processor) {
        this.settingsProcessor = this.settingsProcessor;
        return this;
    }

    public DozerBeanMapperBuilder withELEngine(ELEngine elEngine) {
        this.elEngine = elEngine;
        return this;
    }

    public DozerBeanMapperBuilder withElementReader(ElementReader elementReader) {
        this.elementReader = elementReader;
        return this;
    }

    public Mapper build() {
        LOG.info("Initializing a new instance of dozer bean mapper.");
        DozerClassLoader classLoader = this.getClassLoader();
        Settings settings = this.getSettings(classLoader);
        ELEngine elEngine = this.getELEngine();
        ElementReader elementReader = this.getElementReader(elEngine);
        BeanContainer beanContainer = new BeanContainer();
        beanContainer.setElEngine(elEngine);
        beanContainer.setElementReader(elementReader);
        beanContainer.setClassLoader(classLoader);
        DestBeanCreator destBeanCreator = new DestBeanCreator(beanContainer);
        destBeanCreator.setStoredFactories(this.beanFactories);
        PropertyDescriptorFactory propertyDescriptorFactory = new PropertyDescriptorFactory();
        BeanMappingGenerator beanMappingGenerator = new BeanMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory);
        DestBeanBuilderCreator destBeanBuilderCreator = new DestBeanBuilderCreator();
        XMLParser xmlParser = new XMLParser(beanContainer, destBeanCreator, propertyDescriptorFactory);
        XMLParserFactory xmlParserFactory = new XMLParserFactory(beanContainer);
        DozerInitializer dozerInitializer = new DozerInitializer();
        dozerInitializer.init(settings, beanContainer, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, destBeanCreator);
        ArrayList<MappingFileData> mappingsFileData = new ArrayList<MappingFileData>();
        if (settings.getUseJaxbMappingEngine().booleanValue()) {
            mappingsFileData.addAll(this.buildXmlMappings(beanContainer, destBeanCreator, propertyDescriptorFactory, elEngine));
        } else {
            mappingsFileData.addAll(this.readXmlMappings(xmlParserFactory, xmlParser));
            mappingsFileData.addAll(this.loadFromFiles(this.mappingFiles, xmlParserFactory, xmlParser, beanContainer));
        }
        mappingsFileData.addAll(this.buildGenericMappings(beanContainer, destBeanCreator, propertyDescriptorFactory));
        mappingsFileData.addAll(this.createMappingsWithBuilders(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.loadCustomMappings(mappingsFileData, beanContainer, propertyDescriptorFactory, beanMappingGenerator, destBeanCreator);
        return new DozerBeanMapper(this.mappingFiles, settings, dozerInitializer, beanContainer, destBeanCreator, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, this.customConverters, mappingsFileData, this.eventListeners, this.customFieldMapper, this.customConvertersWithId, this.customMappings, this.globalConfiguration);
    }

    private List<MappingFileData> createMappingsWithBuilders(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        return this.mappingBuilders.stream().map(fluentBuilder -> fluentBuilder.build(beanContainer, destBeanCreator, propertyDescriptorFactory)).collect(Collectors.toList());
    }

    private List<MappingFileData> readXmlMappings(XMLParserFactory xmlParserFactory, XMLParser xmlParser) {
        return this.xmlMappingSuppliers.stream().map(xmlMappingSupplier -> {
            try (InputStream xmlMappingStream = (InputStream)xmlMappingSupplier.get();){
                MappingStreamReader fileReader = new MappingStreamReader(xmlParserFactory, xmlParser);
                MappingFileData mappingFileData = fileReader.read(xmlMappingStream);
                return mappingFileData;
            }
            catch (IOException e) {
                throw new MappingException(e);
            }
        }).collect(Collectors.toList());
    }

    private List<MappingFileData> buildXmlMappings(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory, ELEngine elEngine) {
        BeanMappingXMLBuilder builder = new BeanMappingXMLBuilder(beanContainer, elEngine);
        builder.loadFiles(this.mappingFiles);
        builder.loadInputStreams(this.xmlMappingSuppliers);
        return builder.build(beanContainer, destBeanCreator, propertyDescriptorFactory);
    }

    private List<MappingFileData> buildGenericMappings(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        return this.beanMappingsBuilders.stream().map(m -> m.build(beanContainer, destBeanCreator, propertyDescriptorFactory)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    private DozerClassLoader getClassLoader() {
        if (this.classLoader == null) {
            if (RuntimeUtils.isOSGi()) {
                return new OSGiClassLoader(Activator.getBundle().getBundleContext());
            }
            return new DefaultClassLoader(DozerBeanMapperBuilder.class.getClassLoader());
        }
        return this.classLoader;
    }

    private Settings getSettings(DozerClassLoader classLoader) {
        if (this.settingsProcessor == null) {
            this.settingsProcessor = new DefaultSettingsProcessor(classLoader);
            return this.settingsProcessor.process();
        }
        return this.settingsProcessor.process();
    }

    private ELEngine getELEngine() {
        if (this.elEngine == null) {
            if (ELExpressionFactory.isSupported().booleanValue()) {
                if (RuntimeUtils.isOSGi()) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    return new TcclELEngine(ELExpressionFactory.newInstance(classLoader), classLoader);
                }
                return new DefaultELEngine(ELExpressionFactory.newInstance());
            }
            return new NoopELEngine();
        }
        return this.elEngine;
    }

    private ElementReader getElementReader(ELEngine elEngine) {
        if (this.elementReader == null) {
            return new ExpressionElementReader(elEngine);
        }
        return this.elementReader;
    }

    private void loadCustomMappings(List<MappingFileData> allMappings, BeanContainer beanContainer, PropertyDescriptorFactory propertyDescriptorFactory, BeanMappingGenerator beanMappingGenerator, DestBeanCreator destBeanCreator) {
        MappingsParser mappingsParser = new MappingsParser(beanContainer, destBeanCreator, propertyDescriptorFactory);
        ClassMapBuilder classMapBuilder = new ClassMapBuilder(beanContainer, destBeanCreator, beanMappingGenerator, propertyDescriptorFactory);
        CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader(mappingsParser, classMapBuilder, beanContainer);
        LoadMappingsResult loadMappingsResult = customMappingsLoader.load(allMappings);
        this.customMappings = loadMappingsResult.getCustomMappings();
        this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
    }

    private List<MappingFileData> loadFromFiles(List<String> mappingFiles, XMLParserFactory xmlParserFactory, XMLParser xmlParser, BeanContainer beanContainer) {
        MappingFileReader mappingFileReader = new MappingFileReader(xmlParserFactory, xmlParser, beanContainer);
        ArrayList<MappingFileData> mappingFileDataList = new ArrayList<MappingFileData>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            LOG.info("Using the following xml files to load custom mappings for the bean mapper instance: {}", mappingFiles);
            for (String mappingFileName : mappingFiles) {
                LOG.info("Trying to find xml mapping file: {}", (Object)mappingFileName);
                URL url = MappingValidator.validateURL(mappingFileName, beanContainer);
                LOG.info("Using URL [" + url + "] to load custom xml mappings");
                MappingFileData mappingFileData = mappingFileReader.read(url);
                LOG.info("Successfully loaded custom xml mappings from URL: [{}]", (Object)url);
                mappingFileDataList.add(mappingFileData);
            }
        }
        return mappingFileDataList;
    }
}

