/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.dozer.DozerModule;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.config.Settings;
import org.dozer.factory.DestBeanCreator;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.DozerProxyResolver;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DozerInitializer {
    private final Logger log = LoggerFactory.getLogger(DozerInitializer.class);
    private volatile boolean isInitialized;

    public void init(Settings settings, BeanContainer beanContainer, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, DestBeanCreator destBeanCreator) {
        this.init(settings, this.getClass().getClassLoader().getParent(), beanContainer, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, destBeanCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Settings settings, ClassLoader classLoader, BeanContainer beanContainer, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, DestBeanCreator destBeanCreator) {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (this.isInitialized) {
                this.log.debug("Tried to perform initialization when Dozer was already started.");
                return;
            }
            this.log.info("Initializing Dozer. Version: {}, Thread Name: {}", (Object)"6.2.0", (Object)Thread.currentThread().getName());
            this.initialize(settings, classLoader, beanContainer, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, destBeanCreator);
            this.isInitialized = true;
        }
    }

    void initialize(Settings settings, ClassLoader classLoader, BeanContainer beanContainer, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, DestBeanCreator destBeanCreator) {
        this.registerClassLoader(settings, classLoader, beanContainer);
        this.registerProxyResolver(settings, beanContainer);
        try {
            ServiceLoader<DozerModule> services = ServiceLoader.load(DozerModule.class);
            for (DozerModule module : services) {
                module.init();
                module.init(beanContainer, destBeanCreator, propertyDescriptorFactory);
                destBeanBuilderCreator.addPluggedStrategies(module.getBeanBuilderCreationStrategies());
                beanMappingGenerator.addPluggedFieldDetectors(module.getBeanFieldsDetectors());
                propertyDescriptorFactory.addPluggedPropertyDescriptorCreationStrategies(module.getPropertyDescriptorCreationStrategies());
            }
        }
        catch (ServiceConfigurationError ex) {
            this.log.error("{}", (Object)ex.getMessage());
        }
    }

    private void registerClassLoader(Settings settings, ClassLoader classLoader, BeanContainer beanContainer) {
        String classLoaderName = settings.getClassLoaderBeanName();
        if (!"org.dozer.util.DefaultClassLoader".equals(classLoaderName)) {
            DefaultClassLoader defaultClassLoader = new DefaultClassLoader(classLoader);
            Class<DozerClassLoader> classLoaderType = this.loadBeanType(classLoaderName, defaultClassLoader, DozerClassLoader.class);
            DozerClassLoader classLoaderBean = ReflectionUtils.newInstance(classLoaderType);
            beanContainer.setClassLoader(classLoaderBean);
        }
    }

    private void registerProxyResolver(Settings settings, BeanContainer beanContainer) {
        String proxyResolverName = settings.getProxyResolverBeanName();
        if (!"org.dozer.util.DefaultProxyResolver".equals(proxyResolverName)) {
            DozerClassLoader initializedClassLoader = beanContainer.getClassLoader();
            Class<DozerProxyResolver> proxyResolverType = this.loadBeanType(proxyResolverName, initializedClassLoader, DozerProxyResolver.class);
            DozerProxyResolver proxyResolverBean = ReflectionUtils.newInstance(proxyResolverType);
            beanContainer.setProxyResolver(proxyResolverBean);
        }
    }

    private <T> Class<? extends T> loadBeanType(String classLoaderName, DozerClassLoader classLoader, Class<T> iface) {
        Class<?> beanType = classLoader.loadClass(classLoaderName);
        if (beanType != null && !iface.isAssignableFrom(beanType)) {
            MappingUtils.throwMappingException("Incompatible types: " + iface.getName() + " and " + classLoaderName);
        }
        return beanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Settings settings) {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (!this.isInitialized) {
                this.log.debug("Tried to destroy when no Dozer instance started.");
                return;
            }
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

