/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.builder.model.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.dozer.builder.model.jaxb.ClassDefinition;
import org.dozer.builder.model.jaxb.FieldDefinition;
import org.dozer.builder.model.jaxb.FieldExcludeDefinition;
import org.dozer.builder.model.jaxb.MappingsDefinition;
import org.dozer.builder.model.jaxb.Relationship;
import org.dozer.builder.model.jaxb.Type;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.RelationshipType;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.FieldMap;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="mapping")
public class MappingDefinition {
    @XmlTransient
    private final MappingsDefinition parent;
    @XmlElement(name="class-a", required=true)
    protected ClassDefinition classA;
    @XmlElement(name="class-b", required=true)
    protected ClassDefinition classB;
    @XmlElements(value={@XmlElement(name="field", type=FieldDefinition.class), @XmlElement(name="field-exclude", type=FieldExcludeDefinition.class)})
    protected List<Object> fieldOrFieldExclude;
    @XmlTransient
    protected List<FieldDefinition> fields;
    @XmlTransient
    protected List<FieldExcludeDefinition> fieldExcludes;
    @XmlAttribute(name="date-format")
    protected String dateFormat;
    @XmlAttribute(name="stop-on-errors")
    protected Boolean stopOnErrors;
    @XmlAttribute(name="wildcard")
    protected Boolean wildcard;
    @XmlAttribute(name="wildcard-case-insensitive")
    protected Boolean wildcardCaseInsensitive;
    @XmlAttribute(name="trim-strings")
    protected Boolean trimStrings;
    @XmlAttribute(name="map-null")
    protected Boolean mapNull;
    @XmlAttribute(name="map-empty-string")
    protected Boolean mapEmptyString;
    @XmlAttribute(name="bean-factory")
    protected String beanFactory;
    @XmlAttribute(name="type")
    protected Type type;
    @XmlAttribute(name="relationship-type")
    protected Relationship relationshipType;
    @XmlAttribute(name="map-id")
    protected String mapId;

    public MappingDefinition() {
        this(null);
    }

    public MappingDefinition(MappingsDefinition parent) {
        this.parent = parent;
    }

    public ClassDefinition withClassA() {
        ClassDefinition classA = new ClassDefinition(this, null);
        this.setClassA(classA);
        return classA;
    }

    public ClassDefinition withClassB() {
        ClassDefinition classB = new ClassDefinition(this, null);
        this.setClassB(classB);
        return classB;
    }

    public FieldDefinition withField() {
        if (this.getFields() == null) {
            this.setFields(new ArrayList<FieldDefinition>());
        }
        FieldDefinition field = new FieldDefinition(this, null);
        this.getFields().add(field);
        return field;
    }

    public FieldExcludeDefinition withFieldExclude() {
        if (this.getFieldExcludes() == null) {
            this.setFieldExcludes(new ArrayList<FieldExcludeDefinition>());
        }
        FieldExcludeDefinition fieldExclude = new FieldExcludeDefinition(this);
        this.getFieldExcludes().add(fieldExclude);
        return fieldExclude;
    }

    public MappingDefinition withDateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public MappingDefinition withStopOnErrors(Boolean stopOnErrors) {
        this.setStopOnErrors(stopOnErrors);
        return this;
    }

    public MappingDefinition withWildcard(Boolean wildcard) {
        this.setWildcard(wildcard);
        return this;
    }

    public MappingDefinition withWildcardCaseInsensitive(Boolean wildcardCaseInsensitive) {
        this.setWildcardCaseInsensitive(wildcardCaseInsensitive);
        return this;
    }

    public MappingDefinition withTrimStrings(Boolean trimStrings) {
        this.setTrimStrings(trimStrings);
        return this;
    }

    public MappingDefinition withMapNull(Boolean mapNull) {
        this.setMapNull(mapNull);
        return this;
    }

    public MappingDefinition withMapEmptyString(Boolean mapEmptyString) {
        this.setMapEmptyString(mapEmptyString);
        return this;
    }

    public MappingDefinition withBeanFactory(String beanFactory) {
        this.setBeanFactory(beanFactory);
        return this;
    }

    public MappingDefinition withType(Type type) {
        this.setType(type);
        return this;
    }

    public MappingDefinition withRelationshipType(Relationship relationshipType) {
        this.setRelationshipType(relationshipType);
        return this;
    }

    public MappingDefinition withMapId(String mapId) {
        this.setMapId(mapId);
        return this;
    }

    public MappingsDefinition end() {
        return this.parent;
    }

    public ClassMap build(Configuration configuration, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.separateFieldOrFieldExclude();
        ClassMap current = new ClassMap(configuration);
        current.setSrcClass(this.classA.build(beanContainer));
        current.setDestClass(this.classB.build(beanContainer));
        current.setType(MappingDirection.valueOf(this.type == null ? Type.BI_DIRECTIONAL.value() : this.type.value()));
        current.setDateFormat(this.dateFormat);
        current.setBeanFactory(this.beanFactory);
        if (this.mapNull != null) {
            current.setMapNull(this.mapNull);
        }
        if (this.mapEmptyString != null) {
            current.setMapEmptyString(this.mapEmptyString);
        }
        current.setWildcard(this.wildcard);
        current.setWildcardCaseInsensitive(this.wildcardCaseInsensitive);
        current.setStopOnErrors(this.stopOnErrors);
        current.setTrimStrings(this.trimStrings);
        current.setMapId(this.mapId);
        current.setRelationshipType(RelationshipType.valueOf(this.relationshipType == null ? Relationship.CUMULATIVE.value() : this.relationshipType.value()));
        current.setFieldMaps(this.convertFieldMap(current, beanContainer, destBeanCreator, propertyDescriptorFactory));
        return current;
    }

    private void separateFieldOrFieldExclude() {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDefinition>();
        }
        if (this.fieldExcludes == null) {
            this.fieldExcludes = new ArrayList<FieldExcludeDefinition>();
        }
        if (this.fieldOrFieldExclude != null) {
            for (Object current : this.fieldOrFieldExclude) {
                if (current instanceof FieldDefinition) {
                    this.fields.add((FieldDefinition)current);
                    continue;
                }
                if (current instanceof FieldExcludeDefinition) {
                    this.fieldExcludes.add((FieldExcludeDefinition)current);
                    continue;
                }
                throw new IllegalStateException("Unexpected type found; " + current.getClass().getCanonicalName());
            }
        }
    }

    private List<FieldMap> convertFieldMap(ClassMap classMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        ArrayList<FieldMap> answer = new ArrayList<FieldMap>();
        if (this.fields != null) {
            for (FieldDefinition fieldDefinition : this.fields) {
                answer.add(fieldDefinition.build(classMap, beanContainer, destBeanCreator, propertyDescriptorFactory));
            }
        }
        if (this.fieldExcludes != null) {
            for (FieldExcludeDefinition fieldExcludeDefinition : this.fieldExcludes) {
                answer.add(fieldExcludeDefinition.build(classMap, beanContainer, destBeanCreator, propertyDescriptorFactory));
            }
        }
        return answer;
    }

    public MappingsDefinition getParent() {
        return this.parent;
    }

    public ClassDefinition getClassA() {
        return this.classA;
    }

    public ClassDefinition getClassB() {
        return this.classB;
    }

    public List<Object> getFieldOrFieldExclude() {
        return this.fieldOrFieldExclude;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public List<FieldExcludeDefinition> getFieldExcludes() {
        return this.fieldExcludes;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public Boolean getStopOnErrors() {
        return this.stopOnErrors;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public Boolean getWildcardCaseInsensitive() {
        return this.wildcardCaseInsensitive;
    }

    public Boolean getTrimStrings() {
        return this.trimStrings;
    }

    public Boolean getMapNull() {
        return this.mapNull;
    }

    public Boolean getMapEmptyString() {
        return this.mapEmptyString;
    }

    public String getBeanFactory() {
        return this.beanFactory;
    }

    public Type getType() {
        return this.type;
    }

    public Relationship getRelationshipType() {
        return this.relationshipType;
    }

    public String getMapId() {
        return this.mapId;
    }

    protected void setClassA(ClassDefinition classA) {
        this.classA = classA;
    }

    protected void setClassB(ClassDefinition classB) {
        this.classB = classB;
    }

    protected void setFieldOrFieldExclude(List<Object> fieldOrFieldExclude) {
        this.fieldOrFieldExclude = fieldOrFieldExclude;
    }

    protected void setFields(List<FieldDefinition> fields) {
        this.fields = fields;
    }

    protected void setFieldExcludes(List<FieldExcludeDefinition> fieldExcludes) {
        this.fieldExcludes = fieldExcludes;
    }

    protected void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected void setStopOnErrors(Boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    protected void setWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
    }

    protected void setWildcardCaseInsensitive(Boolean wildcardCaseInsensitive) {
        this.wildcardCaseInsensitive = wildcardCaseInsensitive;
    }

    protected void setTrimStrings(Boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    protected void setMapNull(Boolean mapNull) {
        this.mapNull = mapNull;
    }

    protected void setMapEmptyString(Boolean mapEmptyString) {
        this.mapEmptyString = mapEmptyString;
    }

    protected void setBeanFactory(String beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void setType(Type type) {
        this.type = type;
    }

    protected void setRelationshipType(Relationship relationshipType) {
        this.relationshipType = relationshipType;
    }

    protected void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public String toString() {
        return "MappingDefinition(parent=" + this.getParent() + ", classA=" + this.getClassA() + ", classB=" + this.getClassB() + ", fieldOrFieldExclude=" + this.getFieldOrFieldExclude() + ", fields=" + this.getFields() + ", fieldExcludes=" + this.getFieldExcludes() + ", dateFormat=" + this.getDateFormat() + ", stopOnErrors=" + this.getStopOnErrors() + ", wildcard=" + this.getWildcard() + ", wildcardCaseInsensitive=" + this.getWildcardCaseInsensitive() + ", trimStrings=" + this.getTrimStrings() + ", mapNull=" + this.getMapNull() + ", mapEmptyString=" + this.getMapEmptyString() + ", beanFactory=" + this.getBeanFactory() + ", type=" + (Object)((Object)this.getType()) + ", relationshipType=" + (Object)((Object)this.getRelationshipType()) + ", mapId=" + this.getMapId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingDefinition)) {
            return false;
        }
        MappingDefinition other = (MappingDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MappingsDefinition this$parent = this.getParent();
        MappingsDefinition other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ClassDefinition this$classA = this.getClassA();
        ClassDefinition other$classA = other.getClassA();
        if (this$classA == null ? other$classA != null : !((Object)this$classA).equals(other$classA)) {
            return false;
        }
        ClassDefinition this$classB = this.getClassB();
        ClassDefinition other$classB = other.getClassB();
        if (this$classB == null ? other$classB != null : !((Object)this$classB).equals(other$classB)) {
            return false;
        }
        List<Object> this$fieldOrFieldExclude = this.getFieldOrFieldExclude();
        List<Object> other$fieldOrFieldExclude = other.getFieldOrFieldExclude();
        if (this$fieldOrFieldExclude == null ? other$fieldOrFieldExclude != null : !((Object)this$fieldOrFieldExclude).equals(other$fieldOrFieldExclude)) {
            return false;
        }
        List<FieldDefinition> this$fields = this.getFields();
        List<FieldDefinition> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<FieldExcludeDefinition> this$fieldExcludes = this.getFieldExcludes();
        List<FieldExcludeDefinition> other$fieldExcludes = other.getFieldExcludes();
        if (this$fieldExcludes == null ? other$fieldExcludes != null : !((Object)this$fieldExcludes).equals(other$fieldExcludes)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        Boolean this$stopOnErrors = this.getStopOnErrors();
        Boolean other$stopOnErrors = other.getStopOnErrors();
        if (this$stopOnErrors == null ? other$stopOnErrors != null : !((Object)this$stopOnErrors).equals(other$stopOnErrors)) {
            return false;
        }
        Boolean this$wildcard = this.getWildcard();
        Boolean other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard)) {
            return false;
        }
        Boolean this$wildcardCaseInsensitive = this.getWildcardCaseInsensitive();
        Boolean other$wildcardCaseInsensitive = other.getWildcardCaseInsensitive();
        if (this$wildcardCaseInsensitive == null ? other$wildcardCaseInsensitive != null : !((Object)this$wildcardCaseInsensitive).equals(other$wildcardCaseInsensitive)) {
            return false;
        }
        Boolean this$trimStrings = this.getTrimStrings();
        Boolean other$trimStrings = other.getTrimStrings();
        if (this$trimStrings == null ? other$trimStrings != null : !((Object)this$trimStrings).equals(other$trimStrings)) {
            return false;
        }
        Boolean this$mapNull = this.getMapNull();
        Boolean other$mapNull = other.getMapNull();
        if (this$mapNull == null ? other$mapNull != null : !((Object)this$mapNull).equals(other$mapNull)) {
            return false;
        }
        Boolean this$mapEmptyString = this.getMapEmptyString();
        Boolean other$mapEmptyString = other.getMapEmptyString();
        if (this$mapEmptyString == null ? other$mapEmptyString != null : !((Object)this$mapEmptyString).equals(other$mapEmptyString)) {
            return false;
        }
        String this$beanFactory = this.getBeanFactory();
        String other$beanFactory = other.getBeanFactory();
        if (this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Relationship this$relationshipType = this.getRelationshipType();
        Relationship other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !((Object)((Object)this$relationshipType)).equals((Object)other$relationshipType)) {
            return false;
        }
        String this$mapId = this.getMapId();
        String other$mapId = other.getMapId();
        return !(this$mapId == null ? other$mapId != null : !this$mapId.equals(other$mapId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MappingsDefinition $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ClassDefinition $classA = this.getClassA();
        result = result * 59 + ($classA == null ? 43 : ((Object)$classA).hashCode());
        ClassDefinition $classB = this.getClassB();
        result = result * 59 + ($classB == null ? 43 : ((Object)$classB).hashCode());
        List<Object> $fieldOrFieldExclude = this.getFieldOrFieldExclude();
        result = result * 59 + ($fieldOrFieldExclude == null ? 43 : ((Object)$fieldOrFieldExclude).hashCode());
        List<FieldDefinition> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<FieldExcludeDefinition> $fieldExcludes = this.getFieldExcludes();
        result = result * 59 + ($fieldExcludes == null ? 43 : ((Object)$fieldExcludes).hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        Boolean $stopOnErrors = this.getStopOnErrors();
        result = result * 59 + ($stopOnErrors == null ? 43 : ((Object)$stopOnErrors).hashCode());
        Boolean $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
        Boolean $wildcardCaseInsensitive = this.getWildcardCaseInsensitive();
        result = result * 59 + ($wildcardCaseInsensitive == null ? 43 : ((Object)$wildcardCaseInsensitive).hashCode());
        Boolean $trimStrings = this.getTrimStrings();
        result = result * 59 + ($trimStrings == null ? 43 : ((Object)$trimStrings).hashCode());
        Boolean $mapNull = this.getMapNull();
        result = result * 59 + ($mapNull == null ? 43 : ((Object)$mapNull).hashCode());
        Boolean $mapEmptyString = this.getMapEmptyString();
        result = result * 59 + ($mapEmptyString == null ? 43 : ((Object)$mapEmptyString).hashCode());
        String $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Relationship $relationshipType = this.getRelationshipType();
        result = result * 59 + ($relationshipType == null ? 43 : ((Object)((Object)$relationshipType)).hashCode());
        String $mapId = this.getMapId();
        result = result * 59 + ($mapId == null ? 43 : $mapId.hashCode());
        return result;
    }
}

