/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.builder.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.dozer.builder.BeanMappingsBuilder;
import org.dozer.builder.model.elengine.ELMappingsDefinition;
import org.dozer.builder.model.jaxb.MappingsDefinition;
import org.dozer.builder.xml.DefaultJAXBModelParser;
import org.dozer.builder.xml.JAXBModelParser;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.BeanContainer;
import org.dozer.el.ELEngine;
import org.dozer.factory.DestBeanCreator;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.MappingValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class BeanMappingXMLBuilder
implements BeanMappingsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(BeanMappingXMLBuilder.class);
    private final List<MappingsDefinition> mappingsDefinitions = new ArrayList<MappingsDefinition>();
    private final JAXBModelParser<MappingsDefinition> factory;
    private final ELEngine elEngine;
    private final BeanContainer beanContainer;

    public BeanMappingXMLBuilder(BeanContainer beanContainer, ELEngine elEngine) {
        this.factory = new DefaultJAXBModelParser<MappingsDefinition>(beanContainer);
        this.elEngine = elEngine;
        this.beanContainer = beanContainer;
    }

    public void loadFiles(List<String> files) {
        for (String path : files) {
            URL url = MappingValidator.validateURL(path, this.beanContainer);
            LOG.info("Using URL [" + path + "] to load custom xml mappings");
            try {
                BufferedInputStream stream = new BufferedInputStream(url.openStream());
                Throwable throwable = null;
                try {
                    this.load(stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)stream).close();
                }
            }
            catch (IOException ex) {
                MappingUtils.throwMappingException(ex);
            }
        }
    }

    public void loadInputStreams(List<Supplier<InputStream>> xmlMappingSuppliers) {
        for (Supplier<InputStream> supplier : xmlMappingSuppliers) {
            try {
                BufferedInputStream stream = new BufferedInputStream(supplier.get());
                Throwable throwable = null;
                try {
                    this.load(stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)stream).close();
                }
            }
            catch (IOException ex) {
                MappingUtils.throwMappingException(ex);
            }
        }
    }

    private void load(InputStream stream) {
        try {
            String xmlContent = IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
            MappingsDefinition result = this.factory.readXML(xmlContent, MappingsDefinition.class);
            if (result == null) {
                LOG.error("Failed to load custom xml mappings for: {}", (Object)xmlContent);
            } else {
                this.factory.validateXML(xmlContent);
                this.mappingsDefinitions.add(new ELMappingsDefinition(this.elEngine, result));
                LOG.info("Successfully loaded custom xml mapping.");
            }
        }
        catch (IOException ex) {
            MappingUtils.throwMappingException(ex);
        }
        catch (SAXException ex) {
            MappingUtils.throwMappingException(ex);
        }
    }

    @Override
    public List<MappingFileData> build(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        ArrayList<MappingFileData> answer = new ArrayList<MappingFileData>();
        for (MappingsDefinition mappingsDefinition : this.mappingsDefinitions) {
            Configuration configuration = null;
            if (mappingsDefinition.getConfiguration() != null) {
                configuration = mappingsDefinition.getConfiguration().build(beanContainer);
            }
            MappingFileData data = new MappingFileData();
            data.setConfiguration(configuration);
            data.getClassMaps().addAll(mappingsDefinition.build(configuration, beanContainer, destBeanCreator, propertyDescriptorFactory));
            answer.add(data);
        }
        return answer;
    }
}

