/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheEntry;

public class DozerCache<KeyType, ValueType>
implements Cache<KeyType, ValueType> {
    private final String name;
    private final LRUMap cacheMap;

    public DozerCache(String name, int maximumSize) {
        if (maximumSize < 1) {
            throw new IllegalArgumentException("Dozer cache max size must be greater than 0");
        }
        this.name = name;
        this.cacheMap = new LRUMap(maximumSize);
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
    }

    @Override
    public synchronized void put(KeyType key, ValueType value) {
        if (key == null) {
            throw new IllegalArgumentException("Cache entry key cannot be null");
        }
        CacheEntry<KeyType, ValueType> cacheEntry = new CacheEntry<KeyType, ValueType>(key, value);
        this.cacheMap.put(cacheEntry.getKey(), cacheEntry);
    }

    @Override
    public ValueType get(KeyType key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        CacheEntry result = (CacheEntry)this.cacheMap.get(key);
        if (result != null) {
            return result.getValue();
        }
        return null;
    }

    public void addEntries(Collection<CacheEntry<KeyType, ValueType>> entries) {
        for (CacheEntry<KeyType, ValueType> entry : entries) {
            this.cacheMap.put(entry.getKey(), entry);
        }
    }

    public Collection<CacheEntry<KeyType, ValueType>> getEntries() {
        return this.cacheMap.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.cacheMap.size();
    }

    @Override
    public long getMaxSize() {
        return this.cacheMap.maximumSize;
    }

    @Override
    public boolean containsKey(KeyType key) {
        return this.cacheMap.containsKey(key);
    }

    public Set<KeyType> keySet() {
        return this.cacheMap.keySet();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    class LRUMap
    extends LinkedHashMap<KeyType, CacheEntry<KeyType, ValueType>> {
        private int maximumSize;

        LRUMap(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<KeyType, CacheEntry<KeyType, ValueType>> eldest) {
            return this.size() > this.maximumSize;
        }
    }
}

