/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.fieldmap;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.config.BeanContainer;
import org.dozer.util.MappingUtils;

public class HintContainer {
    private String hintName;
    private List<Class<?>> hints;
    private final BeanContainer beanContainer;

    public HintContainer(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    public Class<?> getHint() {
        if (this.hasMoreThanOneHint()) {
            return null;
        }
        Class<?> result = this.getHints().get(0);
        return result;
    }

    public Class<?> getHint(int index) {
        return this.getHints().get(index);
    }

    public boolean hasMoreThanOneHint() {
        return this.getHints().size() > 1;
    }

    public List<Class<?>> getHints() {
        if (this.hints == null) {
            ArrayList list = new ArrayList();
            StringTokenizer st = new StringTokenizer(this.hintName, ",");
            while (st.hasMoreElements()) {
                String theHintName = st.nextToken().trim();
                Class<?> clazz = MappingUtils.loadClass(theHintName, this.beanContainer);
                list.add(clazz);
            }
            this.hints = list;
        }
        return this.hints;
    }

    public Class<?> getHint(Class<?> clazz, List<Class<?>> clazzHints) {
        List<Class<?>> hints = this.getHints();
        int hintsSize = hints.size();
        if (hintsSize == 1) {
            return this.getHint();
        }
        if (clazzHints.size() != hintsSize) {
            MappingUtils.throwMappingException("When using multiple source and destination hints there must be exactly the same number of hints on the source and the destination.");
        }
        int count = 0;
        String myClazName = MappingUtils.getRealClass(clazz, this.beanContainer).getName();
        int size = clazzHints.size();
        for (int i = 0; i < size; ++i) {
            Class<?> element = clazzHints.get(i);
            if (element.getName().equals(myClazName)) {
                return hints.get(count);
            }
            ++count;
        }
        return clazz;
    }

    public void setHintName(String hintName) {
        this.hintName = hintName;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

