/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.RelationshipType;
import org.dozer.config.BeanContainer;
import org.dozer.el.ELEngine;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.DozerBuilder;
import org.dozer.loader.MappingsSource;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser
implements MappingsSource<Document> {
    private final Logger log = LoggerFactory.getLogger(XMLParser.class);
    private static final String WILDCARD = "wildcard";
    private static final String WILDCARD_CASE_INSENSITIVE = "wildcard-case-insensitive";
    private static final String TRIM_STRINGS = "trim-strings";
    private static final String BEAN_FACTORY = "bean-factory";
    private static final String DATE_FORMAT = "date-format";
    private static final String RELATIONSHIP_TYPE = "relationship-type";
    private static final String REMOVE_ORPHANS = "remove-orphans";
    private static final String MAP_NULL = "map-null";
    private static final String MAP_EMPTY_STRING = "map-empty-string";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String STOP_ON_ERRORS_ELEMENT = "stop-on-errors";
    private static final String CUSTOM_CONVERTERS_ELEMENT = "custom-converters";
    private static final String COPY_BY_REFERENCES_ELEMENT = "copy-by-references";
    private static final String COPY_BY_REFERENCE = "copy-by-reference";
    private static final String CONVERTER_ELEMENT = "converter";
    private static final String CLASS_A_ELEMENT = "class-a";
    private static final String CLASS_B_ELEMENT = "class-b";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String FIELD_ELEMENT = "field";
    private static final String FIELD_EXCLUDE_ELEMENT = "field-exclude";
    private static final String A_ELEMENT = "a";
    private static final String B_ELEMENT = "b";
    private static final String SRC_TYPE_HINT_ELEMENT = "a-hint";
    private static final String DEST_TYPE_HINT_ELEMENT = "b-hint";
    private static final String SRC_TYPE_DEEP_INDEX_HINT_ELEMENT = "a-deep-index-hint";
    private static final String DEST_TYPE_DEEP_INDEX_HINT_ELEMENT = "b-deep-index-hint";
    private static final String ALLOWED_EXCEPTIONS_ELEMENT = "allowed-exceptions";
    private static final String ALLOWED_EXCEPTION_ELEMENT = "exception";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String VARIABLE_ELEMENT = "variable";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String COPY_BY_REFERENCE_ATTRIBUTE = "copy-by-reference";
    private static final String THE_SET_METHOD_ATTRIBUTE = "set-method";
    private static final String THE_GET_METHOD_ATTRIBUTE = "get-method";
    private static final String STOP_ON_ERRORS_ATTRIBUTE = "stop-on-errors";
    private static final String MAPID_ATTRIBUTE = "map-id";
    private static final String MAP_SET_METHOD_ATTRIBUTE = "map-set-method";
    private static final String MAP_GET_METHOD_ATTRIBUTE = "map-get-method";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String FACTORY_BEANID_ATTRIBUTE = "factory-bean-id";
    private static final String IS_ACCESSIBLE_ATTRIBUTE = "is-accessible";
    private static final String CREATE_METHOD_ATTRIBUTE = "create-method";
    private static final String SKIP_CONSTRUCTOR_ATTRIBUTE = "skip-constructor";
    private static final String MAP_NULL_ATTRIBUTE = "map-null";
    private static final String MAP_EMPTY_STRING_ATTRIBUTE = "map-empty-string";
    private static final String CUSTOM_CONVERTER_ATTRIBUTE = "custom-converter";
    private static final String CUSTOM_CONVERTER_ID_ATTRIBUTE = "custom-converter-id";
    private static final String CUSTOM_CONVERTER_PARAM_ATTRIBUTE = "custom-converter-param";
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public XMLParser(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    private String getAttribute(Element element, String attribute) {
        return this.beanContainer.getElementReader().getAttribute(element, attribute);
    }

    private String getNodeValue(Element element) {
        return this.beanContainer.getElementReader().getNodeValue(element);
    }

    private void debugElement(Element element) {
        this.log.debug("config name: {}", (Object)element.getNodeName());
        this.log.debug("  value: {}", (Object)element.getFirstChild().getNodeValue());
    }

    @Override
    public MappingFileData read(Document document) {
        DozerBuilder builder = new DozerBuilder(this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        Element theRoot = document.getDocumentElement();
        NodeList nl = theRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            this.log.debug("name: {}", (Object)ele.getNodeName());
            if (CONFIGURATION_ELEMENT.equals(ele.getNodeName())) {
                this.parseConfiguration(ele, builder);
                continue;
            }
            if (!MAPPING_ELEMENT.equals(ele.getNodeName())) continue;
            this.parseMapping(ele, builder);
        }
        return builder.build();
    }

    private void parseMapping(Element ele, DozerBuilder builder) {
        DozerBuilder.MappingBuilder definitionBuilder = builder.mapping();
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, DATE_FORMAT))) {
            definitionBuilder.dateFormat(this.getAttribute(ele, DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, "map-null"))) {
            definitionBuilder.mapNull(BooleanUtils.toBoolean((String)this.getAttribute(ele, "map-null")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, "map-empty-string"))) {
            definitionBuilder.mapEmptyString(BooleanUtils.toBoolean((String)this.getAttribute(ele, "map-empty-string")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, BEAN_FACTORY))) {
            definitionBuilder.beanFactory(this.getAttribute(ele, BEAN_FACTORY));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, RELATIONSHIP_TYPE))) {
            String relationshipTypeValue = this.getAttribute(ele, RELATIONSHIP_TYPE);
            RelationshipType relationshipType = RelationshipType.valueOf(relationshipTypeValue);
            definitionBuilder.relationshipType(relationshipType);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, WILDCARD))) {
            definitionBuilder.wildcard(Boolean.valueOf(this.getAttribute(ele, WILDCARD)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, WILDCARD_CASE_INSENSITIVE))) {
            definitionBuilder.wildcardCaseInsensitive(Boolean.valueOf(this.getAttribute(ele, WILDCARD_CASE_INSENSITIVE)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, TRIM_STRINGS))) {
            definitionBuilder.trimStrings(Boolean.valueOf(this.getAttribute(ele, TRIM_STRINGS)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, "stop-on-errors"))) {
            definitionBuilder.stopOnErrors(Boolean.valueOf(this.getAttribute(ele, "stop-on-errors")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, MAPID_ATTRIBUTE))) {
            definitionBuilder.mapId(this.getAttribute(ele, MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            definitionBuilder.type(direction);
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            DozerBuilder.ClassDefinitionBuilder classBuilder;
            String typeName;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (CLASS_A_ELEMENT.equals(element.getNodeName())) {
                typeName = this.getNodeValue(element);
                classBuilder = definitionBuilder.classA(typeName);
                this.parseClass(element, classBuilder);
            }
            if (CLASS_B_ELEMENT.equals(element.getNodeName())) {
                typeName = this.getNodeValue(element);
                classBuilder = definitionBuilder.classB(typeName);
                this.parseClass(element, classBuilder);
            }
            if (FIELD_ELEMENT.equals(element.getNodeName())) {
                this.parseGenericFieldMap(element, definitionBuilder);
                continue;
            }
            if (!FIELD_EXCLUDE_ELEMENT.equals(element.getNodeName())) continue;
            this.parseFieldExcludeMap(element, definitionBuilder);
        }
    }

    private void parseClass(Element element, DozerBuilder.ClassDefinitionBuilder classBuilder) {
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, MAP_GET_METHOD_ATTRIBUTE))) {
            classBuilder.mapGetMethod(this.getAttribute(element, MAP_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, MAP_SET_METHOD_ATTRIBUTE))) {
            classBuilder.mapSetMethod(this.getAttribute(element, MAP_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, BEAN_FACTORY))) {
            classBuilder.beanFactory(this.getAttribute(element, BEAN_FACTORY));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, FACTORY_BEANID_ATTRIBUTE))) {
            classBuilder.factoryBeanId(this.getAttribute(element, FACTORY_BEANID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, CREATE_METHOD_ATTRIBUTE))) {
            classBuilder.createMethod(this.getAttribute(element, CREATE_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, "map-null"))) {
            classBuilder.mapNull(Boolean.valueOf(this.getAttribute(element, "map-null")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, "map-empty-string"))) {
            classBuilder.mapEmptyString(Boolean.valueOf(this.getAttribute(element, "map-empty-string")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, IS_ACCESSIBLE_ATTRIBUTE))) {
            classBuilder.isAccessible(Boolean.valueOf(this.getAttribute(element, IS_ACCESSIBLE_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(element, SKIP_CONSTRUCTOR_ATTRIBUTE))) {
            classBuilder.skipConstructor(Boolean.valueOf(this.getAttribute(element, SKIP_CONSTRUCTOR_ATTRIBUTE)));
        }
    }

    private void parseFieldExcludeMap(Element ele, DozerBuilder.MappingBuilder definitionBuilder) {
        DozerBuilder.FieldExclusionBuilder fieldMapBuilder = definitionBuilder.fieldExclude();
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            fieldMapBuilder.type(direction);
        }
        NodeList nodeList = ele.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            this.parseFieldElements(element, fieldMapBuilder);
        }
    }

    private void parseFieldElements(Element element, DozerBuilder.FieldBuider fieldMapBuilder) {
        DozerBuilder.FieldDefinitionBuilder fieldBuilder;
        String type;
        String name;
        if (A_ELEMENT.equals(element.getNodeName())) {
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            fieldBuilder = fieldMapBuilder.a(name, type);
            this.parseField(element, fieldBuilder);
        }
        if (B_ELEMENT.equals(element.getNodeName())) {
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            fieldBuilder = fieldMapBuilder.b(name, type);
            this.parseField(element, fieldBuilder);
        }
    }

    private void parseGenericFieldMap(Element ele, DozerBuilder.MappingBuilder definitionBuilder) {
        DozerBuilder.FieldMappingBuilder fieldMapBuilder = this.determineFieldMap(definitionBuilder, ele);
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, "copy-by-reference"))) {
            fieldMapBuilder.copyByReference(BooleanUtils.toBoolean((String)this.getAttribute(ele, "copy-by-reference")));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, MAPID_ATTRIBUTE))) {
            fieldMapBuilder.mapId(this.getAttribute(ele, MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            fieldMapBuilder.type(direction);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, CUSTOM_CONVERTER_ATTRIBUTE))) {
            fieldMapBuilder.customConverter(this.getAttribute(ele, CUSTOM_CONVERTER_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, CUSTOM_CONVERTER_ID_ATTRIBUTE))) {
            fieldMapBuilder.customConverterId(this.getAttribute(ele, CUSTOM_CONVERTER_ID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, CUSTOM_CONVERTER_PARAM_ATTRIBUTE))) {
            fieldMapBuilder.customConverterParam(this.getAttribute(ele, CUSTOM_CONVERTER_PARAM_ATTRIBUTE));
        }
        this.parseFieldMap(ele, fieldMapBuilder);
    }

    private DozerBuilder.FieldMappingBuilder determineFieldMap(DozerBuilder.MappingBuilder definitionBuilder, Element ele) {
        DozerBuilder.FieldMappingBuilder fieldMapBuilder = definitionBuilder.field();
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            DozerBuilder.FieldDefinitionBuilder builder;
            String type;
            String name;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (A_ELEMENT.equals(element.getNodeName())) {
                name = this.getNodeValue(element);
                type = this.getAttribute(element, TYPE_ATTRIBUTE);
                builder = fieldMapBuilder.a(name, type);
                this.parseField(element, builder);
            }
            if (!B_ELEMENT.equals(element.getNodeName())) continue;
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            builder = fieldMapBuilder.b(name, type);
            this.parseField(element, builder);
        }
        return fieldMapBuilder;
    }

    private void parseFieldMap(Element ele, DozerBuilder.FieldMappingBuilder fieldMapBuilder) {
        this.setRelationshipType(ele, fieldMapBuilder);
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, REMOVE_ORPHANS))) {
            fieldMapBuilder.removeOrphans(BooleanUtils.toBoolean((String)this.getAttribute(ele, REMOVE_ORPHANS)));
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String hint;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            this.parseFieldElements(element, fieldMapBuilder);
            if (SRC_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.srcHintContainer(hint);
            }
            if (DEST_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.destHintContainer(hint);
            }
            if (SRC_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.srcDeepIndexHintContainer(hint);
            }
            if (!DEST_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) continue;
            hint = this.getNodeValue(element);
            fieldMapBuilder.destDeepIndexHintContainer(hint);
        }
    }

    private void setRelationshipType(Element ele, DozerBuilder.FieldMappingBuilder definitionBuilder) {
        RelationshipType relationshipType = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, RELATIONSHIP_TYPE))) {
            String relationshipTypeValue = this.getAttribute(ele, RELATIONSHIP_TYPE);
            relationshipType = RelationshipType.valueOf(relationshipTypeValue);
        }
        definitionBuilder.relationshipType(relationshipType);
    }

    private void parseField(Element ele, DozerBuilder.FieldDefinitionBuilder fieldBuilder) {
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, DATE_FORMAT))) {
            fieldBuilder.dateFormat(this.getAttribute(ele, DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, THE_GET_METHOD_ATTRIBUTE))) {
            fieldBuilder.theGetMethod(this.getAttribute(ele, THE_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, THE_SET_METHOD_ATTRIBUTE))) {
            fieldBuilder.theSetMethod(this.getAttribute(ele, THE_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, MAP_GET_METHOD_ATTRIBUTE))) {
            fieldBuilder.mapGetMethod(this.getAttribute(ele, MAP_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, MAP_SET_METHOD_ATTRIBUTE))) {
            fieldBuilder.mapSetMethod(this.getAttribute(ele, MAP_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, KEY_ATTRIBUTE))) {
            fieldBuilder.key(this.getAttribute(ele, KEY_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, CREATE_METHOD_ATTRIBUTE))) {
            fieldBuilder.createMethod(this.getAttribute(ele, CREATE_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(ele, IS_ACCESSIBLE_ATTRIBUTE))) {
            fieldBuilder.accessible(BooleanUtils.toBoolean((String)this.getAttribute(ele, IS_ACCESSIBLE_ATTRIBUTE)));
        }
    }

    private void parseConfiguration(Element ele, DozerBuilder builder) {
        DozerBuilder.ConfigurationBuilder configBuilder = builder.configuration();
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            String nodeValue = this.getNodeValue(element);
            if ("stop-on-errors".equals(element.getNodeName())) {
                configBuilder.stopOnErrors(Boolean.valueOf(nodeValue));
                continue;
            }
            if (DATE_FORMAT.equals(element.getNodeName())) {
                configBuilder.dateFormat(nodeValue);
                continue;
            }
            if (WILDCARD.equals(element.getNodeName())) {
                configBuilder.wildcard(Boolean.valueOf(nodeValue));
                continue;
            }
            if (WILDCARD_CASE_INSENSITIVE.equals(element.getNodeName())) {
                configBuilder.wildcardCaseInsensitive(Boolean.valueOf(nodeValue));
                continue;
            }
            if (TRIM_STRINGS.equals(element.getNodeName())) {
                configBuilder.trimStrings(Boolean.valueOf(nodeValue));
                continue;
            }
            if ("map-null".equals(element.getNodeName())) {
                configBuilder.mapNull(Boolean.valueOf(nodeValue));
                continue;
            }
            if ("map-empty-string".equals(element.getNodeName())) {
                configBuilder.mapEmptyString(Boolean.valueOf(nodeValue));
                continue;
            }
            if (RELATIONSHIP_TYPE.equals(element.getNodeName())) {
                RelationshipType relationshipType = RelationshipType.valueOf(nodeValue);
                configBuilder.relationshipType(relationshipType);
                continue;
            }
            if (BEAN_FACTORY.equals(element.getNodeName())) {
                configBuilder.beanFactory(nodeValue);
                continue;
            }
            if (CUSTOM_CONVERTERS_ELEMENT.equals(element.getNodeName())) {
                this.parseCustomConverters(element, configBuilder);
                continue;
            }
            if (COPY_BY_REFERENCES_ELEMENT.equals(element.getNodeName())) {
                this.parseCopyByReferences(element, configBuilder);
                continue;
            }
            if (ALLOWED_EXCEPTIONS_ELEMENT.equals(element.getNodeName())) {
                this.parseAllowedExceptions(element, configBuilder);
                continue;
            }
            if (!VARIABLES_ELEMENT.equals(element.getNodeName())) continue;
            this.parseVariables(element);
        }
    }

    private void parseVariables(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ELEngine engine;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            this.debugElement(ele);
            if (!VARIABLE_ELEMENT.equals(ele.getNodeName()) || (engine = this.beanContainer.getElEngine()) == null) continue;
            String name = this.getAttribute(ele, NAME_ATTRIBUTE);
            String value = this.getNodeValue(ele);
            engine.setVariable(name, value);
        }
    }

    private void parseCustomConverters(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!CONVERTER_ELEMENT.equals(element.getNodeName())) continue;
            String converterType = this.getAttribute(element, TYPE_ATTRIBUTE);
            DozerBuilder.CustomConverterBuilder customConverterBuilder = config.customConverter(converterType);
            NodeList list = element.getChildNodes();
            for (int x = 0; x < list.getLength(); ++x) {
                Node node1 = list.item(x);
                if (!(node1 instanceof Element)) continue;
                Element element1 = (Element)node1;
                if (CLASS_A_ELEMENT.equals(element1.getNodeName())) {
                    customConverterBuilder.classA(this.getNodeValue(element1));
                    continue;
                }
                if (!CLASS_B_ELEMENT.equals(element1.getNodeName())) continue;
                customConverterBuilder.classB(this.getNodeValue(element1));
            }
        }
    }

    private void parseCopyByReferences(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!"copy-by-reference".equals(element.getNodeName())) continue;
            String typeMask = this.getNodeValue(element);
            config.copyByReference(typeMask);
        }
    }

    private void parseAllowedExceptions(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!ALLOWED_EXCEPTION_ELEMENT.equals(element.getNodeName())) continue;
            String exceptionType = this.getNodeValue(element);
            config.allowedException(exceptionType);
        }
    }
}

