/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.GetterSetterPropertyDescriptor;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public class JavaBeanPropertyDescriptor
extends GetterSetterPropertyDescriptor {
    private PropertyDescriptor pd;
    private boolean propertyDescriptorsRefreshed;

    public JavaBeanPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer, beanContainer, destBeanCreator);
    }

    @Override
    public Method getWriteMethod() throws NoSuchMethodException {
        Method result = this.getPropertyDescriptor(this.destDeepIndexHintContainer).getWriteMethod();
        Method method = result = result == null ? ReflectionUtils.getNonStandardSetter(this.clazz, this.fieldName) : result;
        if (result == null) {
            result = this.retryMissingMethod(true);
        }
        this.propertyDescriptorsRefreshed = false;
        return result;
    }

    @Override
    protected String getSetMethodName() throws NoSuchMethodException {
        return this.getWriteMethod().getName();
    }

    @Override
    protected Method getReadMethod() throws NoSuchMethodException {
        Method result = this.getPropertyDescriptor(this.srcDeepIndexHintContainer).getReadMethod();
        if (result == null) {
            result = this.retryMissingMethod(false);
        }
        this.propertyDescriptorsRefreshed = false;
        return result;
    }

    @Override
    protected boolean isCustomSetMethod() {
        return false;
    }

    private Method retryMissingMethod(boolean writeMethod) throws NoSuchMethodException {
        if (this.propertyDescriptorsRefreshed) {
            throw new NoSuchMethodException("Unable to determine " + (writeMethod ? "write" : "read") + " method for Field: '" + this.fieldName + "' in Class: " + this.clazz);
        }
        this.refreshPropertyDescriptors();
        return writeMethod ? this.getWriteMethod() : this.getReadMethod();
    }

    private void refreshPropertyDescriptors() {
        PropertyUtils.clearDescriptors();
        this.pd = null;
        this.propertyDescriptorsRefreshed = true;
    }

    private PropertyDescriptor getPropertyDescriptor(HintContainer deepIndexHintContainer) {
        if (this.pd == null) {
            this.pd = ReflectionUtils.findPropertyDescriptor(this.clazz, this.fieldName, deepIndexHintContainer);
            if (this.pd == null) {
                MappingUtils.throwMappingException("Property: '" + this.fieldName + "' not found in Class: " + this.clazz);
            }
        }
        return this.pd;
    }
}

