/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.jaxb;

import com.github.dozermapper.core.builder.model.jaxb.AllowedExceptionsDefinition;
import com.github.dozermapper.core.builder.model.jaxb.CopyByReferencesDefinition;
import com.github.dozermapper.core.builder.model.jaxb.CustomConvertersDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingsDefinition;
import com.github.dozermapper.core.builder.model.jaxb.Relationship;
import com.github.dozermapper.core.builder.model.jaxb.VariablesDefinition;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.CopyByReference;
import com.github.dozermapper.core.classmap.RelationshipType;
import com.github.dozermapper.core.config.BeanContainer;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="configuration")
public class ConfigurationDefinition {
    @XmlTransient
    private final MappingsDefinition parent;
    @XmlElement(name="stop-on-errors")
    protected Boolean stopOnErrors;
    @XmlElement(name="date-format")
    protected String dateFormat;
    @XmlElement(name="wildcard")
    protected Boolean wildcard;
    @XmlElement(name="wildcard-case-insensitive")
    protected Boolean wildcardCaseInsensitive;
    @XmlElement(name="trim-strings")
    protected Boolean trimStrings;
    @XmlElement(name="map-null")
    protected Boolean mapNull;
    @XmlElement(name="map-empty-string")
    protected Boolean mapEmptyString;
    @XmlElement(name="bean-factory")
    protected String beanFactory;
    @XmlElement(name="relationship-type")
    protected Relationship relationshipType;
    @XmlElement(name="custom-converters")
    protected CustomConvertersDefinition customConverters;
    @XmlElement(name="copy-by-references")
    protected CopyByReferencesDefinition copyByReferences;
    @XmlElement(name="allowed-exceptions")
    protected AllowedExceptionsDefinition allowedExceptions;
    @XmlElement(name="variables")
    protected VariablesDefinition variables;

    public ConfigurationDefinition() {
        this(null);
    }

    public ConfigurationDefinition(MappingsDefinition parent) {
        this.parent = parent;
    }

    public ConfigurationDefinition withStopOnErrors(Boolean stopOnErrors) {
        this.setStopOnErrors(stopOnErrors);
        return this;
    }

    public ConfigurationDefinition withDateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public ConfigurationDefinition withWildcard(Boolean wildcard) {
        this.setWildcard(wildcard);
        return this;
    }

    public ConfigurationDefinition withWildcardCaseInsensitive(Boolean wildcardCaseInsensitive) {
        this.setWildcardCaseInsensitive(wildcardCaseInsensitive);
        return this;
    }

    public ConfigurationDefinition withTrimStrings(Boolean trimStrings) {
        this.setTrimStrings(trimStrings);
        return this;
    }

    public ConfigurationDefinition withMapNull(Boolean mapNull) {
        this.setMapNull(mapNull);
        return this;
    }

    public ConfigurationDefinition withMapEmptyString(Boolean mapEmptyString) {
        this.setMapEmptyString(mapEmptyString);
        return this;
    }

    public ConfigurationDefinition withBeanFactory(String beanFactory) {
        this.setBeanFactory(beanFactory);
        return this;
    }

    public ConfigurationDefinition withRelationshipType(Relationship relationshipType) {
        this.setRelationshipType(relationshipType);
        return this;
    }

    public CustomConvertersDefinition withCustomConverters() {
        CustomConvertersDefinition customConverters = new CustomConvertersDefinition(this);
        this.setCustomConverters(customConverters);
        return customConverters;
    }

    public CopyByReferencesDefinition withCopyByReferences() {
        CopyByReferencesDefinition copyByReferences = new CopyByReferencesDefinition(this);
        this.setCopyByReferences(copyByReferences);
        return copyByReferences;
    }

    public AllowedExceptionsDefinition withAllowedExceptions() {
        AllowedExceptionsDefinition allowedExceptions = new AllowedExceptionsDefinition(this);
        this.setAllowedExceptions(allowedExceptions);
        return allowedExceptions;
    }

    public VariablesDefinition withVariables() {
        VariablesDefinition variables = new VariablesDefinition(this);
        this.setVariables(variables);
        return variables;
    }

    public MappingsDefinition end() {
        return this.parent;
    }

    public Configuration build(BeanContainer beanContainer) {
        if (this.variables != null) {
            this.variables.build();
        }
        Configuration config = new Configuration();
        config.setBeanFactory(this.beanFactory);
        config.setBeanFactory(this.beanFactory);
        config.setDateFormat(this.dateFormat);
        config.setMapEmptyString(this.mapEmptyString == null ? true : this.mapEmptyString);
        config.setMapNull(this.mapNull == null ? true : this.mapNull);
        config.setRelationshipType(RelationshipType.valueOf(this.relationshipType == null ? "" : this.relationshipType.value()));
        config.setStopOnErrors(this.stopOnErrors == null ? true : this.stopOnErrors);
        config.setTrimStrings(this.trimStrings == null ? false : this.trimStrings);
        config.setWildcard(this.wildcard == null ? true : this.wildcard);
        config.setWildcardCaseInsensitive(this.wildcardCaseInsensitive == null ? false : this.wildcardCaseInsensitive);
        if (this.allowedExceptions != null) {
            config.getAllowedExceptions().getExceptions().addAll(this.allowedExceptions.build(beanContainer));
        }
        if (this.copyByReferences != null) {
            List<CopyByReference> copyByReferencesList = this.copyByReferences.build();
            for (CopyByReference current : copyByReferencesList) {
                config.getCopyByReferences().add(current);
            }
        }
        if (this.customConverters != null) {
            config.getCustomConverters().setConverters(this.customConverters.build(beanContainer));
        }
        return config;
    }

    public MappingsDefinition getParent() {
        return this.parent;
    }

    public Boolean getStopOnErrors() {
        return this.stopOnErrors;
    }

    protected void setStopOnErrors(Boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    protected void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    protected void setWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
    }

    public Boolean getWildcardCaseInsensitive() {
        return this.wildcardCaseInsensitive;
    }

    protected void setWildcardCaseInsensitive(Boolean wildcardCaseInsensitive) {
        this.wildcardCaseInsensitive = wildcardCaseInsensitive;
    }

    public Boolean getTrimStrings() {
        return this.trimStrings;
    }

    protected void setTrimStrings(Boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    public Boolean getMapNull() {
        return this.mapNull;
    }

    protected void setMapNull(Boolean mapNull) {
        this.mapNull = mapNull;
    }

    public Boolean getMapEmptyString() {
        return this.mapEmptyString;
    }

    protected void setMapEmptyString(Boolean mapEmptyString) {
        this.mapEmptyString = mapEmptyString;
    }

    public String getBeanFactory() {
        return this.beanFactory;
    }

    protected void setBeanFactory(String beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Relationship getRelationshipType() {
        return this.relationshipType;
    }

    protected void setRelationshipType(Relationship relationshipType) {
        this.relationshipType = relationshipType;
    }

    public CustomConvertersDefinition getCustomConverters() {
        return this.customConverters;
    }

    protected void setCustomConverters(CustomConvertersDefinition customConverters) {
        this.customConverters = customConverters;
    }

    public CopyByReferencesDefinition getCopyByReferences() {
        return this.copyByReferences;
    }

    protected void setCopyByReferences(CopyByReferencesDefinition copyByReferences) {
        this.copyByReferences = copyByReferences;
    }

    public AllowedExceptionsDefinition getAllowedExceptions() {
        return this.allowedExceptions;
    }

    protected void setAllowedExceptions(AllowedExceptionsDefinition allowedExceptions) {
        this.allowedExceptions = allowedExceptions;
    }

    public VariablesDefinition getVariables() {
        return this.variables;
    }

    protected void setVariables(VariablesDefinition variables) {
        this.variables = variables;
    }

    public String toString() {
        return "ConfigurationDefinition(parent=" + this.getParent() + ", stopOnErrors=" + this.getStopOnErrors() + ", dateFormat=" + this.getDateFormat() + ", wildcard=" + this.getWildcard() + ", wildcardCaseInsensitive=" + this.getWildcardCaseInsensitive() + ", trimStrings=" + this.getTrimStrings() + ", mapNull=" + this.getMapNull() + ", mapEmptyString=" + this.getMapEmptyString() + ", beanFactory=" + this.getBeanFactory() + ", relationshipType=" + this.getRelationshipType() + ", customConverters=" + this.getCustomConverters() + ", copyByReferences=" + this.getCopyByReferences() + ", allowedExceptions=" + this.getAllowedExceptions() + ", variables=" + this.getVariables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationDefinition)) {
            return false;
        }
        ConfigurationDefinition other = (ConfigurationDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stopOnErrors = this.getStopOnErrors();
        Boolean other$stopOnErrors = other.getStopOnErrors();
        if (this$stopOnErrors == null ? other$stopOnErrors != null : !((Object)this$stopOnErrors).equals(other$stopOnErrors)) {
            return false;
        }
        Boolean this$wildcard = this.getWildcard();
        Boolean other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard)) {
            return false;
        }
        Boolean this$wildcardCaseInsensitive = this.getWildcardCaseInsensitive();
        Boolean other$wildcardCaseInsensitive = other.getWildcardCaseInsensitive();
        if (this$wildcardCaseInsensitive == null ? other$wildcardCaseInsensitive != null : !((Object)this$wildcardCaseInsensitive).equals(other$wildcardCaseInsensitive)) {
            return false;
        }
        Boolean this$trimStrings = this.getTrimStrings();
        Boolean other$trimStrings = other.getTrimStrings();
        if (this$trimStrings == null ? other$trimStrings != null : !((Object)this$trimStrings).equals(other$trimStrings)) {
            return false;
        }
        Boolean this$mapNull = this.getMapNull();
        Boolean other$mapNull = other.getMapNull();
        if (this$mapNull == null ? other$mapNull != null : !((Object)this$mapNull).equals(other$mapNull)) {
            return false;
        }
        Boolean this$mapEmptyString = this.getMapEmptyString();
        Boolean other$mapEmptyString = other.getMapEmptyString();
        if (this$mapEmptyString == null ? other$mapEmptyString != null : !((Object)this$mapEmptyString).equals(other$mapEmptyString)) {
            return false;
        }
        MappingsDefinition this$parent = this.getParent();
        MappingsDefinition other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$beanFactory = this.getBeanFactory();
        String other$beanFactory = other.getBeanFactory();
        if (this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory)) {
            return false;
        }
        Relationship this$relationshipType = this.getRelationshipType();
        Relationship other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !((Object)((Object)this$relationshipType)).equals((Object)other$relationshipType)) {
            return false;
        }
        CustomConvertersDefinition this$customConverters = this.getCustomConverters();
        CustomConvertersDefinition other$customConverters = other.getCustomConverters();
        if (this$customConverters == null ? other$customConverters != null : !((Object)this$customConverters).equals(other$customConverters)) {
            return false;
        }
        CopyByReferencesDefinition this$copyByReferences = this.getCopyByReferences();
        CopyByReferencesDefinition other$copyByReferences = other.getCopyByReferences();
        if (this$copyByReferences == null ? other$copyByReferences != null : !((Object)this$copyByReferences).equals(other$copyByReferences)) {
            return false;
        }
        AllowedExceptionsDefinition this$allowedExceptions = this.getAllowedExceptions();
        AllowedExceptionsDefinition other$allowedExceptions = other.getAllowedExceptions();
        if (this$allowedExceptions == null ? other$allowedExceptions != null : !((Object)this$allowedExceptions).equals(other$allowedExceptions)) {
            return false;
        }
        VariablesDefinition this$variables = this.getVariables();
        VariablesDefinition other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stopOnErrors = this.getStopOnErrors();
        result = result * 59 + ($stopOnErrors == null ? 43 : ((Object)$stopOnErrors).hashCode());
        Boolean $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
        Boolean $wildcardCaseInsensitive = this.getWildcardCaseInsensitive();
        result = result * 59 + ($wildcardCaseInsensitive == null ? 43 : ((Object)$wildcardCaseInsensitive).hashCode());
        Boolean $trimStrings = this.getTrimStrings();
        result = result * 59 + ($trimStrings == null ? 43 : ((Object)$trimStrings).hashCode());
        Boolean $mapNull = this.getMapNull();
        result = result * 59 + ($mapNull == null ? 43 : ((Object)$mapNull).hashCode());
        Boolean $mapEmptyString = this.getMapEmptyString();
        result = result * 59 + ($mapEmptyString == null ? 43 : ((Object)$mapEmptyString).hashCode());
        MappingsDefinition $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        Relationship $relationshipType = this.getRelationshipType();
        result = result * 59 + ($relationshipType == null ? 43 : ((Object)((Object)$relationshipType)).hashCode());
        CustomConvertersDefinition $customConverters = this.getCustomConverters();
        result = result * 59 + ($customConverters == null ? 43 : ((Object)$customConverters).hashCode());
        CopyByReferencesDefinition $copyByReferences = this.getCopyByReferences();
        result = result * 59 + ($copyByReferences == null ? 43 : ((Object)$copyByReferences).hashCode());
        AllowedExceptionsDefinition $allowedExceptions = this.getAllowedExceptions();
        result = result * 59 + ($allowedExceptions == null ? 43 : ((Object)$allowedExceptions).hashCode());
        VariablesDefinition $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }
}

