/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.AbstractJava8DateTimeConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class LocalDateTimeConverter
extends AbstractJava8DateTimeConverter {
    public LocalDateTimeConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    public Object convert(Class destClass, Object srcObject) {
        LocalDateTime localDateTime = this.convertToLocalDateTime(srcObject);
        if (localDateTime != null) {
            if (LocalTime.class.isAssignableFrom(destClass)) {
                return localDateTime.toLocalTime();
            }
            if (LocalDate.class.isAssignableFrom(destClass)) {
                return localDateTime.toLocalDate();
            }
            return localDateTime;
        }
        return super.convert(destClass, srcObject);
    }

    private LocalDateTime convertToLocalDateTime(Object srcObject) {
        Class<?> srcObjectClass = srcObject.getClass();
        if (Date.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = ((Date)srcObject).toInstant();
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (Instant.class.isAssignableFrom(srcObjectClass)) {
            return LocalDateTime.ofInstant((Instant)srcObject, ZoneId.systemDefault());
        }
        if (Long.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = Instant.ofEpochMilli((Long)srcObject);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return null;
    }
}

