/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.AbstractJava8DateTimeConverter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ZonedDateTimeConverter
extends AbstractJava8DateTimeConverter {
    public ZonedDateTimeConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    public Object convert(Class destClass, Object srcObject) {
        Class<?> srcObjectClass = srcObject.getClass();
        if (Date.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = ((Date)srcObject).toInstant();
            return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (Instant.class.isAssignableFrom(srcObjectClass)) {
            return ZonedDateTime.ofInstant((Instant)srcObject, ZoneId.systemDefault());
        }
        if (Long.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = Instant.ofEpochMilli((Long)srcObject);
            return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return super.convert(destClass, srcObject);
    }
}

