/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.el;

import com.github.dozermapper.core.el.ELEngine;
import com.github.dozermapper.core.el.contexts.SimpleELContext;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;

public class DefaultELEngine
implements ELEngine {
    protected ELContext elContext;
    protected ExpressionFactory expressionFactory;

    public DefaultELEngine(ExpressionFactory expressionFactory) {
        CompositeELResolver resolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new ArrayELResolver());
                this.add((ELResolver)new ListELResolver());
                this.add((ELResolver)new MapELResolver());
                this.add((ELResolver)new BeanELResolver());
                this.add((ELResolver)new ResourceBundleELResolver());
            }
        };
        this.elContext = new SimpleELContext((ELResolver)resolver);
        this.expressionFactory = expressionFactory;
    }

    @Override
    public <T> void setVariable(String key, T value) {
        this.setVariable(key, value, value.getClass());
    }

    @Override
    public <T> void setVariable(String key, T value, Class<? extends T> type) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(value, type);
        VariableMapper variableMapper = this.elContext.getVariableMapper();
        variableMapper.setVariable(key, valueExpression);
    }

    @Override
    public void setFunction(String prefix, Method method) {
        FunctionMapper functions = this.elContext.getFunctionMapper();
        functions.mapFunction(prefix, method.getName(), method);
    }

    @Override
    public void setFunction(String prefix, String name, Method method) {
        FunctionMapper functions = this.elContext.getFunctionMapper();
        functions.mapFunction(prefix, name, method);
    }

    @Override
    public String resolve(String expression) {
        ValueExpression expr = this.expressionFactory.createValueExpression(this.elContext, expression, String.class);
        return String.valueOf(expr.getValue(this.elContext));
    }
}

