/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.metadata;

import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.ClassMappings;
import com.github.dozermapper.core.metadata.ClassMappingMetadata;
import com.github.dozermapper.core.metadata.DozerClassMappingMetadata;
import com.github.dozermapper.core.metadata.MappingMetadata;
import com.github.dozermapper.core.metadata.MetadataLookupException;
import java.util.ArrayList;
import java.util.List;

public final class DozerMappingMetadata
implements MappingMetadata {
    private final ClassMappings classMappings;

    public DozerMappingMetadata(ClassMappings classMappings) {
        this.classMappings = classMappings;
    }

    @Override
    public List<ClassMappingMetadata> getClassMappings() {
        ArrayList<ClassMappingMetadata> classMapMetadata = new ArrayList<ClassMappingMetadata>();
        for (ClassMap classMap : this.classMappings.getAll().values()) {
            classMapMetadata.add(new DozerClassMappingMetadata(classMap));
        }
        return classMapMetadata;
    }

    @Override
    public List<ClassMappingMetadata> getClassMappingsBySourceName(String sourceClassName) {
        if (sourceClassName == null) {
            throw new IllegalArgumentException("The source class name cannot be null.");
        }
        return this.buildMappingListBySourceName(sourceClassName);
    }

    @Override
    public List<ClassMappingMetadata> getClassMappingsByDestinationName(String destinationClassName) {
        if (destinationClassName == null) {
            throw new IllegalArgumentException("The destination class name cannot be null.");
        }
        return this.buildMappingListByDestinationName(destinationClassName);
    }

    @Override
    public ClassMappingMetadata getClassMappingByName(String sourceClassName, String destinationClassName) {
        if (sourceClassName == null || destinationClassName == null) {
            throw new IllegalArgumentException("The source and destination class names need to be specified.");
        }
        return this.findMappingByName(sourceClassName, destinationClassName);
    }

    @Override
    public List<ClassMappingMetadata> getClassMappingsBySource(Class<?> sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException("The source class cannt be null.");
        }
        return this.buildMappingListBySourceName(sourceClass.getName());
    }

    @Override
    public List<ClassMappingMetadata> getClassMappingsByDestination(Class<?> destinationClass) {
        if (destinationClass == null) {
            throw new IllegalArgumentException("The destination class cannot be null.");
        }
        return this.buildMappingListByDestinationName(destinationClass.getName());
    }

    @Override
    public ClassMappingMetadata getClassMapping(Class<?> sourceClass, Class<?> destinationClass) {
        if (sourceClass == null || destinationClass == null) {
            throw new IllegalArgumentException("The source and destination classes need to be specified.");
        }
        return this.findMappingByName(sourceClass.getName(), destinationClass.getName());
    }

    private List<ClassMappingMetadata> buildMappingListBySourceName(String sourceClassName) {
        ArrayList<ClassMappingMetadata> classMapMetadata = new ArrayList<ClassMappingMetadata>();
        for (ClassMap classMap : this.classMappings.getAll().values()) {
            if (!classMap.getSrcClassName().equals(sourceClassName)) continue;
            classMapMetadata.add(new DozerClassMappingMetadata(classMap));
        }
        return classMapMetadata;
    }

    private List<ClassMappingMetadata> buildMappingListByDestinationName(String destinationClassName) {
        ArrayList<ClassMappingMetadata> classMapMetadata = new ArrayList<ClassMappingMetadata>();
        for (ClassMap classMap : this.classMappings.getAll().values()) {
            if (!classMap.getDestClassName().equals(destinationClassName)) continue;
            classMapMetadata.add(new DozerClassMappingMetadata(classMap));
        }
        return classMapMetadata;
    }

    private ClassMappingMetadata findMappingByName(String sourceClassName, String destinationClassName) {
        for (ClassMap classMap : this.classMappings.getAll().values()) {
            if (!classMap.getSrcClassName().equals(sourceClassName) || !classMap.getDestClassName().equals(destinationClassName)) continue;
            return new DozerClassMappingMetadata(classMap);
        }
        throw new MetadataLookupException("No mapping definition found for: " + sourceClassName + " -> " + destinationClassName + ".");
    }
}

