/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

enum Architecture {
    x86,
    x64,
    ppc64le,
    s390x,
    arm64,
    armv7l;


    public static Architecture guess() {
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        if (arch.equals("ppc64le")) {
            return ppc64le;
        }
        if (arch.equals("aarch64")) {
            return arm64;
        }
        if (arch.equals("s390x")) {
            return s390x;
        }
        if (arch.equals("arm") && version.contains("v7")) {
            return armv7l;
        }
        return arch.contains("64") ? x64 : x86;
    }
}

