/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.journal.AbstractJournalVisitable;
import org.adoptopenjdk.jitwatch.journal.JournalUtil;
import org.adoptopenjdk.jitwatch.model.AnnotationException;
import org.adoptopenjdk.jitwatch.model.CompilerName;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IParseDictionary;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.LogParseException;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.model.bytecode.BCAnnotationType;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeAnnotations;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.LineAnnotation;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;
import org.adoptopenjdk.jitwatch.model.bytecode.UncommonTrap;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.adoptopenjdk.jitwatch.util.TooltipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeAnnotationBuilder
extends AbstractJournalVisitable {
    private static final Logger logger = LoggerFactory.getLogger(BytecodeAnnotationBuilder.class);
    private IMetaMember member;
    private IReadOnlyJITDataModel model;
    private BytecodeAnnotations bcAnnotations = new BytecodeAnnotations();

    public BytecodeAnnotationBuilder() {
        this.ignoreTags.add("klass");
        this.ignoreTags.add("type");
        this.ignoreTags.add("dependency");
        this.ignoreTags.add("phase");
        this.ignoreTags.add("parse_done");
        this.ignoreTags.add("direct_call");
        this.ignoreTags.add("parse");
        this.ignoreTags.add("phase_done");
        this.ignoreTags.add("predicted_call");
    }

    public BytecodeAnnotations buildBytecodeAnnotations(IMetaMember member, IReadOnlyJITDataModel model) throws AnnotationException {
        block4: {
            this.member = member;
            this.model = model;
            this.bcAnnotations.clear();
            if (member != null) {
                if (!member.isCompiled()) {
                    return this.bcAnnotations;
                }
                try {
                    JournalUtil.visitParseTagsOfLastTask(member.getJournal(), this);
                    JournalUtil.visitOptimizerTagsOfLastTask(member.getJournal(), this);
                }
                catch (LogParseException e) {
                    logger.error("Error building bytecode annotations", (Throwable)e);
                    Throwable cause = e.getCause();
                    if (cause == null) break block4;
                    logger.error("Cause", cause);
                    if (!(cause instanceof AnnotationException)) break block4;
                    throw (AnnotationException)cause;
                }
            }
        }
        return this.bcAnnotations;
    }

    @Override
    public void visitTag(Tag tag, IParseDictionary parseDictionary) throws LogParseException {
        switch (tag.getName()) {
            case "parse": {
                this.visitTagParse(tag, parseDictionary);
                break;
            }
            case "eliminate_allocation": {
                this.visitTagEliminateAllocation(tag, parseDictionary);
                break;
            }
            case "eliminate_lock": {
                this.visitTagEliminateLock(tag, parseDictionary);
                break;
            }
            default: {
                this.handleOther(tag);
            }
        }
    }

    private void visitTagParse(Tag tag, IParseDictionary parseDictionary) throws LogParseException {
        String methodID = tag.getAttribute("method");
        if (JournalUtil.memberMatchesMethodID(this.member, methodID, parseDictionary)) {
            try {
                CompilerName compilerName = JournalUtil.getCompilerNameForLastTask(this.member.getJournal());
                this.buildParseTagAnnotations(tag, this.bcAnnotations, compilerName, parseDictionary);
            }
            catch (Exception e) {
                throw new LogParseException("Could not parse annotations", e);
            }
        } else {
            logger.warn("Parse tag does not appear to be for member {}", (Object)this.member.getFullyQualifiedMemberName());
        }
    }

    private void visitTagEliminateAllocation(Tag tag, IParseDictionary parseDictionary) {
        List<Tag> childrenJVMS = tag.getNamedChildren("jvms");
        for (Tag tagJVMS : childrenJVMS) {
            String bci = tagJVMS.getAttribute("bci");
            if (bci == null) continue;
            try {
                int bciValue = Integer.parseInt(bci);
                BytecodeInstruction instr = this.getInstructionAtIndex(bciValue);
                if (instr == null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Object does not escape method.\n");
                builder.append("Heap allocation has been eliminated.\n");
                String typeID = tag.getAttribute("type");
                String typeOrKlassName = null;
                if (typeID != null && (typeOrKlassName = ParseUtil.lookupType(typeID, parseDictionary)) != null) {
                    builder.append("Eliminated allocation was of type ").append(typeOrKlassName);
                }
                this.bcAnnotations.addAnnotation(bciValue, new LineAnnotation(builder.toString(), BCAnnotationType.ELIMINATED_ALLOCATION));
                if (instr.getOpcode() == Opcode.NEW) {
                    instr.setEliminated(true);
                    continue;
                }
                logger.warn("Found heap elimination on instruction that is not Opcode.NEW: {} @ {} ({}/{})", new Object[]{instr.getOpcode(), instr.getOffset(), typeID, typeOrKlassName});
            }
            catch (NumberFormatException nfe) {
                logger.error("Couldn't parse BCI", (Throwable)nfe);
            }
        }
    }

    private void visitTagEliminateLock(Tag tag, IParseDictionary parseDictionary) {
        List<Tag> childrenJVMS = tag.getNamedChildren("jvms");
        if (childrenJVMS.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("A lock has been eliminated").append("\n");
            builder.append("Call chain:").append("\n");
            int depth = 0;
            for (Tag tagJVMS : childrenJVMS) {
                String bci = tagJVMS.getAttribute("bci");
                if (bci == null) continue;
                try {
                    IMetaMember member;
                    int bciValue = Integer.parseInt(bci);
                    String methodID = tagJVMS.getAttribute("method");
                    if (methodID != null && (member = ParseUtil.lookupMember(methodID, parseDictionary, this.model)) != null) {
                        if (bciValue != -1) {
                            builder.append(StringUtil.repeat(' ', depth * 2)).append("->").append(' ');
                            ++depth;
                        }
                        builder.append(member.toStringUnqualifiedMethodName(true));
                    }
                    builder.append("\n");
                    if (bciValue == -1) continue;
                    this.bcAnnotations.addAnnotation(bciValue, new LineAnnotation(builder.toString().trim(), BCAnnotationType.LOCK_ELISION));
                    BytecodeInstruction instr = this.getInstructionAtIndex(bciValue);
                    if (instr == null || !instr.isLock()) continue;
                    instr.setEliminated(true);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Couldn't parse BCI", (Throwable)nfe);
                }
            }
        }
    }

    private void visitTagUncommonTrap(Tag tag) {
        UncommonTrap trap = UncommonTrap.parse(tag);
        if (trap != null) {
            this.bcAnnotations.addAnnotation(trap.getBCI(), new LineAnnotation(trap.toString(), BCAnnotationType.UNCOMMON_TRAP));
        }
    }

    private void buildParseTagAnnotations(Tag parseTag, BytecodeAnnotations annotations, CompilerName compilerName, IParseDictionary parseDictionary) throws AnnotationException {
        List<Tag> children = parseTag.getChildren();
        int currentBytecode = -1;
        HashMap<String, String> methodAttrs = new HashMap<String, String>();
        HashMap<String, String> callAttrs = new HashMap<String, String>();
        String currentMethodID = parseTag.getAttribute("method");
        boolean isC2 = false;
        if (compilerName == CompilerName.C2) {
            isC2 = true;
        }
        boolean inMethod = true;
        BytecodeInstruction currentInstruction = null;
        block22: for (Tag child : children) {
            String name = child.getName();
            Map<String, String> tagAttrs = child.getAttributes();
            switch (name) {
                case "bc": {
                    int opcodeValue;
                    String bciAttr = tagAttrs.get("bci");
                    String codeAttr = tagAttrs.get("code");
                    currentBytecode = Integer.parseInt(bciAttr);
                    int code = Integer.parseInt(codeAttr);
                    callAttrs.clear();
                    currentInstruction = this.getInstructionAtIndex(currentBytecode);
                    inMethod = false;
                    if (currentInstruction == null || (opcodeValue = currentInstruction.getOpcode().getValue()) != code) continue block22;
                    inMethod = true;
                    break;
                }
                case "call": {
                    callAttrs.clear();
                    callAttrs.putAll(tagAttrs);
                    break;
                }
                case "method": {
                    methodAttrs.clear();
                    methodAttrs.putAll(tagAttrs);
                    String nameAttr = (String)methodAttrs.get("name");
                    inMethod = false;
                    if (nameAttr == null || currentInstruction == null || !currentInstruction.hasComment()) continue block22;
                    String comment = currentInstruction.getComment();
                    inMethod = comment.contains(nameAttr);
                    break;
                }
                case "inline_success": {
                    if (!inMethod && !isC2) continue block22;
                    if (!BytecodeAnnotationBuilder.sanityCheckInline(currentInstruction)) {
                        throw new AnnotationException("Expected an invoke instruction (in INLINE_SUCCESS)", currentBytecode, currentInstruction);
                    }
                    CharSequence reason = tagAttrs.get("reason");
                    String annotationText = TooltipUtil.buildInlineAnnotationText(true, (String)reason, callAttrs, methodAttrs, parseDictionary);
                    this.bcAnnotations.addAnnotation(currentBytecode, new LineAnnotation(annotationText, BCAnnotationType.INLINE_SUCCESS));
                    break;
                }
                case "inline_fail": {
                    if (!inMethod && !isC2) continue block22;
                    if (!BytecodeAnnotationBuilder.sanityCheckInline(currentInstruction)) {
                        throw new AnnotationException("Expected an invoke instruction (in INLINE_FAIL)", currentBytecode, currentInstruction);
                    }
                    CharSequence reason = tagAttrs.get("reason");
                    String annotationText = TooltipUtil.buildInlineAnnotationText(false, (String)reason, callAttrs, methodAttrs, parseDictionary);
                    this.bcAnnotations.addAnnotation(currentBytecode, new LineAnnotation(annotationText, BCAnnotationType.INLINE_FAIL));
                    break;
                }
                case "branch": {
                    if (this.bcAnnotations.hasAnnotationsForBCI(currentBytecode) || !inMethod && !isC2) continue block22;
                    if (!BytecodeAnnotationBuilder.sanityCheckBranch(currentInstruction)) {
                        throw new AnnotationException("Expected a branch instruction (BRANCH)", currentBytecode, currentInstruction);
                    }
                    String branchAnnotation = this.buildBranchAnnotation(tagAttrs);
                    this.bcAnnotations.addAnnotation(currentBytecode, new LineAnnotation(branchAnnotation, BCAnnotationType.BRANCH));
                    break;
                }
                case "intrinsic": {
                    if (!inMethod && !isC2) continue block22;
                    if (!BytecodeAnnotationBuilder.sanityCheckIntrinsic(currentInstruction)) {
                        throw new AnnotationException("Expected an invoke instruction (INTRINSIC)", currentBytecode, currentInstruction);
                    }
                    CharSequence reason = new StringBuilder();
                    ((StringBuilder)reason).append("Intrinsic: ").append(tagAttrs.get("id"));
                    this.bcAnnotations.addAnnotation(currentBytecode, new LineAnnotation(((StringBuilder)reason).toString(), BCAnnotationType.INTRINSIC_USED));
                    break;
                }
                case "uncommon_trap": {
                    String trapMethod = child.getAttribute("method");
                    if (trapMethod != null && !currentMethodID.equals(trapMethod)) continue block22;
                    this.visitTagUncommonTrap(child);
                    break;
                }
                case "phase": {
                    String phaseName = tagAttrs.get("name");
                    if ("parse_hir".equals(phaseName)) {
                        this.buildParseTagAnnotations(child, annotations, compilerName, parseDictionary);
                        break;
                    }
                    logger.warn("Don't know how to handle phase {}", (Object)phaseName);
                    break;
                }
                default: {
                    this.handleOther(child);
                }
            }
        }
    }

    private String buildBranchAnnotation(Map<String, String> tagAttrs) {
        String count = tagAttrs.get("cnt");
        String taken = tagAttrs.get("taken");
        String notTaken = tagAttrs.get("not_taken");
        String prob = tagAttrs.get("prob");
        StringBuilder reason = new StringBuilder();
        if (count != null) {
            reason.append("Count: ").append(count).append('\n');
        }
        reason.append("Branch taken: ").append(taken).append('\n').append("Branch not taken: ").append(notTaken);
        if (prob != null) {
            reason.append('\n').append("Taken Probability: ").append(prob);
        }
        return reason.toString();
    }

    public static boolean sanityCheckInline(BytecodeInstruction instr) {
        return BytecodeAnnotationBuilder.sanityCheckInvoke(instr);
    }

    public static boolean sanityCheckIntrinsic(BytecodeInstruction instr) {
        return BytecodeAnnotationBuilder.sanityCheckInvoke(instr);
    }

    private static boolean sanityCheckInvoke(BytecodeInstruction instr) {
        boolean sane = false;
        if (instr != null) {
            sane = instr.isInvoke();
        }
        return sane;
    }

    public static boolean sanityCheckBranch(BytecodeInstruction instr) {
        boolean sane = false;
        if (instr != null) {
            sane = instr.getOpcode().getMnemonic().startsWith("if");
        }
        return sane;
    }

    private BytecodeInstruction getInstructionAtIndex(int index) {
        BytecodeInstruction found = null;
        for (BytecodeInstruction instruction : this.member.getInstructions()) {
            if (instruction.getOffset() != index) continue;
            found = instruction;
            break;
        }
        return found;
    }
}

