/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamSwitch;
import org.adoptopenjdk.jitwatch.model.bytecode.IBytecodeParam;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeInstruction {
    private int offset;
    private Opcode opcode;
    private List<IBytecodeParam> parameters = new ArrayList<IBytecodeParam>();
    private boolean hasComment;
    private String comment;
    private static final Logger logger = LoggerFactory.getLogger(BytecodeInstruction.class);
    private boolean isEliminated = false;

    public void setEliminated(boolean eliminated) {
        this.isEliminated = eliminated;
    }

    public boolean isEliminated() {
        return this.isEliminated;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public List<IBytecodeParam> getParameters() {
        return this.parameters;
    }

    public void addParameter(IBytecodeParam parameter) {
        this.parameters.add(parameter);
    }

    public boolean hasParameters() {
        return this.parameters.size() > 0;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentWithMemberPrefixStripped() {
        if (this.comment != null && this.comment.startsWith("// Method")) {
            return this.comment.substring("// Method".length()).trim();
        }
        if (this.comment != null && this.comment.startsWith("// InterfaceMethod")) {
            return this.comment.substring("// InterfaceMethod".length()).trim();
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.hasComment = true;
    }

    public boolean hasComment() {
        return this.hasComment;
    }

    public String toString() {
        return this.toString(0, 0);
    }

    public boolean isInvoke() {
        return this.opcode != null && (this.opcode == Opcode.INVOKEVIRTUAL || this.opcode == Opcode.INVOKESPECIAL || this.opcode == Opcode.INVOKESTATIC || this.opcode == Opcode.INVOKEINTERFACE || this.opcode == Opcode.INVOKEDYNAMIC);
    }

    public boolean isLock() {
        return this.opcode != null && this.opcode == Opcode.MONITORENTER;
    }

    public boolean isSwitch() {
        return this.opcode != null && (this.opcode == Opcode.TABLESWITCH || this.opcode == Opcode.LOOKUPSWITCH);
    }

    public int getLabelLines() {
        int result = 1;
        if (this.isSwitch() && this.parameters.size() == 1) {
            BCParamSwitch switchParam = (BCParamSwitch)this.parameters.get(0);
            result = 2 + switchParam.getSize();
        }
        return result;
    }

    public String toString(int maxOffset, int line) {
        if (this.isSwitch()) {
            return this.toStringSwitch(maxOffset, line);
        }
        return this.toStringNonSwitch(maxOffset);
    }

    private String toStringNonSwitch(int maxOffset) {
        StringBuilder toStringBuilder = new StringBuilder();
        int offsetWidth = Integer.toString(maxOffset).length();
        toStringBuilder.append(StringUtil.alignRight(this.offset, offsetWidth)).append(':').append(' ');
        if (this.opcode != null) {
            String mnemonic = this.opcode.getMnemonic();
            toStringBuilder.append(StringUtil.alignLeft(mnemonic, 16));
        }
        if (this.hasParameters()) {
            StringBuilder paramBuilder = new StringBuilder();
            for (IBytecodeParam parameter : this.parameters) {
                paramBuilder.append(parameter.toString()).append(',').append(' ');
            }
            int paramLength = paramBuilder.length();
            paramBuilder.delete(paramLength - 2, paramLength);
            String paramString = StringUtil.alignLeft(paramBuilder.toString(), 5);
            toStringBuilder.append(paramString);
        }
        if (this.hasComment) {
            toStringBuilder.append(this.comment);
        }
        return toStringBuilder.toString();
    }

    private String toStringSwitch(int maxOffset, int line) {
        int maxLines = this.getLabelLines();
        StringBuilder toStringBuilder = new StringBuilder();
        int offsetWidth = Integer.toString(maxOffset).length();
        if (line == 0) {
            toStringBuilder.append(StringUtil.alignRight(this.offset, offsetWidth)).append(':').append(' ');
            toStringBuilder.append(this.opcode.getMnemonic());
            toStringBuilder.append(' ').append('{');
            if (this.hasComment) {
                toStringBuilder.append(' ').append(this.comment);
            }
        } else if (line == maxLines - 1) {
            toStringBuilder.append(StringUtil.alignRight("}", offsetWidth + 3));
        } else if (this.parameters.size() == 1 && this.parameters.get(0) instanceof BCParamSwitch) {
            BCParamSwitch param = (BCParamSwitch)this.parameters.get(0);
            toStringBuilder.append(param.toString(line - 1));
        } else {
            logger.error("Bad parameters set on tableswitch or lookupswitch, cannot create toString()");
        }
        return toStringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.hasComment ? 1231 : 1237);
        result = 31 * result + this.offset;
        result = 31 * result + (this.opcode == null ? 0 : this.opcode.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BytecodeInstruction other = (BytecodeInstruction)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.hasComment != other.hasComment) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.opcode != other.opcode) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

