/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.ConstantPool;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBC {
    private ConstantPool constantPool;
    private String sourceFile;
    private int majorVersion;
    private int minorVersion;
    private String fqClassName;
    private List<MemberBytecode> memberBytecodeList = new ArrayList<MemberBytecode>();
    private List<String> innerClassNames = new ArrayList<String>();
    private Map<String, String> classGenericsMap = new LinkedHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(ClassBC.class);

    public ClassBC(String fqClassName) {
        this.fqClassName = fqClassName;
    }

    public String getFullyQualifiedClassName() {
        return this.fqClassName;
    }

    public String getPackageName() {
        return StringUtil.getPackageName(this.fqClassName);
    }

    public void addMemberBytecode(MemberBytecode memberBytecode) {
        this.memberBytecodeList.add(memberBytecode);
    }

    public List<MemberBytecode> getMemberBytecodeList() {
        return Collections.unmodifiableList(this.memberBytecodeList);
    }

    public void addGenericsMapping(String key, String value) {
        this.classGenericsMap.put(key, value);
    }

    public Map<String, String> getGenericsMap() {
        return Collections.unmodifiableMap(this.classGenericsMap);
    }

    public void addInnerClassName(String name) {
        this.innerClassNames.add(name);
    }

    public List<String> getInnerClassNames() {
        return Collections.unmodifiableList(this.innerClassNames);
    }

    public MemberBytecode getMemberBytecode(IMetaMember member) {
        MemberBytecode result = null;
        if (member != null) {
            for (MemberBytecode item : this.memberBytecodeList) {
                if (!member.matchesSignature(item.getMemberSignatureParts(), true)) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public MemberBytecode getMemberBytecodeForSignature(MemberSignatureParts msp) {
        MemberBytecode result = null;
        if (msp != null) {
            for (MemberBytecode item : this.memberBytecodeList) {
                if (!msp.equals(item.getMemberSignatureParts())) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getJavaVersion() {
        String result;
        switch (this.majorVersion) {
            case 52: {
                result = "Java 8";
                break;
            }
            case 51: {
                result = "Java 7";
                break;
            }
            case 50: {
                result = "Java 6.0";
                break;
            }
            case 49: {
                result = "Java 5.0";
                break;
            }
            case 48: {
                result = "Java 1.4";
                break;
            }
            case 47: {
                result = "Java 1.3";
                break;
            }
            case 46: {
                result = "Java 1.2";
                break;
            }
            case 45: {
                result = "Java 1.1";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("major version:").append(this.majorVersion).append('\n');
        builder.append("minor version:").append(this.minorVersion).append('\n');
        for (MemberBytecode item : this.memberBytecodeList) {
            builder.append("member: ").append(item).append('\n');
        }
        return builder.toString();
    }
}

