/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.treevisitor;

import java.util.List;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.MetaPackage;
import org.adoptopenjdk.jitwatch.treevisitor.ITreeVisitable;

public final class TreeVisitor {
    private TreeVisitor() {
    }

    public static void walkTree(IReadOnlyJITDataModel model, ITreeVisitable visitable) {
        visitable.reset();
        List<MetaPackage> roots = model.getPackageManager().getRootPackages();
        for (MetaPackage mp : roots) {
            TreeVisitor.walkPackage(mp, visitable);
        }
    }

    private static void walkPackage(MetaPackage mp, ITreeVisitable visitable) {
        List<MetaPackage> childPackages = mp.getChildPackages();
        for (MetaPackage childPackage : childPackages) {
            TreeVisitor.walkPackage(childPackage, visitable);
        }
        List<MetaClass> packageClasses = mp.getPackageClasses();
        for (MetaClass mc : packageClasses) {
            for (IMetaMember mm : mc.getMetaMembers()) {
                visitable.visit(mm);
            }
        }
    }
}

