/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.github.fommil.netlib;

/**
 * Generated by {@code JavaInterfaceGenerator} from {@code org.netlib.blas} in {@code net.sourceforge.f2j:arpack_combined_all:jar:0.1}.
 * <p>
 * Property {@value #PROPERTY_KEY} defines the implementation to load,
 * defaulting to {@value #FALLBACK}.
 * <p>
 * <i>This requires 1D column-major linearized arrays, as
 * expected by the lower level routines; contrary to
 * typical Java 2D row-major arrays.</i>
 */
@lombok.extern.java.Log
public abstract class BLAS {

  private static final String FALLBACK = "com.github.fommil.netlib.F2jBLAS";
  private static final String IMPLS = "com.github.fommil.netlib.NativeSystemBLAS,com.github.fommil.netlib.NativeRefBLAS,com.github.fommil.netlib.F2jBLAS";
  private static final String PROPERTY_KEY = "com.github.fommil.netlib.BLAS";
  private static final BLAS INSTANCE;
  static {
    try {
      String[] classNames = System.getProperty(PROPERTY_KEY, IMPLS).split(",");
      BLAS impl = null;
      for (String className: classNames) {
        try {
          impl = load(className);
          break;
        } catch (Throwable e) {
          log.warning("Failed to load implementation from: " + className);
        }
      }
      if (impl == null) {
        log.warning("Using the fallback implementation.");
        impl = load(FALLBACK);
      }
      INSTANCE = impl;
      log.config("Implementation provided by " + INSTANCE.getClass());
    } catch (Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  private static BLAS load(String className) throws Exception {
    Class klass = Class.forName(className);
    return (BLAS) klass.newInstance();
  }

  /**
   * @return the environment-defined implementation.
   */
  public static BLAS getInstance() {
    return INSTANCE;
  }

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     takes the sum of the absolute values.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @return
   */
  abstract public double dasum(int n, double[] dx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     takes the sum of the absolute values.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @return
   */
  abstract public double dasum(int n, double[] dx, int _dx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     constant times a vector plus a vector.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param da
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * 
   */
  abstract public void daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     constant times a vector plus a vector.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param da
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * 
   */
  abstract public void daxpy(int n, double da, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     copies a vector, x, to a vector, y.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * 
   */
  abstract public void dcopy(int n, double[] dx, int incx, double[] dy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     copies a vector, x, to a vector, y.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * 
   */
  abstract public void dcopy(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     forms the dot product of two vectors.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * @return
   */
  abstract public double ddot(int n, double[] dx, int incx, double[] dy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     forms the dot product of two vectors.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * @return
   */
  abstract public double ddot(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n band matrix, with kl sub-diagonals and ku super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  KL     - INTEGER.
   *           On entry, KL specifies the number of sub-diagonals of the
   *           matrix A. KL must satisfy  0 .le. KL.
   *           Unchanged on exit.
   *
   *  KU     - INTEGER.
   *           On entry, KU specifies the number of super-diagonals of the
   *           matrix A. KU must satisfy  0 .le. KU.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading ( kl + ku + 1 ) by n part of the
   *           array A must contain the matrix of coefficients, supplied
   *           column by column, with the leading diagonal of the matrix in
   *           row ( ku + 1 ) of the array, the first super-diagonal
   *           starting at position 2 in row ku, the first sub-diagonal
   *           starting at position 1 in row ( ku + 2 ), and so on.
   *           Elements in the array A that do not correspond to elements
   *           in the band matrix (such as the top left ku by ku triangle)
   *           are not referenced.
   *           The following program segment will transfer a band matrix
   *           from conventional full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    K = KU + 1 - J
   *                    DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )
   *                       A( K + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( kl + ku + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void dgbmv(java.lang.String trans, int m, int n, int kl, int ku, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n band matrix, with kl sub-diagonals and ku super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  KL     - INTEGER.
   *           On entry, KL specifies the number of sub-diagonals of the
   *           matrix A. KL must satisfy  0 .le. KL.
   *           Unchanged on exit.
   *
   *  KU     - INTEGER.
   *           On entry, KU specifies the number of super-diagonals of the
   *           matrix A. KU must satisfy  0 .le. KU.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading ( kl + ku + 1 ) by n part of the
   *           array A must contain the matrix of coefficients, supplied
   *           column by column, with the leading diagonal of the matrix in
   *           row ( ku + 1 ) of the array, the first super-diagonal
   *           starting at position 2 in row ku, the first sub-diagonal
   *           starting at position 1 in row ( ku + 2 ), and so on.
   *           Elements in the array A that do not correspond to elements
   *           in the band matrix (such as the top left ku by ku triangle)
   *           are not referenced.
   *           The following program segment will transfer a band matrix
   *           from conventional full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    K = KU + 1 - J
   *                    DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )
   *                       A( K + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( kl + ku + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void dgbmv(java.lang.String trans, int m, int n, int kl, int ku, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*op( A )*op( B ) + beta*C,
   *
   *  where  op( X ) is one of
   *
   *     op( X ) = X   or   op( X ) = X',
   *
   *  alpha and beta are scalars, and A, B and C are matrices, with op( A )
   *  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n',  op( A ) = A.
   *
   *              TRANSA = 'T' or 't',  op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c',  op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  TRANSB - CHARACTER*1.
   *           On entry, TRANSB specifies the form of op( B ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSB = 'N' or 'n',  op( B ) = B.
   *
   *              TRANSB = 'T' or 't',  op( B ) = B'.
   *
   *              TRANSB = 'C' or 'c',  op( B ) = B'.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies  the number  of rows  of the  matrix
   *           op( A )  and of the  matrix  C.  M  must  be at least  zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N  specifies the number  of columns of the matrix
   *           op( B ) and the number of columns of the matrix C. N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry,  K  specifies  the number of columns of the matrix
   *           op( A ) and the number of rows of the matrix op( B ). K must
   *           be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.
   *           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by m  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. When  TRANSA = 'N' or 'n' then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is
   *           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.
   *           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  n by k  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in the calling (sub) program. When  TRANSB = 'N' or 'n' then
   *           LDB must be at least  max( 1, k ), otherwise  LDB must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n  matrix
   *           ( alpha*op( A )*op( B ) + beta*C ).
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param transa
   * @param transb
   * @param m
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void dgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*op( A )*op( B ) + beta*C,
   *
   *  where  op( X ) is one of
   *
   *     op( X ) = X   or   op( X ) = X',
   *
   *  alpha and beta are scalars, and A, B and C are matrices, with op( A )
   *  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n',  op( A ) = A.
   *
   *              TRANSA = 'T' or 't',  op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c',  op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  TRANSB - CHARACTER*1.
   *           On entry, TRANSB specifies the form of op( B ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSB = 'N' or 'n',  op( B ) = B.
   *
   *              TRANSB = 'T' or 't',  op( B ) = B'.
   *
   *              TRANSB = 'C' or 'c',  op( B ) = B'.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies  the number  of rows  of the  matrix
   *           op( A )  and of the  matrix  C.  M  must  be at least  zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N  specifies the number  of columns of the matrix
   *           op( B ) and the number of columns of the matrix C. N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry,  K  specifies  the number of columns of the matrix
   *           op( A ) and the number of rows of the matrix op( B ). K must
   *           be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.
   *           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by m  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. When  TRANSA = 'N' or 'n' then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is
   *           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.
   *           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  n by k  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in the calling (sub) program. When  TRANSB = 'N' or 'n' then
   *           LDB must be at least  max( 1, k ), otherwise  LDB must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n  matrix
   *           ( alpha*op( A )*op( B ) + beta*C ).
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param transa
   * @param transb
   * @param m
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void dgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry with BETA non-zero, the incremented array Y
   *           must contain the vector y. On exit, Y is overwritten by the
   *           updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void dgemv(java.lang.String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry with BETA non-zero, the incremented array Y
   *           must contain the vector y. On exit, Y is overwritten by the
   *           updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void dgemv(java.lang.String trans, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGER   performs the rank 1 operation
   *
   *     A := alpha*x*y' + A,
   *
   *  where alpha is a scalar, x is an m element vector, y is an n element
   *  vector and A is an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the m
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients. On exit, A is
   *           overwritten by the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param a
   * @param lda
   * 
   */
  abstract public void dger(int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGER   performs the rank 1 operation
   *
   *     A := alpha*x*y' + A,
   *
   *  where alpha is a scalar, x is an m element vector, y is an n element
   *  vector and A is an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the m
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients. On exit, A is
   *           overwritten by the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void dger(int m, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DNRM2 returns the euclidean norm of a vector via the function
   *  name, so that
   *
   *     DNRM2 := sqrt( x'*x )
   *
   *
   *  -- This version written on 25-October-1982.
   *     Modified on 14-October-1993 to inline the call to DLASSQ.
   *     Sven Hammarling, Nag Ltd.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param x
   * @param incx
   * @return
   */
  abstract public double dnrm2(int n, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DNRM2 returns the euclidean norm of a vector via the function
   *  name, so that
   *
   *     DNRM2 := sqrt( x'*x )
   *
   *
   *  -- This version written on 25-October-1982.
   *     Modified on 14-October-1993 to inline the call to DLASSQ.
   *     Sven Hammarling, Nag Ltd.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param x
   * @param _x_offset
   * @param incx
   * @return
   */
  abstract public double dnrm2(int n, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     applies a plane rotation.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * @param c
   * @param s
   * 
   */
  abstract public void drot(int n, double[] dx, int incx, double[] dy, int incy, double c, double s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     applies a plane rotation.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * @param c
   * @param s
   * 
   */
  abstract public void drot(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double c, double s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     construct givens plane rotation.
   *     jack dongarra, linpack, 3/11/78.
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param da
   * @param db
   * @param c
   * @param s
   * 
   */
  abstract public void drotg(org.netlib.util.doubleW da, org.netlib.util.doubleW db, org.netlib.util.doubleW c, org.netlib.util.doubleW s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX
   *
   *     (DX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF DX ARE IN
   *     (DY**T)
   *
   *     DX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
   *     LX = (-INCX)*N, AND SIMILARLY FOR SY USING LY AND INCY.
   *     WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0
   *
   *       (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)
   *     H=(          )    (          )    (          )    (          )
   *       (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).
   *     SEE DROTMG FOR A DESCRIPTION OF DATA STORAGE IN DPARAM.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  DX     (input/output) DOUBLE PRECISION array, dimension N
   *         double precision vector with 5 elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of DX
   *
   *  DY     (input/output) DOUBLE PRECISION array, dimension N
   *         double precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of DY
   *
   *  DPARAM (input/output)  DOUBLE PRECISION array, dimension 5 
   *     DPARAM(1)=DFLAG
   *     DPARAM(2)=DH11
   *     DPARAM(3)=DH21
   *     DPARAM(4)=DH12
   *     DPARAM(5)=DH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * @param dparam
   * 
   */
  abstract public void drotm(int n, double[] dx, int incx, double[] dy, int incy, double[] dparam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX
   *
   *     (DX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF DX ARE IN
   *     (DY**T)
   *
   *     DX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
   *     LX = (-INCX)*N, AND SIMILARLY FOR SY USING LY AND INCY.
   *     WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0
   *
   *       (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)
   *     H=(          )    (          )    (          )    (          )
   *       (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).
   *     SEE DROTMG FOR A DESCRIPTION OF DATA STORAGE IN DPARAM.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  DX     (input/output) DOUBLE PRECISION array, dimension N
   *         double precision vector with 5 elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of DX
   *
   *  DY     (input/output) DOUBLE PRECISION array, dimension N
   *         double precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of DY
   *
   *  DPARAM (input/output)  DOUBLE PRECISION array, dimension 5 
   *     DPARAM(1)=DFLAG
   *     DPARAM(2)=DH11
   *     DPARAM(3)=DH21
   *     DPARAM(4)=DH12
   *     DPARAM(5)=DH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * @param dparam
   * @param _dparam_offset
   * 
   */
  abstract public void drotm(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double[] dparam, int _dparam_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS
   *     THE SECOND COMPONENT OF THE 2-VECTOR  (DSQRT(DD1)*DX1,DSQRT(DD2)*
   *     DY2)**T.
   *     WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0
   *
   *       (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)
   *     H=(          )    (          )    (          )    (          )
   *       (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).
   *     LOCATIONS 2-4 OF DPARAM CONTAIN DH11, DH21, DH12, AND DH22
   *     RESPECTIVELY. (VALUES OF 1.D0, -1.D0, OR 0.D0 IMPLIED BY THE
   *     VALUE OF DPARAM(1) ARE NOT STORED IN DPARAM.)
   *
   *     THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE
   *     INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE
   *     OF DD1 AND DD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM.
   *
   *
   *  Arguments
   *  =========
   *
   *  DD1    (input/output) DOUBLE PRECISION
   *
   *  DD2    (input/output) DOUBLE PRECISION 
   *
   *  DX1    (input/output) DOUBLE PRECISION 
   *
   *  DY1    (input) DOUBLE PRECISION
   *
   *  DPARAM (input/output)  DOUBLE PRECISION array, dimension 5
   *     DPARAM(1)=DFLAG
   *     DPARAM(2)=DH11
   *     DPARAM(3)=DH21
   *     DPARAM(4)=DH12
   *     DPARAM(5)=DH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param dd1
   * @param dd2
   * @param dx1
   * @param dy1
   * @param dparam
   * 
   */
  abstract public void drotmg(org.netlib.util.doubleW dd1, org.netlib.util.doubleW dd2, org.netlib.util.doubleW dx1, double dy1, double[] dparam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS
   *     THE SECOND COMPONENT OF THE 2-VECTOR  (DSQRT(DD1)*DX1,DSQRT(DD2)*
   *     DY2)**T.
   *     WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0
   *
   *       (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)
   *     H=(          )    (          )    (          )    (          )
   *       (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).
   *     LOCATIONS 2-4 OF DPARAM CONTAIN DH11, DH21, DH12, AND DH22
   *     RESPECTIVELY. (VALUES OF 1.D0, -1.D0, OR 0.D0 IMPLIED BY THE
   *     VALUE OF DPARAM(1) ARE NOT STORED IN DPARAM.)
   *
   *     THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE
   *     INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE
   *     OF DD1 AND DD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM.
   *
   *
   *  Arguments
   *  =========
   *
   *  DD1    (input/output) DOUBLE PRECISION
   *
   *  DD2    (input/output) DOUBLE PRECISION 
   *
   *  DX1    (input/output) DOUBLE PRECISION 
   *
   *  DY1    (input) DOUBLE PRECISION
   *
   *  DPARAM (input/output)  DOUBLE PRECISION array, dimension 5
   *     DPARAM(1)=DFLAG
   *     DPARAM(2)=DH11
   *     DPARAM(3)=DH21
   *     DPARAM(4)=DH12
   *     DPARAM(5)=DH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param dd1
   * @param dd2
   * @param dx1
   * @param dy1
   * @param dparam
   * @param _dparam_offset
   * 
   */
  abstract public void drotmg(org.netlib.util.doubleW dd1, org.netlib.util.doubleW dd2, org.netlib.util.doubleW dx1, double dy1, double[] dparam, int _dparam_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSBMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric band matrix, with k super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the band matrix A is being supplied as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  being supplied.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  being supplied.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry, K specifies the number of super-diagonals of the
   *           matrix A. K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer the upper
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer the lower
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void dsbmv(java.lang.String uplo, int n, int k, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSBMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric band matrix, with k super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the band matrix A is being supplied as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  being supplied.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  being supplied.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry, K specifies the number of super-diagonals of the
   *           matrix A. K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer the upper
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer the lower
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void dsbmv(java.lang.String uplo, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   **
   *     scales a vector by a constant.
   *     uses unrolled loops for increment equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param da
   * @param dx
   * @param incx
   * 
   */
  abstract public void dscal(int n, double da, double[] dx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   **
   *     scales a vector by a constant.
   *     uses unrolled loops for increment equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param da
   * @param dx
   * @param _dx_offset
   * @param incx
   * 
   */
  abstract public void dscal(int n, double da, double[] dx, int _dx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPMV  performs the matrix-vector operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param ap
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void dspmv(java.lang.String uplo, int n, double alpha, double[] ap, double[] x, int incx, double beta, double[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPMV  performs the matrix-vector operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void dspmv(java.lang.String uplo, int n, double alpha, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPR    performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param ap
   * 
   */
  abstract public void dspr(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] ap);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPR    performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param ap
   * @param _ap_offset
   * 
   */
  abstract public void dspr(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] ap, int _ap_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param ap
   * 
   */
  abstract public void dspr2(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] ap);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSPR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param ap
   * @param _ap_offset
   * 
   */
  abstract public void dspr2(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] ap, int _ap_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     interchanges two vectors.
   *     uses unrolled loops for increments equal one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @param dy
   * @param incy
   * 
   */
  abstract public void dswap(int n, double[] dx, int incx, double[] dy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     interchanges two vectors.
   *     uses unrolled loops for increments equal one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @param dy
   * @param _dy_offset
   * @param incy
   * 
   */
  abstract public void dswap(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*A*B + beta*C,
   *
   *  or
   *
   *     C := alpha*B*A + beta*C,
   *
   *  where alpha and beta are scalars,  A is a symmetric matrix and  B and
   *  C are  m by n matrices.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE  specifies whether  the  symmetric matrix  A
   *           appears on the  left or right  in the  operation as follows:
   *
   *              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,
   *
   *              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of  the  symmetric  matrix   A  is  to  be
   *           referenced as follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies the number of rows of the matrix  C.
   *           M  must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix C.
   *           N  must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           m  when  SIDE = 'L' or 'l'  and is  n otherwise.
   *           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading m by m upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  m by m  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading n by n upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  n by n  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry, the leading  m by n part of the array  B  must
   *           contain the matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n updated
   *           matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void dsymm(java.lang.String side, java.lang.String uplo, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*A*B + beta*C,
   *
   *  or
   *
   *     C := alpha*B*A + beta*C,
   *
   *  where alpha and beta are scalars,  A is a symmetric matrix and  B and
   *  C are  m by n matrices.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE  specifies whether  the  symmetric matrix  A
   *           appears on the  left or right  in the  operation as follows:
   *
   *              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,
   *
   *              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of  the  symmetric  matrix   A  is  to  be
   *           referenced as follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies the number of rows of the matrix  C.
   *           M  must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix C.
   *           N  must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           m  when  SIDE = 'L' or 'l'  and is  n otherwise.
   *           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading m by m upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  m by m  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading n by n upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  n by n  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry, the leading  m by n part of the array  B  must
   *           contain the matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n updated
   *           matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void dsymm(java.lang.String side, java.lang.String uplo, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void dsymv(java.lang.String uplo, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void dsymv(java.lang.String uplo, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR   performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param a
   * @param lda
   * 
   */
  abstract public void dsyr(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR   performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void dsyr(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an n
   *  by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param a
   * @param lda
   * 
   */
  abstract public void dsyr2(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an n
   *  by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void dsyr2(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR2K  performs one of the symmetric rank 2k operations
   *
   *     C := alpha*A*B' + alpha*B*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*B + alpha*B'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A and B  are  n by k  matrices  in the  first  case  and  k by n
   *  matrices in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*B' + alpha*B*A' +
   *                                        beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns  of the  matrices  A and B,  and on  entry  with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrices  A and B.  K must be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  k by n  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDB must be at least  max( 1, n ), otherwise  LDB must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void dsyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYR2K  performs one of the symmetric rank 2k operations
   *
   *     C := alpha*A*B' + alpha*B*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*B + alpha*B'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A and B  are  n by k  matrices  in the  first  case  and  k by n
   *  matrices in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*B' + alpha*B*A' +
   *                                        beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns  of the  matrices  A and B,  and on  entry  with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrices  A and B.  K must be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  k by n  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDB must be at least  max( 1, n ), otherwise  LDB must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void dsyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYRK  performs one of the symmetric rank k operations
   *
   *     C := alpha*A*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A  is an  n by k  matrix in the first case and a  k by n  matrix
   *  in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*A + beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns   of  the   matrix   A,   and  on   entry   with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrix  A.  K must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void dsyrk(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int lda, double beta, double[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DSYRK  performs one of the symmetric rank k operations
   *
   *     C := alpha*A*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A  is an  n by k  matrix in the first case and a  k by n  matrix
   *  in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*A + beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns   of  the   matrix   A,   and  on   entry   with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrix  A.  K must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - DOUBLE PRECISION.
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void dsyrk(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double beta, double[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTBMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular band matrix, with ( k + 1 ) diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void dtbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int lda, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTBMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular band matrix, with ( k + 1 ) diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTBSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular band matrix, with ( k + 1 )
   *  diagonals.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void dtbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int lda, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTBSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular band matrix, with ( k + 1 )
   *  diagonals.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTPMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param x
   * @param incx
   * 
   */
  abstract public void dtpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTPMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTPSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix, supplied in packed form.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param x
   * @param incx
   * 
   */
  abstract public void dtpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTPSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix, supplied in packed form.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - DOUBLE PRECISION array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRMM  performs one of the matrix-matrix operations
   *
   *     B := alpha*op( A )*B,   or   B := alpha*B*op( A ),
   *
   *  where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE specifies whether  op( A ) multiplies B from
   *           the left or right as follows:
   *
   *              SIDE = 'L' or 'l'   B := alpha*op( A )*B.
   *
   *              SIDE = 'R' or 'r'   B := alpha*B*op( A ).
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain the matrix  B,  and  on exit  is overwritten  by the
   *           transformed matrix.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * 
   */
  abstract public void dtrmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRMM  performs one of the matrix-matrix operations
   *
   *     B := alpha*op( A )*B,   or   B := alpha*B*op( A ),
   *
   *  where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE specifies whether  op( A ) multiplies B from
   *           the left or right as follows:
   *
   *              SIDE = 'L' or 'l'   B := alpha*op( A )*B.
   *
   *              SIDE = 'R' or 'r'   B := alpha*B*op( A ).
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain the matrix  B,  and  on exit  is overwritten  by the
   *           transformed matrix.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void dtrmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void dtrmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int lda, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtrmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRSM  solves one of the matrix equations
   *
   *     op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,
   *
   *  where alpha is a scalar, X and B are m by n matrices, A is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  The matrix X is overwritten on B.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry, SIDE specifies whether op( A ) appears on the left
   *           or right of X as follows:
   *
   *              SIDE = 'L' or 'l'   op( A )*X = alpha*B.
   *
   *              SIDE = 'R' or 'r'   X*op( A ) = alpha*B.
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain  the  right-hand  side  matrix  B,  and  on exit  is
   *           overwritten by the solution matrix  X.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * 
   */
  abstract public void dtrsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRSM  solves one of the matrix equations
   *
   *     op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,
   *
   *  where alpha is a scalar, X and B are m by n matrices, A is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  The matrix X is overwritten on B.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry, SIDE specifies whether op( A ) appears on the left
   *           or right of X as follows:
   *
   *              SIDE = 'L' or 'l'   op( A )*X = alpha*B.
   *
   *              SIDE = 'R' or 'r'   X*op( A ) = alpha*B.
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - DOUBLE PRECISION.
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - DOUBLE PRECISION array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain  the  right-hand  side  matrix  B,  and  on exit  is
   *           overwritten by the solution matrix  X.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void dtrsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void dtrsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int lda, double[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DTRSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - DOUBLE PRECISION array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void dtrsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     finds the index of element having max. absolute value.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param incx
   * @return
   */
  abstract public int idamax(int n, double[] dx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     finds the index of element having max. absolute value.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param dx
   * @param _dx_offset
   * @param incx
   * @return
   */
  abstract public int idamax(int n, double[] dx, int _dx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     finds the index of element having max. absolute value.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @return
   */
  abstract public int isamax(int n, float[] sx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     finds the index of element having max. absolute value.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @return
   */
  abstract public int isamax(int n, float[] sx, int _sx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  LSAME returns .TRUE. if CA is the same letter as CB regardless of
   *  case.
   *
   *  Arguments
   *  =========
   *
   *  CA      (input) CHARACTER*1
   *
   *  CB      (input) CHARACTER*1
   *          CA and CB specify the single characters to be compared.
   *
   * =====================================================================
   *
   *     .. Intrinsic Functions ..
   * </code></pre>
   *
   * @param ca
   * @param cb
   * @return
   */
  abstract public boolean lsame(java.lang.String ca, java.lang.String cb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     takes the sum of the absolute values.
   *     uses unrolled loops for increment equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @return
   */
  abstract public float sasum(int n, float[] sx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     takes the sum of the absolute values.
   *     uses unrolled loops for increment equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @return
   */
  abstract public float sasum(int n, float[] sx, int _sx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     SAXPY constant times a vector plus a vector.
   *     uses unrolled loop for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sa
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * 
   */
  abstract public void saxpy(int n, float sa, float[] sx, int incx, float[] sy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     SAXPY constant times a vector plus a vector.
   *     uses unrolled loop for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sa
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * 
   */
  abstract public void saxpy(int n, float sa, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     copies a vector, x, to a vector, y.
   *     uses unrolled loops for increments equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * 
   */
  abstract public void scopy(int n, float[] sx, int incx, float[] sy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     copies a vector, x, to a vector, y.
   *     uses unrolled loops for increments equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * 
   */
  abstract public void scopy(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     forms the dot product of two vectors.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * @return
   */
  abstract public float sdot(int n, float[] sx, int incx, float[] sy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     forms the dot product of two vectors.
   *     uses unrolled loops for increments equal to one.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * @return
   */
  abstract public float sdot(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  PURPOSE
   *  =======
   *
   *  Compute the inner product of two vectors with extended
   *  precision accumulation.
   *
   *  Returns S.P. result with dot product accumulated in D.P.
   *  SDSDOT = SB + sum for I = 0 to N-1 of SX(LX+I*INCX)*SY(LY+I*INCY),
   *  where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
   *  defined in a similar way using INCY.
   *
   *  AUTHOR
   *  ======
   *  Lawson, C. L., (JPL), Hanson, R. J., (SNLA),
   *  Kincaid, D. R., (U. of Texas), Krogh, F. T., (JPL)
   *
   *  ARGUMENTS 
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  SB     (input) REAL
   *         single precision scalar to be added to inner product
   *
   *  SX     (input) REAL array, dimension (N)
   *         single precision vector with N elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of SX
   *
   *  SY     (input) REAL array, dimension (N)
   *         single precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of SY
   *
   *  SDSDOT (output) REAL
   *         single precision dot product (SB if N .LE. 0)
   *
   *  REFERENCES
   *  ==========
   *
   *  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
   *  Krogh, Basic linear algebra subprograms for Fortran
   *  usage, Algorithm No. 539, Transactions on Mathematical
   *  Software 5, 3 (September 1979), pp. 308-323.
   *
   *  REVISION HISTORY  (YYMMDD)
   *  ==========================
   *      
   *  791001  DATE WRITTEN
   *  890531  Changed all specific intrinsics to generic.  (WRB)
   *  890831  Modified array declarations.  (WRB)
   *  890831  REVISION DATE from Version 3.2
   *  891214  Prologue converted to Version 4.0 format.  (BAB)
   *  920310  Corrected definition of LX in DESCRIPTION.  (WRB)
   *  920501  Reformatted the REFERENCES section.  (WRB)
   *  070118  Reformat to LAPACK coding style
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sb
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * @return
   */
  abstract public float sdsdot(int n, float sb, float[] sx, int incx, float[] sy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  PURPOSE
   *  =======
   *
   *  Compute the inner product of two vectors with extended
   *  precision accumulation.
   *
   *  Returns S.P. result with dot product accumulated in D.P.
   *  SDSDOT = SB + sum for I = 0 to N-1 of SX(LX+I*INCX)*SY(LY+I*INCY),
   *  where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
   *  defined in a similar way using INCY.
   *
   *  AUTHOR
   *  ======
   *  Lawson, C. L., (JPL), Hanson, R. J., (SNLA),
   *  Kincaid, D. R., (U. of Texas), Krogh, F. T., (JPL)
   *
   *  ARGUMENTS 
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  SB     (input) REAL
   *         single precision scalar to be added to inner product
   *
   *  SX     (input) REAL array, dimension (N)
   *         single precision vector with N elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of SX
   *
   *  SY     (input) REAL array, dimension (N)
   *         single precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of SY
   *
   *  SDSDOT (output) REAL
   *         single precision dot product (SB if N .LE. 0)
   *
   *  REFERENCES
   *  ==========
   *
   *  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
   *  Krogh, Basic linear algebra subprograms for Fortran
   *  usage, Algorithm No. 539, Transactions on Mathematical
   *  Software 5, 3 (September 1979), pp. 308-323.
   *
   *  REVISION HISTORY  (YYMMDD)
   *  ==========================
   *      
   *  791001  DATE WRITTEN
   *  890531  Changed all specific intrinsics to generic.  (WRB)
   *  890831  Modified array declarations.  (WRB)
   *  890831  REVISION DATE from Version 3.2
   *  891214  Prologue converted to Version 4.0 format.  (BAB)
   *  920310  Corrected definition of LX in DESCRIPTION.  (WRB)
   *  920501  Reformatted the REFERENCES section.  (WRB)
   *  070118  Reformat to LAPACK coding style
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sb
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * @return
   */
  abstract public float sdsdot(int n, float sb, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGBMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n band matrix, with kl sub-diagonals and ku super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  KL     - INTEGER.
   *           On entry, KL specifies the number of sub-diagonals of the
   *           matrix A. KL must satisfy  0 .le. KL.
   *           Unchanged on exit.
   *
   *  KU     - INTEGER.
   *           On entry, KU specifies the number of super-diagonals of the
   *           matrix A. KU must satisfy  0 .le. KU.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading ( kl + ku + 1 ) by n part of the
   *           array A must contain the matrix of coefficients, supplied
   *           column by column, with the leading diagonal of the matrix in
   *           row ( ku + 1 ) of the array, the first super-diagonal
   *           starting at position 2 in row ku, the first sub-diagonal
   *           starting at position 1 in row ( ku + 2 ), and so on.
   *           Elements in the array A that do not correspond to elements
   *           in the band matrix (such as the top left ku by ku triangle)
   *           are not referenced.
   *           The following program segment will transfer a band matrix
   *           from conventional full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    K = KU + 1 - J
   *                    DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )
   *                       A( K + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( kl + ku + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void sgbmv(java.lang.String trans, int m, int n, int kl, int ku, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGBMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n band matrix, with kl sub-diagonals and ku super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  KL     - INTEGER.
   *           On entry, KL specifies the number of sub-diagonals of the
   *           matrix A. KL must satisfy  0 .le. KL.
   *           Unchanged on exit.
   *
   *  KU     - INTEGER.
   *           On entry, KU specifies the number of super-diagonals of the
   *           matrix A. KU must satisfy  0 .le. KU.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading ( kl + ku + 1 ) by n part of the
   *           array A must contain the matrix of coefficients, supplied
   *           column by column, with the leading diagonal of the matrix in
   *           row ( ku + 1 ) of the array, the first super-diagonal
   *           starting at position 2 in row ku, the first sub-diagonal
   *           starting at position 1 in row ( ku + 2 ), and so on.
   *           Elements in the array A that do not correspond to elements
   *           in the band matrix (such as the top left ku by ku triangle)
   *           are not referenced.
   *           The following program segment will transfer a band matrix
   *           from conventional full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    K = KU + 1 - J
   *                    DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )
   *                       A( K + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( kl + ku + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void sgbmv(java.lang.String trans, int m, int n, int kl, int ku, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGEMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*op( A )*op( B ) + beta*C,
   *
   *  where  op( X ) is one of
   *
   *     op( X ) = X   or   op( X ) = X',
   *
   *  alpha and beta are scalars, and A, B and C are matrices, with op( A )
   *  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n',  op( A ) = A.
   *
   *              TRANSA = 'T' or 't',  op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c',  op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  TRANSB - CHARACTER*1.
   *           On entry, TRANSB specifies the form of op( B ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSB = 'N' or 'n',  op( B ) = B.
   *
   *              TRANSB = 'T' or 't',  op( B ) = B'.
   *
   *              TRANSB = 'C' or 'c',  op( B ) = B'.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies  the number  of rows  of the  matrix
   *           op( A )  and of the  matrix  C.  M  must  be at least  zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N  specifies the number  of columns of the matrix
   *           op( B ) and the number of columns of the matrix C. N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry,  K  specifies  the number of columns of the matrix
   *           op( A ) and the number of rows of the matrix op( B ). K must
   *           be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.
   *           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by m  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. When  TRANSA = 'N' or 'n' then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, kb ), where kb is
   *           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.
   *           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  n by k  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in the calling (sub) program. When  TRANSB = 'N' or 'n' then
   *           LDB must be at least  max( 1, k ), otherwise  LDB must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n  matrix
   *           ( alpha*op( A )*op( B ) + beta*C ).
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param transa
   * @param transb
   * @param m
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void sgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGEMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*op( A )*op( B ) + beta*C,
   *
   *  where  op( X ) is one of
   *
   *     op( X ) = X   or   op( X ) = X',
   *
   *  alpha and beta are scalars, and A, B and C are matrices, with op( A )
   *  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n',  op( A ) = A.
   *
   *              TRANSA = 'T' or 't',  op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c',  op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  TRANSB - CHARACTER*1.
   *           On entry, TRANSB specifies the form of op( B ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSB = 'N' or 'n',  op( B ) = B.
   *
   *              TRANSB = 'T' or 't',  op( B ) = B'.
   *
   *              TRANSB = 'C' or 'c',  op( B ) = B'.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies  the number  of rows  of the  matrix
   *           op( A )  and of the  matrix  C.  M  must  be at least  zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N  specifies the number  of columns of the matrix
   *           op( B ) and the number of columns of the matrix C. N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry,  K  specifies  the number of columns of the matrix
   *           op( A ) and the number of rows of the matrix op( B ). K must
   *           be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.
   *           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by m  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. When  TRANSA = 'N' or 'n' then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, kb ), where kb is
   *           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.
   *           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  n by k  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in the calling (sub) program. When  TRANSB = 'N' or 'n' then
   *           LDB must be at least  max( 1, k ), otherwise  LDB must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n  matrix
   *           ( alpha*op( A )*op( B ) + beta*C ).
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param transa
   * @param transb
   * @param m
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void sgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGEMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry with BETA non-zero, the incremented array Y
   *           must contain the vector y. On exit, Y is overwritten by the
   *           updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void sgemv(java.lang.String trans, int m, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGEMV  performs one of the matrix-vector operations
   *
   *     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are vectors and A is an
   *  m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
   *
   *              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
   *
   *              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
   *           and at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
   *           Before entry with BETA non-zero, the incremented array Y
   *           must contain the vector y. On exit, Y is overwritten by the
   *           updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void sgemv(java.lang.String trans, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGER   performs the rank 1 operation
   *
   *     A := alpha*x*y' + A,
   *
   *  where alpha is a scalar, x is an m element vector, y is an n element
   *  vector and A is an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the m
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients. On exit, A is
   *           overwritten by the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param a
   * @param lda
   * 
   */
  abstract public void sger(int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SGER   performs the rank 1 operation
   *
   *     A := alpha*x*y' + A,
   *
   *  where alpha is a scalar, x is an m element vector, y is an n element
   *  vector and A is an m by n matrix.
   *
   *  Arguments
   *  ==========
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of the matrix A.
   *           M must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( m - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the m
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry, the leading m by n part of the array A must
   *           contain the matrix of coefficients. On exit, A is
   *           overwritten by the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void sger(int m, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SNRM2 returns the euclidean norm of a vector via the function
   *  name, so that
   *
   *     SNRM2 := sqrt( x'*x ).
   *
   *  Further Details
   *  ===============
   *
   *  -- This version written on 25-October-1982.
   *     Modified on 14-October-1993 to inline the call to SLASSQ.
   *     Sven Hammarling, Nag Ltd.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param x
   * @param incx
   * @return
   */
  abstract public float snrm2(int n, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SNRM2 returns the euclidean norm of a vector via the function
   *  name, so that
   *
   *     SNRM2 := sqrt( x'*x ).
   *
   *  Further Details
   *  ===============
   *
   *  -- This version written on 25-October-1982.
   *     Modified on 14-October-1993 to inline the call to SLASSQ.
   *     Sven Hammarling, Nag Ltd.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param x
   * @param _x_offset
   * @param incx
   * @return
   */
  abstract public float snrm2(int n, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     applies a plane rotation.
   *
   *  Further Details
   *  ===============
   *
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * @param c
   * @param s
   * 
   */
  abstract public void srot(int n, float[] sx, int incx, float[] sy, int incy, float c, float s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     applies a plane rotation.
   *
   *  Further Details
   *  ===============
   *
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * @param c
   * @param s
   * 
   */
  abstract public void srot(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float c, float s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     construct givens plane rotation.
   *     jack dongarra, linpack, 3/11/78.
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param sa
   * @param sb
   * @param c
   * @param s
   * 
   */
  abstract public void srotg(org.netlib.util.floatW sa, org.netlib.util.floatW sb, org.netlib.util.floatW c, org.netlib.util.floatW s);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX
   *
   *     (SX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF SX ARE IN
   *     (DX**T)
   *
   *     SX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
   *     LX = (-INCX)*N, AND SIMILARLY FOR SY USING USING LY AND INCY.
   *     WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0
   *
   *       (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)
   *     H=(          )    (          )    (          )    (          )
   *       (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).
   *     SEE  SROTMG FOR A DESCRIPTION OF DATA STORAGE IN SPARAM.
   *
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  SX     (input/output) REAL array, dimension N
   *         double precision vector with 5 elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of SX
   *
   *  SY     (input/output) REAL array, dimension N
   *         double precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of SY
   *
   *  SPARAM (input/output)  REAL array, dimension 5
   *     SPARAM(1)=SFLAG
   *     SPARAM(2)=SH11
   *     SPARAM(3)=SH21
   *     SPARAM(4)=SH12
   *     SPARAM(5)=SH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * @param sparam
   * 
   */
  abstract public void srotm(int n, float[] sx, int incx, float[] sy, int incy, float[] sparam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX
   *
   *     (SX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF SX ARE IN
   *     (DX**T)
   *
   *     SX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
   *     LX = (-INCX)*N, AND SIMILARLY FOR SY USING USING LY AND INCY.
   *     WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0
   *
   *       (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)
   *     H=(          )    (          )    (          )    (          )
   *       (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).
   *     SEE  SROTMG FOR A DESCRIPTION OF DATA STORAGE IN SPARAM.
   *
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         number of elements in input vector(s)
   *
   *  SX     (input/output) REAL array, dimension N
   *         double precision vector with 5 elements
   *
   *  INCX   (input) INTEGER
   *         storage spacing between elements of SX
   *
   *  SY     (input/output) REAL array, dimension N
   *         double precision vector with N elements
   *
   *  INCY   (input) INTEGER
   *         storage spacing between elements of SY
   *
   *  SPARAM (input/output)  REAL array, dimension 5
   *     SPARAM(1)=SFLAG
   *     SPARAM(2)=SH11
   *     SPARAM(3)=SH21
   *     SPARAM(4)=SH12
   *     SPARAM(5)=SH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * @param sparam
   * @param _sparam_offset
   * 
   */
  abstract public void srotm(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float[] sparam, int _sparam_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS
   *     THE SECOND COMPONENT OF THE 2-VECTOR  (SQRT(SD1)*SX1,SQRT(SD2)*
   *     SY2)**T.
   *     WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0
   *
   *       (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)
   *     H=(          )    (          )    (          )    (          )
   *       (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).
   *     LOCATIONS 2-4 OF SPARAM CONTAIN SH11,SH21,SH12, AND SH22
   *     RESPECTIVELY. (VALUES OF 1.E0, -1.E0, OR 0.E0 IMPLIED BY THE
   *     VALUE OF SPARAM(1) ARE NOT STORED IN SPARAM.)
   *
   *     THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE
   *     INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE
   *     OF SD1 AND SD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM.
   *
   *
   *  Arguments
   *  =========
   *
   *
   *  SD1    (input/output) REAL
   *
   *  SD2    (input/output) REAL
   *
   *  SX1    (input/output) REAL
   *
   *  SY1    (input) REAL
   *
   *
   *  SPARAM (input/output)  REAL array, dimension 5
   *     SPARAM(1)=SFLAG
   *     SPARAM(2)=SH11
   *     SPARAM(3)=SH21
   *     SPARAM(4)=SH12
   *     SPARAM(5)=SH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param sd1
   * @param sd2
   * @param sx1
   * @param sy1
   * @param sparam
   * 
   */
  abstract public void srotmg(org.netlib.util.floatW sd1, org.netlib.util.floatW sd2, org.netlib.util.floatW sx1, float sy1, float[] sparam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS
   *     THE SECOND COMPONENT OF THE 2-VECTOR  (SQRT(SD1)*SX1,SQRT(SD2)*
   *     SY2)**T.
   *     WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..
   *
   *     SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0
   *
   *       (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)
   *     H=(          )    (          )    (          )    (          )
   *       (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).
   *     LOCATIONS 2-4 OF SPARAM CONTAIN SH11,SH21,SH12, AND SH22
   *     RESPECTIVELY. (VALUES OF 1.E0, -1.E0, OR 0.E0 IMPLIED BY THE
   *     VALUE OF SPARAM(1) ARE NOT STORED IN SPARAM.)
   *
   *     THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE
   *     INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE
   *     OF SD1 AND SD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM.
   *
   *
   *  Arguments
   *  =========
   *
   *
   *  SD1    (input/output) REAL
   *
   *  SD2    (input/output) REAL
   *
   *  SX1    (input/output) REAL
   *
   *  SY1    (input) REAL
   *
   *
   *  SPARAM (input/output)  REAL array, dimension 5
   *     SPARAM(1)=SFLAG
   *     SPARAM(2)=SH11
   *     SPARAM(3)=SH21
   *     SPARAM(4)=SH12
   *     SPARAM(5)=SH22
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param sd1
   * @param sd2
   * @param sx1
   * @param sy1
   * @param sparam
   * @param _sparam_offset
   * 
   */
  abstract public void srotmg(org.netlib.util.floatW sd1, org.netlib.util.floatW sd2, org.netlib.util.floatW sx1, float sy1, float[] sparam, int _sparam_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSBMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric band matrix, with k super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the band matrix A is being supplied as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  being supplied.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  being supplied.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry, K specifies the number of super-diagonals of the
   *           matrix A. K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer the upper
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer the lower
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void ssbmv(java.lang.String uplo, int n, int k, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSBMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric band matrix, with k super-diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the band matrix A is being supplied as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  being supplied.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  being supplied.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry, K specifies the number of super-diagonals of the
   *           matrix A. K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer the upper
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the symmetric matrix, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer the lower
   *           triangular part of a symmetric band matrix from conventional
   *           full matrix storage to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the
   *           vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of DIMENSION at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the
   *           vector y. On exit, Y is overwritten by the updated vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void ssbmv(java.lang.String uplo, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     scales a vector by a constant.
   *     uses unrolled loops for increment equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sa
   * @param sx
   * @param incx
   * 
   */
  abstract public void sscal(int n, float sa, float[] sx, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     scales a vector by a constant.
   *     uses unrolled loops for increment equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 3/93 to return if incx .le. 0.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sa
   * @param sx
   * @param _sx_offset
   * @param incx
   * 
   */
  abstract public void sscal(int n, float sa, float[] sx, int _sx_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPMV  performs the matrix-vector operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param ap
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void sspmv(java.lang.String uplo, int n, float alpha, float[] ap, float[] x, int incx, float beta, float[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPMV  performs the matrix-vector operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void sspmv(java.lang.String uplo, int n, float alpha, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPR    performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param ap
   * 
   */
  abstract public void sspr(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] ap);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPR    performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param ap
   * @param _ap_offset
   * 
   */
  abstract public void sspr(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] ap, int _ap_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param ap
   * 
   */
  abstract public void sspr2(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] ap);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSPR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an
   *  n by n symmetric matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the matrix A is supplied in the packed
   *           array AP as follows:
   *
   *              UPLO = 'U' or 'u'   The upper triangular part of A is
   *                                  supplied in AP.
   *
   *              UPLO = 'L' or 'l'   The lower triangular part of A is
   *                                  supplied in AP.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )
   *           and a( 2, 2 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the upper triangular part of the
   *           updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular part of the symmetric matrix
   *           packed sequentially, column by column, so that AP( 1 )
   *           contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )
   *           and a( 3, 1 ) respectively, and so on. On exit, the array
   *           AP is overwritten by the lower triangular part of the
   *           updated matrix.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param ap
   * @param _ap_offset
   * 
   */
  abstract public void sspr2(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] ap, int _ap_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     interchanges two vectors.
   *     uses unrolled loops for increments equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * 
   */
  abstract public void sswap(int n, float[] sx, int incx, float[] sy, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *     interchanges two vectors.
   *     uses unrolled loops for increments equal to 1.
   *     jack dongarra, linpack, 3/11/78.
   *     modified 12/3/93, array(1) declarations changed to array(*)
   *
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * 
   */
  abstract public void sswap(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*A*B + beta*C,
   *
   *  or
   *
   *     C := alpha*B*A + beta*C,
   *
   *  where alpha and beta are scalars,  A is a symmetric matrix and  B and
   *  C are  m by n matrices.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE  specifies whether  the  symmetric matrix  A
   *           appears on the  left or right  in the  operation as follows:
   *
   *              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,
   *
   *              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of  the  symmetric  matrix   A  is  to  be
   *           referenced as follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies the number of rows of the matrix  C.
   *           M  must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix C.
   *           N  must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           m  when  SIDE = 'L' or 'l'  and is  n otherwise.
   *           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading m by m upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  m by m  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading n by n upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  n by n  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry, the leading  m by n part of the array  B  must
   *           contain the matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n updated
   *           matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void ssymm(java.lang.String side, java.lang.String uplo, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYMM  performs one of the matrix-matrix operations
   *
   *     C := alpha*A*B + beta*C,
   *
   *  or
   *
   *     C := alpha*B*A + beta*C,
   *
   *  where alpha and beta are scalars,  A is a symmetric matrix and  B and
   *  C are  m by n matrices.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE  specifies whether  the  symmetric matrix  A
   *           appears on the  left or right  in the  operation as follows:
   *
   *              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,
   *
   *              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of  the  symmetric  matrix   A  is  to  be
   *           referenced as follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of the
   *                                  symmetric matrix is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry,  M  specifies the number of rows of the matrix  C.
   *           M  must be at least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of the matrix C.
   *           N  must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           m  when  SIDE = 'L' or 'l'  and is  n otherwise.
   *           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading m by m upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  m by m  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of
   *           the array  A  must contain the  symmetric matrix,  such that
   *           when  UPLO = 'U' or 'u', the leading n by n upper triangular
   *           part of the array  A  must contain the upper triangular part
   *           of the  symmetric matrix and the  strictly  lower triangular
   *           part of  A  is not referenced,  and when  UPLO = 'L' or 'l',
   *           the leading  n by n  lower triangular part  of the  array  A
   *           must  contain  the  lower triangular part  of the  symmetric
   *           matrix and the  strictly upper triangular part of  A  is not
   *           referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA must be at least  max( 1, m ), otherwise  LDA must be at
   *           least  max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry, the leading  m by n part of the array  B  must
   *           contain the matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *           supplied as zero then C need not be set on input.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry, the leading  m by n  part of the array  C must
   *           contain the matrix  C,  except when  beta  is zero, in which
   *           case C need not be set on entry.
   *           On exit, the array  C  is overwritten by the  m by n updated
   *           matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void ssymm(java.lang.String side, java.lang.String uplo, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param x
   * @param incx
   * @param beta
   * @param y
   * @param incy
   * 
   */
  abstract public void ssymv(java.lang.String uplo, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYMV  performs the matrix-vector  operation
   *
   *     y := alpha*A*x + beta*y,
   *
   *  where alpha and beta are scalars, x and y are n element vectors and
   *  A is an n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta. When BETA is
   *           supplied as zero then Y need not be set on input.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y. On exit, Y is overwritten by the updated
   *           vector y.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * @param beta
   * @param y
   * @param _y_offset
   * @param incy
   * 
   */
  abstract public void ssymv(java.lang.String uplo, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR   performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param a
   * @param lda
   * 
   */
  abstract public void ssyr(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR   performs the symmetric rank 1 operation
   *
   *     A := alpha*x*x' + A,
   *
   *  where alpha is a real scalar, x is an n element vector and A is an
   *  n by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void ssyr(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an n
   *  by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param incx
   * @param y
   * @param incy
   * @param a
   * @param lda
   * 
   */
  abstract public void ssyr2(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR2  performs the symmetric rank 2 operation
   *
   *     A := alpha*x*y' + alpha*y*x' + A,
   *
   *  where alpha is a scalar, x and y are n element vectors and A is an n
   *  by n symmetric matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the upper or lower
   *           triangular part of the array A is to be referenced as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the upper triangular part of A
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the lower triangular part of A
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x.
   *           Unchanged on exit.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *  Y      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCY ) ).
   *           Before entry, the incremented array Y must contain the n
   *           element vector y.
   *           Unchanged on exit.
   *
   *  INCY   - INTEGER.
   *           On entry, INCY specifies the increment for the elements of
   *           Y. INCY must not be zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular part of the symmetric matrix and the strictly
   *           lower triangular part of A is not referenced. On exit, the
   *           upper triangular part of the array A is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular part of the symmetric matrix and the strictly
   *           upper triangular part of A is not referenced. On exit, the
   *           lower triangular part of the array A is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param alpha
   * @param x
   * @param _x_offset
   * @param incx
   * @param y
   * @param _y_offset
   * @param incy
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void ssyr2(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR2K  performs one of the symmetric rank 2k operations
   *
   *     C := alpha*A*B' + alpha*B*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*B + alpha*B'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A and B  are  n by k  matrices  in the  first  case  and  k by n
   *  matrices in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*B' + alpha*B*A' +
   *                                        beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns  of the  matrices  A and B,  and on  entry  with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrices  A and B.  K must be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, kb ), where kb is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  k by n  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDB must be at least  max( 1, n ), otherwise  LDB must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void ssyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYR2K  performs one of the symmetric rank 2k operations
   *
   *     C := alpha*A*B' + alpha*B*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*B + alpha*B'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A and B  are  n by k  matrices  in the  first  case  and  k by n
   *  matrices in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*B' + alpha*B*A' +
   *                                        beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*B + alpha*B'*A +
   *                                        beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns  of the  matrices  A and B,  and on  entry  with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrices  A and B.  K must be at least  zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, kb ), where kb is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  B  must contain the matrix  B,  otherwise
   *           the leading  k by n  part of the array  B  must contain  the
   *           matrix B.
   *           Unchanged on exit.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDB must be at least  max( 1, n ), otherwise  LDB must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void ssyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYRK  performs one of the symmetric rank k operations
   *
   *     C := alpha*A*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A  is an  n by k  matrix in the first case and a  k by n  matrix
   *  in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*A + beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns   of  the   matrix   A,   and  on   entry   with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrix  A.  K must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param lda
   * @param beta
   * @param c
   * @param Ldc
   * 
   */
  abstract public void ssyrk(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int lda, float beta, float[] c, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  SSYRK  performs one of the symmetric rank k operations
   *
   *     C := alpha*A*A' + beta*C,
   *
   *  or
   *
   *     C := alpha*A'*A + beta*C,
   *
   *  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix
   *  and  A  is an  n by k  matrix in the first case and a  k by n  matrix
   *  in the second case.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On  entry,   UPLO  specifies  whether  the  upper  or  lower
   *           triangular  part  of the  array  C  is to be  referenced  as
   *           follows:
   *
   *              UPLO = 'U' or 'u'   Only the  upper triangular part of  C
   *                                  is to be referenced.
   *
   *              UPLO = 'L' or 'l'   Only the  lower triangular part of  C
   *                                  is to be referenced.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry,  TRANS  specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C.
   *
   *              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C.
   *
   *              TRANS = 'C' or 'c'   C := alpha*A'*A + beta*C.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry,  N specifies the order of the matrix C.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with  TRANS = 'N' or 'n',  K  specifies  the number
   *           of  columns   of  the   matrix   A,   and  on   entry   with
   *           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number
   *           of rows of the matrix  A.  K must be at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry, ALPHA specifies the scalar alpha.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, ka ), where ka is
   *           k  when  TRANS = 'N' or 'n',  and is  n  otherwise.
   *           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k
   *           part of the array  A  must contain the matrix  A,  otherwise
   *           the leading  k by n  part of the array  A  must contain  the
   *           matrix A.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'
   *           then  LDA must be at least  max( 1, n ), otherwise  LDA must
   *           be at least  max( 1, k ).
   *           Unchanged on exit.
   *
   *  BETA   - REAL            .
   *           On entry, BETA specifies the scalar beta.
   *           Unchanged on exit.
   *
   *  C      - REAL             array of DIMENSION ( LDC, n ).
   *           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n
   *           upper triangular part of the array C must contain the upper
   *           triangular part  of the  symmetric matrix  and the strictly
   *           lower triangular part of C is not referenced.  On exit, the
   *           upper triangular part of the array  C is overwritten by the
   *           upper triangular part of the updated matrix.
   *           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n
   *           lower triangular part of the array C must contain the lower
   *           triangular part  of the  symmetric matrix  and the strictly
   *           upper triangular part of C is not referenced.  On exit, the
   *           lower triangular part of the array  C is overwritten by the
   *           lower triangular part of the updated matrix.
   *
   *  LDC    - INTEGER.
   *           On entry, LDC specifies the first dimension of C as declared
   *           in  the  calling  (sub)  program.   LDC  must  be  at  least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param n
   * @param k
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param beta
   * @param c
   * @param _c_offset
   * @param Ldc
   * 
   */
  abstract public void ssyrk(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float beta, float[] c, int _c_offset, int Ldc);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STBMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular band matrix, with ( k + 1 ) diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void stbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int lda, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STBMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular band matrix, with ( k + 1 ) diagonals.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void stbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STBSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular band matrix, with ( k + 1 )
   *  diagonals.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void stbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int lda, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STBSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular band matrix, with ( k + 1 )
   *  diagonals.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  K      - INTEGER.
   *           On entry with UPLO = 'U' or 'u', K specifies the number of
   *           super-diagonals of the matrix A.
   *           On entry with UPLO = 'L' or 'l', K specifies the number of
   *           sub-diagonals of the matrix A.
   *           K must satisfy  0 .le. K.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )
   *           by n part of the array A must contain the upper triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row
   *           ( k + 1 ) of the array, the first super-diagonal starting at
   *           position 2 in row k, and so on. The top left k by k triangle
   *           of the array A is not referenced.
   *           The following program segment will transfer an upper
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = K + 1 - J
   *                    DO 10, I = MAX( 1, J - K ), J
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )
   *           by n part of the array A must contain the lower triangular
   *           band part of the matrix of coefficients, supplied column by
   *           column, with the leading diagonal of the matrix in row 1 of
   *           the array, the first sub-diagonal starting at position 1 in
   *           row 2, and so on. The bottom right k by k triangle of the
   *           array A is not referenced.
   *           The following program segment will transfer a lower
   *           triangular band matrix from conventional full matrix storage
   *           to band storage:
   *
   *                 DO 20, J = 1, N
   *                    M = 1 - J
   *                    DO 10, I = J, MIN( N, J + K )
   *                       A( M + I, J ) = matrix( I, J )
   *              10    CONTINUE
   *              20 CONTINUE
   *
   *           Note that when DIAG = 'U' or 'u' the elements of the array A
   *           corresponding to the diagonal elements of the matrix are not
   *           referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           ( k + 1 ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param k
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void stbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STPMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param x
   * @param incx
   * 
   */
  abstract public void stpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STPMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix, supplied in packed form.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void stpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STPSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix, supplied in packed form.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param x
   * @param incx
   * 
   */
  abstract public void stpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STPSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix, supplied in packed form.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  AP     - REAL             array of DIMENSION at least
   *           ( ( n*( n + 1 ) )/2 ).
   *           Before entry with  UPLO = 'U' or 'u', the array AP must
   *           contain the upper triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )
   *           respectively, and so on.
   *           Before entry with UPLO = 'L' or 'l', the array AP must
   *           contain the lower triangular matrix packed sequentially,
   *           column by column, so that AP( 1 ) contains a( 1, 1 ),
   *           AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )
   *           respectively, and so on.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param ap
   * @param _ap_offset
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void stpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRMM  performs one of the matrix-matrix operations
   *
   *     B := alpha*op( A )*B,   or   B := alpha*B*op( A ),
   *
   *  where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE specifies whether  op( A ) multiplies B from
   *           the left or right as follows:
   *
   *              SIDE = 'L' or 'l'   B := alpha*op( A )*B.
   *
   *              SIDE = 'R' or 'r'   B := alpha*B*op( A ).
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain the matrix  B,  and  on exit  is overwritten  by the
   *           transformed matrix.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * 
   */
  abstract public void strmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRMM  performs one of the matrix-matrix operations
   *
   *     B := alpha*op( A )*B,   or   B := alpha*B*op( A ),
   *
   *  where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry,  SIDE specifies whether  op( A ) multiplies B from
   *           the left or right as follows:
   *
   *              SIDE = 'L' or 'l'   B := alpha*op( A )*B.
   *
   *              SIDE = 'R' or 'r'   B := alpha*B*op( A ).
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain the matrix  B,  and  on exit  is overwritten  by the
   *           transformed matrix.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void strmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void strmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int lda, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRMV  performs one of the matrix-vector operations
   *
   *     x := A*x,   or   x := A'*x,
   *
   *  where x is an n element vector and  A is an n by n unit, or non-unit,
   *  upper or lower triangular matrix.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the operation to be performed as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   x := A*x.
   *
   *              TRANS = 'T' or 't'   x := A'*x.
   *
   *              TRANS = 'C' or 'c'   x := A'*x.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element vector x. On exit, X is overwritten with the
   *           tranformed vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void strmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRSM  solves one of the matrix equations
   *
   *     op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,
   *
   *  where alpha is a scalar, X and B are m by n matrices, A is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  The matrix X is overwritten on B.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry, SIDE specifies whether op( A ) appears on the left
   *           or right of X as follows:
   *
   *              SIDE = 'L' or 'l'   op( A )*X = alpha*B.
   *
   *              SIDE = 'R' or 'r'   X*op( A ) = alpha*B.
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain  the  right-hand  side  matrix  B,  and  on exit  is
   *           overwritten by the solution matrix  X.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * 
   */
  abstract public void strsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRSM  solves one of the matrix equations
   *
   *     op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,
   *
   *  where alpha is a scalar, X and B are m by n matrices, A is a unit, or
   *  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of
   *
   *     op( A ) = A   or   op( A ) = A'.
   *
   *  The matrix X is overwritten on B.
   *
   *  Arguments
   *  ==========
   *
   *  SIDE   - CHARACTER*1.
   *           On entry, SIDE specifies whether op( A ) appears on the left
   *           or right of X as follows:
   *
   *              SIDE = 'L' or 'l'   op( A )*X = alpha*B.
   *
   *              SIDE = 'R' or 'r'   X*op( A ) = alpha*B.
   *
   *           Unchanged on exit.
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix A is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANSA - CHARACTER*1.
   *           On entry, TRANSA specifies the form of op( A ) to be used in
   *           the matrix multiplication as follows:
   *
   *              TRANSA = 'N' or 'n'   op( A ) = A.
   *
   *              TRANSA = 'T' or 't'   op( A ) = A'.
   *
   *              TRANSA = 'C' or 'c'   op( A ) = A'.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit triangular
   *           as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  M      - INTEGER.
   *           On entry, M specifies the number of rows of B. M must be at
   *           least zero.
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the number of columns of B.  N must be
   *           at least zero.
   *           Unchanged on exit.
   *
   *  ALPHA  - REAL            .
   *           On entry,  ALPHA specifies the scalar  alpha. When  alpha is
   *           zero then  A is not referenced and  B need not be set before
   *           entry.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, k ), where k is m
   *           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.
   *           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k
   *           upper triangular part of the array  A must contain the upper
   *           triangular matrix  and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k
   *           lower triangular part of the array  A must contain the lower
   *           triangular matrix  and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u',  the diagonal elements of
   *           A  are not referenced either,  but are assumed to be  unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then
   *           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'
   *           then LDA must be at least max( 1, n ).
   *           Unchanged on exit.
   *
   *  B      - REAL             array of DIMENSION ( LDB, n ).
   *           Before entry,  the leading  m by n part of the array  B must
   *           contain  the  right-hand  side  matrix  B,  and  on exit  is
   *           overwritten by the solution matrix  X.
   *
   *  LDB    - INTEGER.
   *           On entry, LDB specifies the first dimension of B as declared
   *           in  the  calling  (sub)  program.   LDB  must  be  at  least
   *           max( 1, m ).
   *           Unchanged on exit.
   *
   *
   *  Level 3 Blas routine.
   *
   *
   *  -- Written on 8-February-1989.
   *     Jack Dongarra, Argonne National Laboratory.
   *     Iain Duff, AERE Harwell.
   *     Jeremy Du Croz, Numerical Algorithms Group Ltd.
   *     Sven Hammarling, Numerical Algorithms Group Ltd.
   *
   *
   *     .. External Functions ..
   * </code></pre>
   *
   * @param side
   * @param uplo
   * @param transa
   * @param diag
   * @param m
   * @param n
   * @param alpha
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void strsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param lda
   * @param x
   * @param incx
   * 
   */
  abstract public void strsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int lda, float[] x, int incx);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  STRSV  solves one of the systems of equations
   *
   *     A*x = b,   or   A'*x = b,
   *
   *  where b and x are n element vectors and A is an n by n unit, or
   *  non-unit, upper or lower triangular matrix.
   *
   *  No test for singularity or near-singularity is included in this
   *  routine. Such tests must be performed before calling this routine.
   *
   *  Arguments
   *  ==========
   *
   *  UPLO   - CHARACTER*1.
   *           On entry, UPLO specifies whether the matrix is an upper or
   *           lower triangular matrix as follows:
   *
   *              UPLO = 'U' or 'u'   A is an upper triangular matrix.
   *
   *              UPLO = 'L' or 'l'   A is a lower triangular matrix.
   *
   *           Unchanged on exit.
   *
   *  TRANS  - CHARACTER*1.
   *           On entry, TRANS specifies the equations to be solved as
   *           follows:
   *
   *              TRANS = 'N' or 'n'   A*x = b.
   *
   *              TRANS = 'T' or 't'   A'*x = b.
   *
   *              TRANS = 'C' or 'c'   A'*x = b.
   *
   *           Unchanged on exit.
   *
   *  DIAG   - CHARACTER*1.
   *           On entry, DIAG specifies whether or not A is unit
   *           triangular as follows:
   *
   *              DIAG = 'U' or 'u'   A is assumed to be unit triangular.
   *
   *              DIAG = 'N' or 'n'   A is not assumed to be unit
   *                                  triangular.
   *
   *           Unchanged on exit.
   *
   *  N      - INTEGER.
   *           On entry, N specifies the order of the matrix A.
   *           N must be at least zero.
   *           Unchanged on exit.
   *
   *  A      - REAL             array of DIMENSION ( LDA, n ).
   *           Before entry with  UPLO = 'U' or 'u', the leading n by n
   *           upper triangular part of the array A must contain the upper
   *           triangular matrix and the strictly lower triangular part of
   *           A is not referenced.
   *           Before entry with UPLO = 'L' or 'l', the leading n by n
   *           lower triangular part of the array A must contain the lower
   *           triangular matrix and the strictly upper triangular part of
   *           A is not referenced.
   *           Note that when  DIAG = 'U' or 'u', the diagonal elements of
   *           A are not referenced either, but are assumed to be unity.
   *           Unchanged on exit.
   *
   *  LDA    - INTEGER.
   *           On entry, LDA specifies the first dimension of A as declared
   *           in the calling (sub) program. LDA must be at least
   *           max( 1, n ).
   *           Unchanged on exit.
   *
   *  X      - REAL             array of dimension at least
   *           ( 1 + ( n - 1 )*abs( INCX ) ).
   *           Before entry, the incremented array X must contain the n
   *           element right-hand side vector b. On exit, X is overwritten
   *           with the solution vector x.
   *
   *  INCX   - INTEGER.
   *           On entry, INCX specifies the increment for the elements of
   *           X. INCX must not be zero.
   *           Unchanged on exit.
   *
   *
   *  Level 2 Blas routine.
   *
   *  -- Written on 22-October-1986.
   *     Jack Dongarra, Argonne National Lab.
   *     Jeremy Du Croz, Nag Central Office.
   *     Sven Hammarling, Nag Central Office.
   *     Richard Hanson, Sandia National Labs.
   *
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param trans
   * @param diag
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param x
   * @param _x_offset
   * @param incx
   * 
   */
  abstract public void strsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);
}