/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Arrays;
import java.util.List;

@RedisCommand(value="linsert")
public class LInsert
extends AbstractRedisOperation {
    private static final String BEFORE = "BEFORE";
    private static final String AFTER = "AFTER";

    public LInsert(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        String direction = this.params().get(1).toString();
        if (!Arrays.asList(BEFORE, AFTER).contains(direction.toUpperCase())) {
            throw new IllegalArgumentException("ERR syntax error");
        }
        Slice pivot = this.params().get(2);
        Slice element = this.params().get(3);
        if (!this.base().exists(key)) {
            return Response.integer(0L);
        }
        List<Slice> storedElements = this.base().getList(key).getStoredData();
        int i = storedElements.indexOf(pivot);
        if (i == -1) {
            return Response.integer(-1L);
        }
        int index = direction.equalsIgnoreCase(BEFORE) ? i : i + 1;
        storedElements.add(index, element);
        return Response.integer(storedElements.size());
    }
}

