/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.List;

@RedisCommand(value="rename")
class Rename
extends AbstractRedisOperation {
    private final Object lock;

    Rename(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    private boolean rename(Slice key, Slice newKey) {
        RMDataStructure value = this.base().getValue(key);
        Long ttl = this.base().getTTL(key);
        if (ttl == null || value == null) {
            return false;
        }
        this.base().deleteValue(newKey);
        this.base().putValue(newKey, value, ttl);
        this.base().deleteValue(key);
        this.lock.notifyAll();
        return true;
    }

    @Override
    protected Slice response() {
        Slice newKey;
        Slice key = this.params().get(0);
        if (!this.rename(key, newKey = this.params().get(1))) {
            return Response.error("ERR no such key");
        }
        return Response.OK;
    }
}

