/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j.core;

import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import com.github.fracpete.rsync4j.core.AbstractBinary;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;

public abstract class AbstractBinaryWithTimeout
extends AbstractBinary {
    protected int max_time;

    @Override
    public void reset() {
        super.reset();
        this.max_time = -1;
    }

    public int getMaxTime() {
        return this.max_time;
    }

    public AbstractBinaryWithTimeout maxTime(int max_time) {
        if (max_time < 1) {
            max_time = -1;
        }
        this.max_time = max_time;
        return this;
    }

    @Override
    public CollectingProcessOutput execute() throws Exception {
        CollectingProcessOutput result = new CollectingProcessOutput();
        result.setTimeOut(this.max_time);
        result.monitor(this.builder());
        return result;
    }

    @Override
    protected ArgumentParser getParser() {
        ArgumentParser parser = super.getParser();
        parser.addArgument(new String[]{"--maxtime"}).setDefault((Object)-1).dest("maxtime").help("set the maximum time for the process to run in seconds before getting killed");
        return parser;
    }

    @Override
    protected boolean setOptions(Namespace ns) {
        boolean result = super.setOptions(ns);
        if (!result) {
            return false;
        }
        this.maxTime(ns.getInt("maxtime"));
        return true;
    }
}

