/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import smile.association.AssociationRule;
import smile.association.FPGrowth;
import smile.association.TotalSupportTree;

public class ARM {
    private FPGrowth fim;
    private TotalSupportTree ttree;

    public ARM(int[] frequency, int minSupport) {
        this.fim = new FPGrowth(frequency, minSupport);
    }

    public ARM(int[][] itemsets, double minSupport) {
        this.fim = new FPGrowth(itemsets, minSupport);
    }

    public ARM(int[][] itemsets, int minSupport) {
        this.fim = new FPGrowth(itemsets, minSupport);
    }

    public void add(int[] itemset) {
        this.fim.add(itemset);
    }

    public long learn(double confidence, PrintStream out) {
        long n = 0L;
        this.ttree = this.fim.buildTotalSupportTree();
        for (int i = 0; i < this.ttree.root.children.length; ++i) {
            if (this.ttree.root.children[i] == null) continue;
            int[] itemset = new int[]{this.ttree.root.children[i].id};
            n += this.learn(out, null, itemset, i, this.ttree.root.children[i], confidence);
        }
        return n;
    }

    public List<AssociationRule> learn(double confidence) {
        ArrayList<AssociationRule> list = new ArrayList<AssociationRule>();
        this.ttree = this.fim.buildTotalSupportTree();
        for (int i = 0; i < this.ttree.root.children.length; ++i) {
            if (this.ttree.root.children[i] == null) continue;
            int[] itemset = new int[]{this.ttree.root.children[i].id};
            this.learn(null, list, itemset, i, this.ttree.root.children[i], confidence);
        }
        return list;
    }

    private long learn(PrintStream out, List<AssociationRule> list, int[] itemset, int size, TotalSupportTree.Node node, double confidence) {
        long n = 0L;
        if (node.children == null) {
            return n;
        }
        for (int i = 0; i < size; ++i) {
            if (node.children[i] == null) continue;
            int[] newItemset = FPGrowth.insert(itemset, node.children[i].id);
            n += this.learn(out, list, newItemset, node.children[i].support, confidence);
            n += this.learn(out, list, newItemset, i, node.children[i], confidence);
        }
        return n;
    }

    private long learn(PrintStream out, List<AssociationRule> list, int[] itemset, int support, double confidence) {
        long n = 0L;
        int[][] combinations = ARM.getPowerSet(itemset);
        for (int i = 0; i < combinations.length; ++i) {
            double arc;
            int[] complement = ARM.getComplement(combinations[i], itemset);
            if (complement == null || !((arc = this.getConfidence(combinations[i], support)) >= confidence)) continue;
            double supp = (double)support / (double)this.fim.size();
            AssociationRule ar = new AssociationRule(combinations[i], complement, supp, arc);
            ++n;
            if (out != null) {
                out.println(ar);
            }
            if (list == null) continue;
            list.add(ar);
        }
        return n;
    }

    private double getConfidence(int[] antecedent, double support) {
        return support / (double)this.ttree.getSupport(antecedent);
    }

    private static int[] getComplement(int[] subset, int[] fullset) {
        int size = fullset.length - subset.length;
        if (size < 1) {
            return null;
        }
        int[] complement = new int[size];
        int index = 0;
        for (int i = 0; i < fullset.length; ++i) {
            int item = fullset[i];
            boolean member = false;
            for (int j = 0; j < subset.length; ++j) {
                if (item != subset[j]) continue;
                member = true;
                break;
            }
            if (member) continue;
            complement[index++] = item;
        }
        return complement;
    }

    private static int[][] getPowerSet(int[] set) {
        int[][] sets = new int[ARM.getPowerSetSize(set.length)][];
        ARM.getPowerSet(set, 0, null, sets, 0);
        return sets;
    }

    private static int getPowerSet(int[] set, int inputIndex, int[] sofar, int[][] sets, int outputIndex) {
        for (int i = inputIndex; i < set.length; ++i) {
            int n;
            int n2 = n = sofar == null ? 0 : sofar.length;
            if (n >= set.length - 1) continue;
            int[] subset = new int[n + 1];
            subset[n] = set[i];
            if (sofar != null) {
                System.arraycopy(sofar, 0, subset, 0, n);
            }
            sets[outputIndex] = subset;
            outputIndex = ARM.getPowerSet(set, i + 1, subset, sets, outputIndex + 1);
        }
        return outputIndex;
    }

    private static int getPowerSetSize(int n) {
        return (int)Math.pow(2.0, n) - 2;
    }
}

