/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.HashMap;
import java.util.Map;

public class Bag<T> {
    private Map<T, Integer> features;
    private boolean binary;

    public Bag(T[] features) {
        this(features, false);
    }

    public Bag(T[] features, boolean binary) {
        this.binary = binary;
        this.features = new HashMap<T, Integer>();
        int k = 0;
        for (int i = 0; i < features.length; ++i) {
            if (this.features.containsKey(features[i])) continue;
            this.features.put(features[i], k++);
        }
    }

    public double[] feature(T[] x) {
        double[] bag = new double[this.features.size()];
        if (this.binary) {
            for (T word : x) {
                Integer f = this.features.get(word);
                if (f == null) continue;
                bag[f.intValue()] = 1.0;
            }
        } else {
            for (T word : x) {
                Integer f = this.features.get(word);
                if (f == null) continue;
                int n = f;
                bag[n] = bag[n] + 1.0;
            }
        }
        return bag;
    }
}

