/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SparseDataset;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.Lanczos;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;

public class LaplacianEigenmap {
    private static final Logger logger = LoggerFactory.getLogger(LaplacianEigenmap.class);
    private double t;
    private int[] index;
    private double[][] coordinates;
    private Graph graph;

    public LaplacianEigenmap(double[][] data, int d, int k) {
        this(data, d, k, -1.0);
    }

    public LaplacianEigenmap(double[][] data, int d, int k, double t) {
        Collection edges;
        int i;
        this.t = t;
        int n = data.length;
        NearestNeighborSearch knn = null;
        knn = data[0].length < 10 ? new KDTree(data, (E[])data) : new CoverTree((E[])data, new EuclideanDistance());
        this.graph = new AdjacencyList(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Neighbor<double[], V>[] neighbors = knn.knn(data[i2], k);
            for (int j = 0; j < k; ++j) {
                this.graph.setWeight(i2, neighbors[j].index, neighbors[j].distance);
            }
        }
        int[][] cc = this.graph.bfs();
        if (cc.length == 1) {
            this.index = new int[n];
            for (int i3 = 0; i3 < n; ++i3) {
                this.index[i3] = i3;
            }
        } else {
            n = 0;
            int component = 0;
            for (int i4 = 0; i4 < cc.length; ++i4) {
                if (cc[i4].length <= n) continue;
                component = i4;
                n = cc[i4].length;
            }
            logger.info("Laplacian Eigenmap: {} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            this.index = cc[component];
            this.graph = this.graph.subgraph(this.index);
        }
        SparseDataset W = new SparseDataset(n);
        double[] D = new double[n];
        if (t <= 0.0) {
            for (i = 0; i < n; ++i) {
                W.set(i, i, 1.0);
                edges = this.graph.getEdges(i);
                for (Graph.Edge edge : edges) {
                    int j = edge.v2;
                    if (i == j) {
                        j = edge.v1;
                    }
                    W.set(i, j, 1.0);
                    int n2 = i;
                    D[n2] = D[n2] + 1.0;
                }
                D[i] = 1.0 / Math.sqrt((double)D[i]);
            }
        } else {
            double gamma = -1.0 / t;
            for (int i5 = 0; i5 < n; ++i5) {
                W.set(i5, i5, 1.0);
                Collection edges2 = this.graph.getEdges(i5);
                for (Graph.Edge edge : edges2) {
                    int j = edge.v2;
                    if (i5 == j) {
                        j = edge.v1;
                    }
                    double w = Math.exp((double)(gamma * Math.sqr((double)edge.weight)));
                    W.set(i5, j, w);
                    int n3 = i5;
                    D[n3] = D[n3] + w;
                }
                D[i5] = 1.0 / Math.sqrt((double)D[i5]);
            }
        }
        for (i = 0; i < n; ++i) {
            edges = (SparseArray)W.get((int)i).x;
            for (Graph.Edge edge : edges) {
                int j = edge.i;
                double s = D[i] * edge.x * D[j];
                W.set(i, j, s);
            }
            W.set(i, i, -1.0);
        }
        double[] v = new double[n];
        for (int i6 = 0; i6 < n; ++i6) {
            v[i6] = Math.random();
        }
        SparseMatrix L = W.toSparseMatrix();
        double lambda = -Math.eigen((Matrix)L, (double[])v, (double)1.0E-6);
        for (int i7 = 0; i7 < n; ++i7) {
            W.set(i7, i7, lambda - 1.0);
        }
        L = W.toSparseMatrix();
        EigenValueDecomposition eigen = Lanczos.eigen((Matrix)L, (int)(d + 1));
        this.coordinates = new double[n][d];
        for (int j = 0; j < d; ++j) {
            int i8;
            double norm = 0.0;
            for (i8 = 0; i8 < n; ++i8) {
                this.coordinates[i8][j] = eigen.getEigenVectors().get(i8, j + 1) * D[i8];
                norm += this.coordinates[i8][j] * this.coordinates[i8][j];
            }
            norm = Math.sqrt((double)norm);
            for (i8 = 0; i8 < n; ++i8) {
                double[] dArray = this.coordinates[i8];
                int n4 = j;
                dArray[n4] = dArray[n4] / norm;
            }
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public Graph getNearestNeighborGraph() {
        return this.graph;
    }

    public double getHeatKernelWidth() {
        return this.t;
    }
}

