/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EigenValueDecomposition;

public class MDS {
    private double[] eigenvalues;
    private double[][] coordinates;
    private double[] proportion;

    public double[] getEigenValues() {
        return this.eigenvalues;
    }

    public double[] getProportion() {
        return this.proportion;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public MDS(double[][] proximity) {
        this(proximity, 2);
    }

    public MDS(double[][] proximity, int k) {
        this(proximity, k, false);
    }

    public MDS(double[][] proximity, int k, boolean add) {
        int i;
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (k < 1 || k >= n) {
            throw new IllegalArgumentException("Invalid k = " + k);
        }
        double[][] A = new double[n][n];
        double[][] B = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < i2; ++j) {
                A[i2][j] = -0.5 * Math.sqr((double)proximity[i2][j]);
                A[j][i2] = A[i2][j];
            }
        }
        double[] mean = Math.rowMean((double[][])A);
        double mu = Math.mean((double[])mean);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j <= i3; ++j) {
                B[i3][j] = A[i3][j] - mean[i3] - mean[j] + mu;
                B[j][i3] = B[i3][j];
            }
        }
        if (add) {
            int j;
            int i4;
            ColumnMajorMatrix Z = new ColumnMajorMatrix(2 * n, 2 * n);
            for (i4 = 0; i4 < n; ++i4) {
                for (j = 0; j < n; ++j) {
                    Z.set(i4, n + j, 2.0 * B[i4][j]);
                }
            }
            for (i4 = 0; i4 < n; ++i4) {
                Z.set(n + i4, i4, -1.0);
            }
            mean = Math.rowMean((double[][])proximity);
            mu = Math.mean((double[])mean);
            for (i4 = 0; i4 < n; ++i4) {
                for (j = 0; j < n; ++j) {
                    Z.set(n + i4, n + j, 2.0 * (proximity[i4][j] - mean[i4] - mean[j] + mu));
                }
            }
            EigenValueDecomposition eigen = new EigenValueDecomposition((DenseMatrix)Z, false, true);
            double c = Math.max((double[])eigen.getEigenValues());
            for (i = 0; i < n; ++i) {
                B[i][i] = 0.0;
                for (int j2 = 0; j2 < i; ++j2) {
                    B[i][j2] = -0.5 * Math.sqr((double)(proximity[i][j2] + c));
                    B[j2][i] = B[i][j2];
                }
            }
        }
        EigenValueDecomposition eigen = Math.eigen((double[][])B, (int)k);
        this.coordinates = new double[n][k];
        for (int j = 0; j < k; ++j) {
            if (eigen.getEigenValues()[j] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", k));
            }
            double scale = Math.sqrt((double)eigen.getEigenValues()[j]);
            for (i = 0; i < n; ++i) {
                this.coordinates[i][j] = eigen.getEigenVectors().get(i, j) * scale;
            }
        }
        this.eigenvalues = eigen.getEigenValues();
        this.proportion = (double[])this.eigenvalues.clone();
        Math.unitize1((double[])this.proportion);
    }
}

