/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.SingularValueDecomposition;
import smile.projection.Projection;

public class PCA
implements Projection<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int p;
    private int n;
    private double[] mu;
    private double[] pmu;
    private DenseMatrix eigvectors;
    private double[] eigvalues;
    private double[] proportion;
    private double[] cumulativeProportion;
    private DenseMatrix projection;

    public PCA(double[][] data) {
        this(data, false);
    }

    public PCA(double[][] data, boolean cor) {
        int i;
        int m = data.length;
        this.n = data[0].length;
        this.mu = Math.colMean((double[][])data);
        double[][] x = Math.clone((double[][])data);
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                x[i2][j] = data[i2][j] - this.mu[j];
            }
        }
        if (m > this.n && !cor) {
            SingularValueDecomposition svd = new SingularValueDecomposition(x);
            this.eigvalues = svd.getSingularValues();
            for (i = 0; i < this.eigvalues.length; ++i) {
                int n = i;
                this.eigvalues[n] = this.eigvalues[n] * this.eigvalues[i];
            }
            this.eigvectors = svd.getV();
        } else {
            int j;
            int i3;
            ColumnMajorMatrix cov = new ColumnMajorMatrix(this.n, this.n);
            for (int k = 0; k < m; ++k) {
                for (i3 = 0; i3 < this.n; ++i3) {
                    for (j = 0; j <= i3; ++j) {
                        cov.add(i3, j, x[k][i3] * x[k][j]);
                    }
                }
            }
            for (i = 0; i < this.n; ++i) {
                for (int j2 = 0; j2 <= i; ++j2) {
                    cov.div(i, j2, (double)m);
                    cov.set(j2, i, cov.get(i, j2));
                }
            }
            double[] sd = null;
            if (cor) {
                sd = new double[this.n];
                for (i3 = 0; i3 < this.n; ++i3) {
                    sd[i3] = Math.sqrt((double)cov.get(i3, i3));
                }
                for (i3 = 0; i3 < this.n; ++i3) {
                    for (j = 0; j <= i3; ++j) {
                        cov.div(i3, j, sd[i3] * sd[j]);
                        cov.set(j, i3, cov.get(i3, j));
                    }
                }
            }
            EigenValueDecomposition eigen = new EigenValueDecomposition((DenseMatrix)cov, true);
            DenseMatrix loadings = eigen.getEigenVectors();
            if (cor) {
                for (int i4 = 0; i4 < this.n; ++i4) {
                    for (int j3 = 0; j3 < this.n; ++j3) {
                        loadings.div(i4, j3, sd[i4]);
                    }
                }
            }
            this.eigvalues = eigen.getEigenValues();
            this.eigvectors = loadings;
        }
        this.proportion = (double[])this.eigvalues.clone();
        Math.unitize1((double[])this.proportion);
        this.cumulativeProportion = new double[this.eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        for (int i5 = 1; i5 < this.eigvalues.length; ++i5) {
            this.cumulativeProportion[i5] = this.cumulativeProportion[i5 - 1] + this.proportion[i5];
        }
        this.setProjection(0.95);
    }

    public double[] getCenter() {
        return this.mu;
    }

    public DenseMatrix getLoadings() {
        return this.eigvectors;
    }

    public double[] getVariance() {
        return this.eigvalues;
    }

    public double[] getVarianceProportion() {
        return this.proportion;
    }

    public double[] getCumulativeVarianceProportion() {
        return this.cumulativeProportion;
    }

    public DenseMatrix getProjection() {
        return this.projection;
    }

    public PCA setProjection(int p) {
        if (p < 1 || p > this.n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.p = p;
        this.projection = new ColumnMajorMatrix(p, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < p; ++j) {
                this.projection.set(j, i, this.eigvectors.get(i, j));
            }
        }
        this.pmu = new double[p];
        this.projection.ax(this.mu, this.pmu);
        return this;
    }

    public PCA setProjection(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        for (int k = 0; k < this.n; ++k) {
            if (!(this.cumulativeProportion[k] >= p)) continue;
            this.setProjection(k + 1);
            break;
        }
        return this;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] y = new double[this.p];
        this.projection.ax(x, y);
        Math.minus((double[])y, (double[])this.pmu);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] y = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            this.projection.ax(x[i], y[i]);
            Math.minus((double[])y[i], (double[])this.pmu);
        }
        return y;
    }
}

