/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.Math;
import smile.projection.Projection;
import smile.stat.distribution.GaussianDistribution;

public class RandomProjection
implements Projection<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double[] prob = new double[]{0.16666666666666666, 0.6666666666666666, 0.16666666666666666};
    private int p;
    private int n;
    private double[][] projection;

    public RandomProjection(int n, int p) {
        this(n, p, false);
    }

    public RandomProjection(int n, int p, boolean sparse) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.n = n;
        this.p = p;
        this.projection = new double[p][n];
        if (sparse) {
            double scale = Math.sqrt((double)3.0);
            for (int i = 0; i < p; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.projection[i][j] = scale * (double)(Math.random((double[])prob) - 1);
                }
            }
        } else {
            int j;
            int i;
            GaussianDistribution gauss = GaussianDistribution.getInstance();
            for (i = 0; i < p; ++i) {
                for (j = 0; j < n; ++j) {
                    this.projection[i][j] = gauss.rand();
                }
            }
            Math.unitize((double[])this.projection[0]);
            for (i = 1; i < p; ++i) {
                for (j = 0; j < i; ++j) {
                    double t = -Math.dot((double[])this.projection[i], (double[])this.projection[j]);
                    Math.axpy((double)t, (double[])this.projection[j], (double[])this.projection[i]);
                }
                Math.unitize((double[])this.projection[i]);
            }
        }
    }

    public double[][] getProjection() {
        return this.projection;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] y = new double[this.p];
        Math.ax((double[][])this.projection, (double[])x, (double[])y);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] y = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            Math.ax((double[][])this.projection, (double[])x[i], (double[])y[i]);
        }
        return y;
    }
}

