/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import smile.math.Math;
import smile.math.kernel.MercerKernel;
import smile.math.matrix.CholeskyDecomposition;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.LUDecomposition;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class GaussianProcessRegression<T>
implements Regression<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T[] knots;
    private double[] w;
    private MercerKernel<T> kernel;
    private double lambda;

    public GaussianProcessRegression(T[] x, double[] y, MercerKernel<T> kernel, double lambda) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        this.kernel = kernel;
        this.lambda = lambda;
        this.knots = x;
        int n = x.length;
        double[][] K = new double[n][n];
        this.w = new double[n];
        int i = 0;
        while (i < n) {
            for (int j = 0; j <= i; ++j) {
                K[i][j] = kernel.k(x[i], x[j]);
                K[j][i] = K[i][j];
            }
            double[] dArray = K[i];
            int n2 = i++;
            dArray[n2] = dArray[n2] + lambda;
        }
        CholeskyDecomposition cholesky = new CholeskyDecomposition(K);
        cholesky.solve(y, this.w);
    }

    public GaussianProcessRegression(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        this.kernel = kernel;
        this.lambda = lambda;
        this.knots = t;
        int n = x.length;
        int m = t.length;
        double[][] G = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                G[i][j] = kernel.k(x[i], t[j]);
            }
        }
        double[][] K = Math.atamm((double[][])G);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                double[] dArray = K[i];
                int n2 = j;
                dArray[n2] = dArray[n2] + lambda * kernel.k(t[i], t[j]);
                K[j][i] = K[i][j];
            }
        }
        double[] b = new double[m];
        this.w = new double[m];
        Math.atx((double[][])G, (double[])y, (double[])b);
        LUDecomposition lu = new LUDecomposition(K);
        lu.solve(b, this.w);
    }

    GaussianProcessRegression(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda, boolean nystrom) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        this.kernel = kernel;
        this.lambda = lambda;
        this.knots = x;
        int n = x.length;
        int m = t.length;
        ColumnMajorMatrix E = new ColumnMajorMatrix(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                E.set(i, j, kernel.k(x[i], t[j]));
            }
        }
        ColumnMajorMatrix W = new ColumnMajorMatrix(m, m);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                double k = kernel.k(t[i], t[j]);
                W.set(i, j, k);
                W.set(j, i, k);
            }
        }
        EigenValueDecomposition eigen = new EigenValueDecomposition((DenseMatrix)W, true);
        DenseMatrix U = eigen.getEigenVectors();
        DenseMatrix D = eigen.getD();
        for (int i = 0; i < m; ++i) {
            D.set(i, i, 1.0 / Math.sqrt((double)D.get(i, i)));
        }
        DenseMatrix UD = (DenseMatrix)U.abmm((Object)D);
        DenseMatrix UDUt = (DenseMatrix)UD.abtmm((Object)U);
        DenseMatrix L = (DenseMatrix)E.abmm((Object)UDUt);
        DenseMatrix LtL = L.ata();
        for (int i = 0; i < m; ++i) {
            LtL.add(i, i, lambda);
        }
        CholeskyDecomposition chol = new CholeskyDecomposition(LtL);
        DenseMatrix invLtL = chol.inverse();
        DenseMatrix K = (DenseMatrix)((DenseMatrix)L.abmm((Object)invLtL)).abtmm((Object)L);
        this.w = new double[n];
        K.atx(y, this.w);
        for (int i = 0; i < n; ++i) {
            this.w[i] = (y[i] - this.w[i]) / lambda;
        }
    }

    public double[] coefficients() {
        return this.w;
    }

    public double shrinkage() {
        return this.lambda;
    }

    @Override
    public double predict(T x) {
        double f = 0.0;
        for (int i = 0; i < this.knots.length; ++i) {
            f += this.w[i] * this.kernel.k(x, this.knots[i]);
        }
        return f;
    }

    public static class Trainer<T>
    extends RegressionTrainer<T> {
        private MercerKernel<T> kernel;
        private double lambda;

        public Trainer(MercerKernel<T> kernel, double lambda) {
            this.kernel = kernel;
            this.lambda = lambda;
        }

        @Override
        public GaussianProcessRegression<T> train(T[] x, double[] y) {
            return new GaussianProcessRegression<T>(x, y, this.kernel, this.lambda);
        }

        public GaussianProcessRegression<T> train(T[] x, double[] y, T[] t) {
            return new GaussianProcessRegression<T>(x, y, t, this.kernel, this.lambda);
        }
    }
}

