/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Complex;
import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;

public class EigenValueDecomposition {
    private static final Logger logger = LoggerFactory.getLogger(EigenValueDecomposition.class);
    private double[] d;
    private double[] e;
    private DenseMatrix V;

    EigenValueDecomposition(DenseMatrix V, double[] d) {
        this.V = V;
        this.d = d;
    }

    EigenValueDecomposition(DenseMatrix V, double[] d, double[] e) {
        this.V = V;
        this.d = d;
        this.e = e;
    }

    public DenseMatrix getEigenVectors() {
        return this.V;
    }

    public double[] getEigenValues() {
        return this.d;
    }

    public double[] getRealEigenValues() {
        return this.d;
    }

    public double[] getImagEigenValues() {
        return this.e;
    }

    public DenseMatrix getD() {
        int n = this.V.nrows();
        ColumnMajorMatrix D = new ColumnMajorMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            D.set(i, i, this.d[i]);
            if (this.e == null) continue;
            if (this.e[i] > 0.0) {
                D.set(i, i + 1, this.e[i]);
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D.set(i, i - 1, this.e[i]);
        }
        return D;
    }

    public EigenValueDecomposition(double[][] A) {
        this(new ColumnMajorMatrix(A));
    }

    public EigenValueDecomposition(double[][] A, boolean symmetric) {
        this((DenseMatrix)new ColumnMajorMatrix(A), symmetric);
    }

    public EigenValueDecomposition(double[][] A, boolean symmetric, boolean onlyValues) {
        this((DenseMatrix)new ColumnMajorMatrix(A), symmetric, onlyValues);
    }

    public EigenValueDecomposition(DenseMatrix A) {
        this(A, false);
    }

    public EigenValueDecomposition(DenseMatrix A, boolean symmetric) {
        this(A, symmetric, false);
    }

    public EigenValueDecomposition(DenseMatrix A, boolean symmetric, boolean onlyValues) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        int n = A.nrows();
        this.d = new double[n];
        this.e = new double[n];
        if (symmetric) {
            this.V = A;
            if (onlyValues) {
                EigenValueDecomposition.tred(this.V, this.d, this.e);
                EigenValueDecomposition.tql(this.d, this.e, n);
                this.V = null;
            } else {
                EigenValueDecomposition.tred2(this.V, this.d, this.e);
                EigenValueDecomposition.tql2(this.V, this.d, this.e, n);
            }
        } else {
            double[] scale = EigenValueDecomposition.balance(A);
            int[] perm = EigenValueDecomposition.elmhes(A);
            if (onlyValues) {
                EigenValueDecomposition.hqr(A, this.d, this.e);
                EigenValueDecomposition.sort(this.d, this.e);
                this.V = null;
            } else {
                this.V = new ColumnMajorMatrix(n, n);
                for (int i = 0; i < n; ++i) {
                    this.V.set(i, i, 1.0);
                }
                EigenValueDecomposition.eltran(A, this.V, perm);
                EigenValueDecomposition.hqr2(A, this.V, this.d, this.e);
                EigenValueDecomposition.balbak(this.V, scale);
                EigenValueDecomposition.sort(this.d, this.e, this.V);
            }
        }
    }

    private static void tred(DenseMatrix V, double[] d, double[] e) {
        int i;
        int n = V.nrows();
        for (i = 0; i < n; ++i) {
            d[i] = V.get(n - 1, i);
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j = 0; j < i; ++j) {
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                    V.set(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j2 = 0; j2 < i; ++j2) {
                    e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f = d[j2];
                    V.set(j2, i, f);
                    g = e[j2] + V.get(j2, j2) * f;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        g += V.get(k2, j2) * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V.get(k2, j2) * f;
                    }
                    e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n4 = j2;
                    e[n4] = e[n4] / h;
                    f += e[j2] * d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n5 = j;
                    e[n5] = e[n5] - hh * d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        V.sub(k3, j, f * e[k3] + g * d[k3]);
                    }
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                }
            }
            d[i] = h;
        }
        for (int j = 0; j < n; ++j) {
            d[j] = V.get(j, j);
        }
        e[0] = 0.0;
    }

    private static void tred2(DenseMatrix V, double[] d, double[] e) {
        int i;
        int n = V.nrows();
        for (i = 0; i < n; ++i) {
            d[i] = V.get(n - 1, i);
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j = 0; j < i; ++j) {
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                    V.set(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j2 = 0; j2 < i; ++j2) {
                    e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f = d[j2];
                    V.set(j2, i, f);
                    g = e[j2] + V.get(j2, j2) * f;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        g += V.get(k2, j2) * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V.get(k2, j2) * f;
                    }
                    e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n4 = j2;
                    e[n4] = e[n4] / h;
                    f += e[j2] * d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n5 = j;
                    e[n5] = e[n5] - hh * d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        V.sub(k3, j, f * e[k3] + g * d[k3]);
                    }
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            V.set(n - 1, i, V.get(i, i));
            V.set(i, i, 1.0);
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = V.get(k, i + 1) / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += V.get(k4, i + 1) * V.get(k4, j);
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        V.sub(k4, j, g * d[k4]);
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                V.set(k, i + 1, 0.0);
            }
        }
        for (int j = 0; j < n; ++j) {
            d[j] = V.get(n - 1, j);
            V.set(n - 1, j, 0.0);
        }
        V.set(n - 1, n - 1, 1.0);
        e[0] = 0.0;
    }

    private static void tql(double[] d, double[] e, int n) {
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= Math.EPSILON * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    if (++iter >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double g = d[l];
                    double p = (d[l + 1] - d[l]) / (2.0 * e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Math.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > Math.EPSILON * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int k = i;
            double p = d[i];
            for (int j = i + 1; j < n; ++j) {
                if (!(d[j] > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
        }
    }

    static void tql2(DenseMatrix V, double[] d, double[] e, int n) {
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= Math.EPSILON * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    if (++iter >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double g = d[l];
                    double p = (d[l + 1] - d[l]) / (2.0 * e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Math.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = V.get(k, i2 + 1);
                            V.set(k, i2 + 1, s * V.get(k, i2) + c * h);
                            V.set(k, i2, c * V.get(k, i2) - s * h);
                        }
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > Math.EPSILON * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = V.get(j, i);
                V.set(j, i, V.get(j, k));
                V.set(j, k, p);
            }
        }
    }

    private static double[] balance(DenseMatrix A) {
        double sqrdx = Math.RADIX * Math.RADIX;
        int n = A.nrows();
        double[] scale = new double[n];
        for (int i = 0; i < n; ++i) {
            scale[i] = 1.0;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < n; ++i) {
                int j;
                double r = 0.0;
                double c = 0.0;
                for (int j2 = 0; j2 < n; ++j2) {
                    if (j2 == i) continue;
                    c += Math.abs(A.get(j2, i));
                    r += Math.abs(A.get(i, j2));
                }
                if (c == 0.0 || r == 0.0) continue;
                double g = r / (double)Math.RADIX;
                double f = 1.0;
                double s = c + r;
                while (c < g) {
                    f *= (double)Math.RADIX;
                    c *= sqrdx;
                }
                g = r * (double)Math.RADIX;
                while (c > g) {
                    f /= (double)Math.RADIX;
                    c /= sqrdx;
                }
                if (!((c + r) / f < 0.95 * s)) continue;
                done = false;
                g = 1.0 / f;
                int n2 = i;
                scale[n2] = scale[n2] * f;
                for (j = 0; j < n; ++j) {
                    A.mul(i, j, g);
                }
                for (j = 0; j < n; ++j) {
                    A.mul(j, i, f);
                }
            }
        }
        return scale;
    }

    private static void balbak(DenseMatrix V, double[] scale) {
        int n = V.nrows();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V.mul(i, j, scale[i]);
            }
        }
    }

    private static int[] elmhes(DenseMatrix A) {
        int n = A.nrows();
        int[] perm = new int[n];
        for (int m = 1; m < n - 1; ++m) {
            int j;
            double x = 0.0;
            int i = m;
            for (j = m; j < n; ++j) {
                if (!(Math.abs(A.get(j, m - 1)) > Math.abs(x))) continue;
                x = A.get(j, m - 1);
                i = j;
            }
            perm[m] = i;
            if (i != m) {
                double swap;
                for (j = m - 1; j < n; ++j) {
                    swap = A.get(i, j);
                    A.set(i, j, A.get(m, j));
                    A.set(m, j, swap);
                }
                for (j = 0; j < n; ++j) {
                    swap = A.get(j, i);
                    A.set(j, i, A.get(j, m));
                    A.set(j, m, swap);
                }
            }
            if (x == 0.0) continue;
            for (i = m + 1; i < n; ++i) {
                int j2;
                double y = A.get(i, m - 1);
                if (y == 0.0) continue;
                A.set(i, m - 1, y /= x);
                for (j2 = m; j2 < n; ++j2) {
                    A.sub(i, j2, y * A.get(m, j2));
                }
                for (j2 = 0; j2 < n; ++j2) {
                    A.add(j2, m, y * A.get(j2, i));
                }
            }
        }
        return perm;
    }

    private static void eltran(DenseMatrix A, DenseMatrix V, int[] perm) {
        int n = A.nrows();
        for (int mp = n - 2; mp > 0; --mp) {
            for (int k = mp + 1; k < n; ++k) {
                V.set(k, mp, A.get(k, mp - 1));
            }
            int i = perm[mp];
            if (i == mp) continue;
            for (int j = mp; j < n; ++j) {
                V.set(mp, j, V.get(i, j));
                V.set(i, j, 0.0);
            }
            V.set(i, mp, 1.0);
        }
    }

    private static void hqr(DenseMatrix A, double[] d, double[] e) {
        int j;
        int i;
        int n = A.nrows();
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double anorm = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = Math.max(i - 1, 0); j < n; ++j) {
                anorm += Math.abs(A.get(i, j));
            }
        }
        int nn = n - 1;
        double t = 0.0;
        while (nn >= 0) {
            int l;
            int its = 0;
            do {
                int m;
                double z;
                double s;
                for (l = nn; l > 0; --l) {
                    s = Math.abs(A.get(l - 1, l - 1) + Math.abs(A.get(l, l)));
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (!(Math.abs(A.get(l, l - 1)) <= Math.EPSILON * s)) continue;
                    A.set(l, l - 1, 0.0);
                    break;
                }
                double x = A.get(nn, nn);
                if (l == nn) {
                    d[nn--] = x + t;
                    continue;
                }
                double y = A.get(nn - 1, nn - 1);
                double w = A.get(nn, nn - 1) * A.get(nn - 1, nn);
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    x += t;
                    if (q >= 0.0) {
                        z = p + Math.copySign(z, p);
                        d[nn - 1] = d[nn] = x + z;
                        if (z != 0.0) {
                            d[nn] = x - w / z;
                        }
                    } else {
                        d[nn] = x + p;
                        e[nn] = -z;
                        d[nn - 1] = d[nn];
                        e[nn - 1] = -e[nn];
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new IllegalStateException("Too many iterations in hqr");
                }
                if (its == 10 || its == 20) {
                    t += x;
                    for (i = 0; i < nn + 1; ++i) {
                        A.sub(i, i, x);
                    }
                    s = Math.abs(A.get(nn, nn - 1)) + Math.abs(A.get(nn - 1, nn - 2));
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                for (m = nn - 2; m >= l; --m) {
                    double v;
                    double u;
                    z = A.get(m, m);
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / A.get(m + 1, m) + A.get(m, m + 1);
                    q = A.get(m + 1, m + 1) - z - r - s;
                    r = A.get(m + 2, m + 1);
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(A.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s))) <= Math.EPSILON * (v = Math.abs(p /= s) * (Math.abs(A.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(A.get(m + 1, m + 1))))) break;
                }
                for (i = m; i < nn - 1; ++i) {
                    A.set(i + 2, i, 0.0);
                    if (i == m) continue;
                    A.set(i + 2, i - 1, 0.0);
                }
                for (int k = m; k < nn; ++k) {
                    if (k != m) {
                        p = A.get(k, k - 1);
                        q = A.get(k + 1, k - 1);
                        r = 0.0;
                        if (k + 1 != nn) {
                            r = A.get(k + 2, k - 1);
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = Math.copySign(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (l != m) {
                            A.set(k, k - 1, -A.get(k, k - 1));
                        }
                    } else {
                        A.set(k, k - 1, -s * x);
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (j = k; j < nn + 1; ++j) {
                        p = A.get(k, j) + q * A.get(k + 1, j);
                        if (k + 1 != nn) {
                            A.sub(k + 2, j, (p += r * A.get(k + 2, j)) * z);
                        }
                        A.sub(k + 1, j, p * y);
                        A.sub(k, j, p * x);
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (i = l; i < mmin + 1; ++i) {
                        p = x * A.get(i, k) + y * A.get(i, k + 1);
                        if (k + 1 != nn) {
                            A.sub(i, k + 2, (p += z * A.get(i, k + 2)) * r);
                        }
                        A.sub(i, k + 1, p * q);
                        A.sub(i, k, p);
                    }
                }
            } while (l + 1 < nn);
        }
    }

    private static void hqr2(DenseMatrix A, DenseMatrix V, double[] d, double[] e) {
        int k;
        int m;
        double w;
        double y;
        double x;
        int j;
        int i;
        int n = A.nrows();
        double z = 0.0;
        double s = 0.0;
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double anorm = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = Math.max(i - 1, 0); j < n; ++j) {
                anorm += Math.abs(A.get(i, j));
            }
        }
        int nn = n - 1;
        double t = 0.0;
        while (nn >= 0) {
            int l;
            int its = 0;
            do {
                for (l = nn; l > 0; --l) {
                    s = Math.abs(A.get(l - 1, l - 1)) + Math.abs(A.get(l, l));
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (!(Math.abs(A.get(l, l - 1)) <= Math.EPSILON * s)) continue;
                    A.set(l, l - 1, 0.0);
                    break;
                }
                x = A.get(nn, nn);
                if (l == nn) {
                    d[nn] = x + t;
                    A.set(nn, nn, x + t);
                    --nn;
                    continue;
                }
                y = A.get(nn - 1, nn - 1);
                w = A.get(nn, nn - 1) * A.get(nn - 1, nn);
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    A.set(nn, nn, x += t);
                    A.set(nn - 1, nn - 1, y + t);
                    if (q >= 0.0) {
                        z = p + Math.copySign(z, p);
                        d[nn - 1] = d[nn] = x + z;
                        if (z != 0.0) {
                            d[nn] = x - w / z;
                        }
                        x = A.get(nn, nn - 1);
                        s = Math.abs(x) + Math.abs(z);
                        p = x / s;
                        q = z / s;
                        r = Math.sqrt(p * p + q * q);
                        p /= r;
                        q /= r;
                        for (j = nn - 1; j < n; ++j) {
                            z = A.get(nn - 1, j);
                            A.set(nn - 1, j, q * z + p * A.get(nn, j));
                            A.set(nn, j, q * A.get(nn, j) - p * z);
                        }
                        for (i = 0; i <= nn; ++i) {
                            z = A.get(i, nn - 1);
                            A.set(i, nn - 1, q * z + p * A.get(i, nn));
                            A.set(i, nn, q * A.get(i, nn) - p * z);
                        }
                        for (i = 0; i < n; ++i) {
                            z = V.get(i, nn - 1);
                            V.set(i, nn - 1, q * z + p * V.get(i, nn));
                            V.set(i, nn, q * V.get(i, nn) - p * z);
                        }
                    } else {
                        d[nn] = x + p;
                        e[nn] = -z;
                        d[nn - 1] = d[nn];
                        e[nn - 1] = -e[nn];
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new IllegalArgumentException("Too many iterations in hqr");
                }
                if (its == 10 || its == 20) {
                    t += x;
                    for (i = 0; i < nn + 1; ++i) {
                        A.sub(i, i, x);
                    }
                    s = Math.abs(A.get(nn, nn - 1)) + Math.abs(A.get(nn - 1, nn - 2));
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                for (m = nn - 2; m >= l; --m) {
                    double v;
                    double u;
                    z = A.get(m, m);
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / A.get(m + 1, m) + A.get(m, m + 1);
                    q = A.get(m + 1, m + 1) - z - r - s;
                    r = A.get(m + 2, m + 1);
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(A.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s))) <= Math.EPSILON * (v = Math.abs(p /= s) * (Math.abs(A.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(A.get(m + 1, m + 1))))) break;
                }
                for (i = m; i < nn - 1; ++i) {
                    A.set(i + 2, i, 0.0);
                    if (i == m) continue;
                    A.set(i + 2, i - 1, 0.0);
                }
                for (k = m; k < nn; ++k) {
                    if (k != m) {
                        p = A.get(k, k - 1);
                        q = A.get(k + 1, k - 1);
                        r = 0.0;
                        if (k + 1 != nn) {
                            r = A.get(k + 2, k - 1);
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = Math.copySign(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (l != m) {
                            A.set(k, k - 1, -A.get(k, k - 1));
                        }
                    } else {
                        A.set(k, k - 1, -s * x);
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (j = k; j < n; ++j) {
                        p = A.get(k, j) + q * A.get(k + 1, j);
                        if (k + 1 != nn) {
                            A.sub(k + 2, j, (p += r * A.get(k + 2, j)) * z);
                        }
                        A.sub(k + 1, j, p * y);
                        A.sub(k, j, p * x);
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (i = 0; i < mmin + 1; ++i) {
                        p = x * A.get(i, k) + y * A.get(i, k + 1);
                        if (k + 1 != nn) {
                            A.sub(i, k + 2, (p += z * A.get(i, k + 2)) * r);
                        }
                        A.sub(i, k + 1, p * q);
                        A.sub(i, k, p);
                    }
                    for (i = 0; i < n; ++i) {
                        p = x * V.get(i, k) + y * V.get(i, k + 1);
                        if (k + 1 != nn) {
                            V.sub(i, k + 2, (p += z * V.get(i, k + 2)) * r);
                        }
                        V.sub(i, k + 1, p * q);
                        V.sub(i, k, p);
                    }
                }
            } while (l + 1 < nn);
        }
        if (anorm != 0.0) {
            for (nn = n - 1; nn >= 0; --nn) {
                Complex temp;
                p = d[nn];
                q = e[nn];
                int na = nn - 1;
                if (q == 0.0) {
                    m = nn;
                    A.set(nn, nn, 1.0);
                    for (i = nn - 1; i >= 0; --i) {
                        w = A.get(i, i) - p;
                        r = 0.0;
                        for (j = m; j <= nn; ++j) {
                            r += A.get(i, j) * A.get(j, nn);
                        }
                        if (e[i] < 0.0) {
                            z = w;
                            s = r;
                            continue;
                        }
                        m = i;
                        if (e[i] == 0.0) {
                            t = w;
                            if (t == 0.0) {
                                t = Math.EPSILON * anorm;
                            }
                            A.set(i, nn, -r / t);
                        } else {
                            x = A.get(i, i + 1);
                            y = A.get(i + 1, i);
                            q = Math.sqr(d[i] - p) + Math.sqr(e[i]);
                            t = (x * s - z * r) / q;
                            A.set(i, nn, t);
                            if (Math.abs(x) > Math.abs(z)) {
                                A.set(i + 1, nn, (-r - w * t) / x);
                            } else {
                                A.set(i + 1, nn, (-s - y * t) / z);
                            }
                        }
                        t = Math.abs(A.get(i, nn));
                        if (!(Math.EPSILON * t * t > 1.0)) continue;
                        for (j = i; j <= nn; ++j) {
                            A.div(j, nn, t);
                        }
                    }
                    continue;
                }
                if (!(q < 0.0)) continue;
                m = na;
                if (Math.abs(A.get(nn, na)) > Math.abs(A.get(na, nn))) {
                    A.set(na, na, q / A.get(nn, na));
                    A.set(na, nn, -(A.get(nn, nn) - p) / A.get(nn, na));
                } else {
                    temp = EigenValueDecomposition.cdiv(0.0, -A.get(na, nn), A.get(na, na) - p, q);
                    A.set(na, na, temp.re());
                    A.set(na, nn, temp.im());
                }
                A.set(nn, na, 0.0);
                A.set(nn, nn, 1.0);
                for (i = nn - 2; i >= 0; --i) {
                    w = A.get(i, i) - p;
                    double sa = 0.0;
                    double ra = 0.0;
                    for (j = m; j <= nn; ++j) {
                        ra += A.get(i, j) * A.get(j, na);
                        sa += A.get(i, j) * A.get(j, nn);
                    }
                    if (e[i] < 0.0) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        m = i;
                        if (e[i] == 0.0) {
                            temp = EigenValueDecomposition.cdiv(-ra, -sa, w, q);
                            A.set(i, na, temp.re());
                            A.set(i, nn, temp.im());
                        } else {
                            x = A.get(i, i + 1);
                            y = A.get(i + 1, i);
                            double vr = Math.sqr(d[i] - p) + Math.sqr(e[i]) - q * q;
                            double vi = 2.0 * q * (d[i] - p);
                            if (vr == 0.0 && vi == 0.0) {
                                vr = Math.EPSILON * anorm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            }
                            temp = EigenValueDecomposition.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            A.set(i, na, temp.re());
                            A.set(i, nn, temp.im());
                            if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                                A.set(i + 1, na, (-ra - w * A.get(i, na) + q * A.get(i, nn)) / x);
                                A.set(i + 1, nn, (-sa - w * A.get(i, nn) - q * A.get(i, na)) / x);
                            } else {
                                temp = EigenValueDecomposition.cdiv(-r - y * A.get(i, na), -s - y * A.get(i, nn), z, q);
                                A.set(i + 1, na, temp.re());
                                A.set(i + 1, nn, temp.im());
                            }
                        }
                    }
                    t = Math.max(Math.abs(A.get(i, na)), Math.abs(A.get(i, nn)));
                    if (!(Math.EPSILON * t * t > 1.0)) continue;
                    for (j = i; j <= nn; ++j) {
                        A.div(j, na, t);
                        A.div(j, nn, t);
                    }
                }
            }
            for (j = n - 1; j >= 0; --j) {
                for (i = 0; i < n; ++i) {
                    z = 0.0;
                    for (k = 0; k <= j; ++k) {
                        z += V.get(i, k) * A.get(k, j);
                    }
                    V.set(i, j, z);
                }
            }
        }
    }

    private static Complex cdiv(double xr, double xi, double yr, double yi) {
        double cdivi;
        double cdivr;
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            cdivr = (xr + r * xi) / d;
            cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            cdivr = (r * xr + xi) / d;
            cdivi = (r * xi - xr) / d;
        }
        return new Complex(cdivr, cdivi);
    }

    private static void sort(double[] d, double[] e) {
        int i = 0;
        int n = d.length;
        for (int j = 1; j < n; ++j) {
            double real = d[j];
            double img = e[j];
            for (i = j - 1; i >= 0 && !(d[i] >= d[j]); --i) {
                d[i + 1] = d[i];
                e[i + 1] = e[i];
            }
            d[i + 1] = real;
            e[i + 1] = img;
        }
    }

    private static void sort(double[] d, double[] e, DenseMatrix V) {
        int i = 0;
        int n = d.length;
        double[] temp = new double[n];
        for (int j = 1; j < n; ++j) {
            int k;
            double real = d[j];
            double img = e[j];
            for (k = 0; k < n; ++k) {
                temp[k] = V.get(k, j);
            }
            for (i = j - 1; i >= 0 && !(d[i] >= d[j]); --i) {
                d[i + 1] = d[i];
                e[i + 1] = e[i];
                for (k = 0; k < n; ++k) {
                    V.set(k, i + 1, V.get(k, i));
                }
            }
            d[i + 1] = real;
            e[i + 1] = img;
            for (k = 0; k < n; ++k) {
                V.set(k, i + 1, temp[k]);
            }
        }
    }
}

