/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.math.matrix.Matrix;

public class PageRank {
    private static final Logger logger = LoggerFactory.getLogger(PageRank.class);

    public static double[] pagerank(Matrix A) {
        int n = A.nrows();
        double[] v = new double[n];
        Arrays.fill(v, 1.0 / (double)n);
        return PageRank.pagerank(A, v);
    }

    public static double[] pagerank(Matrix A, double[] v) {
        return PageRank.pagerank(A, v, 0.85, 1.0E-7, 57);
    }

    public static double[] pagerank(Matrix A, double[] v, double damping, double tol, int maxIter) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException("Matrix is not square.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = A.nrows();
        tol = Math.max(tol, Math.EPSILON * (double)n);
        double[] z = new double[n];
        double[] p = Arrays.copyOf(v, n);
        for (int iter = 1; iter <= maxIter; ++iter) {
            A.ax(p, z);
            double beta = 1.0 - damping * Math.norm1(z);
            double delta = 0.0;
            for (int i = 0; i < n; ++i) {
                double q = damping * z[i] + beta * v[i];
                delta += Math.abs(q - p[i]);
                p[i] = q;
            }
            if (iter % 10 == 0) {
                logger.info(String.format("PageRank residual after %3d power iterations: %.7f\n", iter, delta));
            }
            if (!(delta < tol)) continue;
            logger.info(String.format("PageRank residual after %3d power iterations: %.7f\n", iter, delta));
            return p;
        }
        logger.error("PageRank iteration exceeded the maximum number of iterations.");
        return p;
    }
}

