/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.util.ClassLoad;

public final class Deencapsulation {
    private Deencapsulation() {
    }

    @Nullable
    public static <T> T getField(@Nonnull Object objectWithField, @Nonnull String fieldName) {
        return FieldReflection.getField(objectWithField.getClass(), fieldName, objectWithField);
    }

    @Nullable
    public static <T> T getField(@Nonnull Object objectWithField, @Nonnull Class<T> fieldType) {
        return FieldReflection.getField(objectWithField.getClass(), fieldType, objectWithField);
    }

    @Nullable
    public static <T> T getField(@Nonnull Class<?> classWithStaticField, @Nonnull String fieldName) {
        return FieldReflection.getField(classWithStaticField, fieldName, null);
    }

    @Nullable
    public static <T> T getField(@Nonnull Class<?> classWithStaticField, @Nonnull Class<T> fieldType) {
        return FieldReflection.getField(classWithStaticField, fieldType, null);
    }

    public static void setField(@Nonnull Object objectWithField, @Nonnull String fieldName, @Nullable Object fieldValue) {
        FieldReflection.setField(objectWithField.getClass(), objectWithField, fieldName, fieldValue);
    }

    public static void setField(@Nonnull Object objectWithField, @Nonnull Object fieldValue) {
        FieldReflection.setField(objectWithField.getClass(), objectWithField, null, fieldValue);
    }

    public static void setField(@Nonnull Class<?> classWithStaticField, @Nonnull String fieldName, @Nullable Object fieldValue) {
        FieldReflection.setField(classWithStaticField, null, fieldName, fieldValue);
    }

    public static void setField(@Nonnull Class<?> classWithStaticField, @Nonnull Object fieldValue) {
        FieldReflection.setField(classWithStaticField, null, null, fieldValue);
    }

    public static <T> T invoke(Object objectWithMethod, String methodName, Class<?>[] parameterTypes, Object ... methodArgs) {
        Class<?> theClass = objectWithMethod.getClass();
        return MethodReflection.invoke(theClass, objectWithMethod, methodName, parameterTypes, methodArgs);
    }

    public static <T> T invoke(Object objectWithMethod, String methodName, Object ... nonNullArgs) {
        Class<?> theClass = objectWithMethod.getClass();
        return MethodReflection.invoke(theClass, objectWithMethod, methodName, nonNullArgs);
    }

    public static <T> T invoke(Class<?> classWithStaticMethod, String methodName, Class<?>[] parameterTypes, Object ... methodArgs) {
        return MethodReflection.invoke(classWithStaticMethod, null, methodName, parameterTypes, methodArgs);
    }

    public static <T> T invoke(Class<?> classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        return MethodReflection.invoke(classWithStaticMethod, null, methodName, nonNullArgs);
    }

    public static <T> T invoke(String classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        Class theClass = ClassLoad.loadClass(classWithStaticMethod);
        return MethodReflection.invoke(theClass, null, methodName, nonNullArgs);
    }
}

