/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.classGeneration.ConcreteSubclass;
import mockit.internal.faking.CaptureOfFakedImplementations;
import mockit.internal.faking.FakeClassSetup;
import mockit.internal.faking.FakeClasses;
import mockit.internal.faking.FakedImplementationClass;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.MockInvocationHandler;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.GeneratedClasses;

public abstract class MockUp<T> {
    protected final Type targetType;
    @Nullable
    private final Class<?> mockedClass;
    @Nullable
    private T mockInstance;
    @Nullable
    private T invokedInstance;

    protected MockUp() {
        Type[] typesToMock;
        MockUp<?> previousMockUp = this.findPreviouslyFakedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.targetType = previousMockUp.targetType;
            this.mockedClass = previousMockUp.mockedClass;
            return;
        }
        this.targetType = this.getTypeToFake();
        Class classToMock = null;
        if (this.targetType instanceof Class) {
            classToMock = (Class)this.targetType;
        } else if (this.targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.targetType;
            classToMock = (Class)parameterizedType.getRawType();
        }
        this.mockedClass = classToMock != null ? this.redefineClassOrImplementInterface(classToMock) : ((typesToMock = ((TypeVariable)this.targetType).getBounds()).length > 1 ? new FakedImplementationClass(this).createImplementation(typesToMock) : new CaptureOfFakedImplementations(this, typesToMock[0]).apply());
    }

    @Nullable
    private MockUp<?> findPreviouslyFakedClassIfMockUpAlreadyApplied() {
        FakeClasses mockClasses = TestRun.getFakeClasses();
        FakeClasses.MockUpInstances mockUpInstances = mockClasses.findPreviouslyAppliedMockUps(this);
        if (mockUpInstances != null && mockUpInstances.hasMockUpsForSingleInstances()) {
            return mockUpInstances.initialMockUp;
        }
        return null;
    }

    @Nonnull
    private Type getTypeToFake() {
        Class currentClass = this.getClass();
        Type superclass;
        while (!((superclass = currentClass.getGenericSuperclass()) instanceof ParameterizedType)) {
            if (superclass == MockUp.class) {
                throw new IllegalArgumentException("No target type");
            }
            currentClass = (Class)superclass;
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    @Nonnull
    private Class<?> redefineClassOrImplementInterface(@Nonnull Class<T> classToMock) {
        if (classToMock.isInterface()) {
            return this.createInstanceOfMockedImplementationClass(classToMock, this.targetType);
        }
        Class<T> realClass = classToMock;
        if (Modifier.isAbstract(classToMock.getModifiers())) {
            classToMock = new ConcreteSubclass(classToMock).generateClass();
        }
        this.redefineMethods(realClass, classToMock, this.targetType);
        return classToMock;
    }

    @Nonnull
    private Class<T> createInstanceOfMockedImplementationClass(@Nonnull Class<T> classToMock, @Nullable Type typeToMock) {
        return new FakedImplementationClass<T>(this).createImplementation(classToMock, typeToMock);
    }

    private void redefineMethods(@Nonnull Class<T> realClass, @Nonnull Class<T> classToMock, @Nullable Type genericMockedType) {
        new FakeClassSetup(realClass, classToMock, genericMockedType, this).redefineMethods();
    }

    protected MockUp(Class<?> targetClass) {
        this.targetType = targetClass;
        MockUp<?> previousMockUp = this.findPreviouslyFakedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.mockedClass = previousMockUp.mockedClass;
            return;
        }
        if (targetClass.isInterface()) {
            this.mockedClass = this.createInstanceOfMockedImplementationClass(targetClass, targetClass);
        } else {
            this.mockedClass = targetClass;
            Class<?> realClass = targetClass;
            this.redefineMethods(realClass, realClass, null);
            this.mockInstance = null;
        }
    }

    protected MockUp(T targetInstance) {
        Class<?> classToMock;
        MockUp<?> previousMockUp = this.findPreviouslyFakedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.targetType = previousMockUp.targetType;
            this.mockedClass = previousMockUp.mockedClass;
            this.setMockInstance(targetInstance);
            return;
        }
        this.targetType = classToMock = targetInstance.getClass();
        this.mockedClass = classToMock;
        this.redefineMethods(classToMock, classToMock, classToMock);
        this.setMockInstance(targetInstance);
    }

    private void setMockInstance(@Nonnull T mockInstance) {
        TestRun.getFakeClasses().addFake(this, mockInstance);
        this.mockInstance = mockInstance;
    }

    public final T getMockInstance() {
        if (this.invokedInstance == Void.class) {
            return null;
        }
        if (this.invokedInstance != null) {
            return this.invokedInstance;
        }
        if (this.mockInstance == null && this.mockedClass != null) {
            Object newInstance = this.createMockInstance(this.mockedClass);
            this.setMockInstance(newInstance);
        }
        return this.mockInstance;
    }

    @Nonnull
    private Object createMockInstance(@Nonnull Class<?> mockedClass) {
        String mockedClassName = mockedClass.getName();
        if (GeneratedClasses.isGeneratedImplementationClassName(mockedClassName)) {
            return ConstructorReflection.newInstanceUsingPublicDefaultConstructor(mockedClass);
        }
        if (Proxy.isProxyClass(mockedClass)) {
            return MockInvocationHandler.newMockedInstance(mockedClass);
        }
        return ConstructorReflection.newUninitializedInstance(mockedClass);
    }

    protected void onTearDown() {
    }

    static {
        Startup.verifyInitialization();
    }
}

