/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.jvmConstants.Access;
import mockit.asm.util.ByteVector;

public class BaseWriter {
    protected ConstantPoolGeneration cp;
    protected int classOrMemberAccess;
    @Nonnegative
    private int deprecatedAttributeIndex;
    @Nonnegative
    private int syntheticAttributeIndex;
    @Nullable
    protected AnnotationVisitor annotations;

    protected BaseWriter() {
    }

    protected BaseWriter(@Nonnull ConstantPoolGeneration cp, int classOrMemberAccess) {
        this.cp = cp;
        this.classOrMemberAccess = classOrMemberAccess;
    }

    @Nonnull
    public final ConstantPoolGeneration getConstantPoolGeneration() {
        return this.cp;
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return this.addAnnotation(desc);
    }

    @Nonnull
    private AnnotationVisitor addAnnotation(@Nonnull String desc) {
        AnnotationVisitor aw = new AnnotationVisitor(this.cp, desc);
        aw.setNext(this.annotations);
        this.annotations = aw;
        return aw;
    }

    public void visitEnd() {
    }

    protected final void createMarkerAttributes(int classVersion) {
        if (Access.isDeprecated(this.classOrMemberAccess)) {
            this.deprecatedAttributeIndex = this.cp.newUTF8("Deprecated");
        }
        if (Access.isSynthetic(this.classOrMemberAccess, classVersion)) {
            this.syntheticAttributeIndex = this.cp.newUTF8("Synthetic");
        }
    }

    @Nonnegative
    protected final int getAnnotationsSize() {
        if (this.annotations != null) {
            this.getConstantPoolItemForRuntimeVisibleAnnotationsAttribute();
            return 8 + this.annotations.getSize();
        }
        return 0;
    }

    @Nonnegative
    private int getConstantPoolItemForRuntimeVisibleAnnotationsAttribute() {
        return this.cp.newUTF8("RuntimeVisibleAnnotations");
    }

    @Nonnegative
    protected final int getMarkerAttributeCount() {
        return (this.deprecatedAttributeIndex == 0 ? 0 : 1) + (this.syntheticAttributeIndex == 0 ? 0 : 1);
    }

    @Nonnegative
    protected final int getMarkerAttributesSize() {
        int attributeCount = this.getMarkerAttributeCount();
        return 6 * attributeCount;
    }

    protected final void putAccess(@Nonnull ByteVector out, int baseMask) {
        int accessFlag = Access.computeFlag(this.classOrMemberAccess, baseMask);
        out.putShort(accessFlag);
    }

    protected final void putMarkerAttributes(@Nonnull ByteVector out) {
        if (this.deprecatedAttributeIndex > 0) {
            out.putShort(this.deprecatedAttributeIndex).putInt(0);
        }
        if (this.syntheticAttributeIndex > 0) {
            out.putShort(this.syntheticAttributeIndex).putInt(0);
        }
    }

    protected final void putAnnotations(@Nonnull ByteVector out) {
        if (this.annotations != null) {
            int item = this.getConstantPoolItemForRuntimeVisibleAnnotationsAttribute();
            out.putShort(item);
            this.annotations.put(out);
        }
    }

    protected void put(@Nonnull ByteVector out) {
    }

    protected static void put(@Nonnull ByteVector out, @Nonnull List<? extends BaseWriter> writers) {
        out.putShort(writers.size());
        for (BaseWriter baseWriter : writers) {
            baseWriter.put(out);
        }
    }
}

