/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.types.ObjectType;
import mockit.asm.types.PrimitiveType;
import mockit.asm.types.ReferenceType;

public abstract class JavaType {
    private static final JavaType[] NO_ARGS = new JavaType[0];
    @Nonnegative
    final int len;

    JavaType(@Nonnegative int len) {
        this.len = len;
    }

    @Nonnull
    public static JavaType getType(@Nonnull String typeDescriptor) {
        return JavaType.getType(typeDescriptor.toCharArray(), 0);
    }

    @Nonnull
    public static JavaType[] getArgumentTypes(@Nonnull String methodDescriptor) {
        char[] buf = methodDescriptor.toCharArray();
        int off = 1;
        int size = 0;
        while (true) {
            char c = buf[off];
            ++off;
            if (c == ')') break;
            if (c == 'L') {
                off = JavaType.findNextTypeTerminatorCharacter(buf, off);
                ++size;
                continue;
            }
            if (c == '[') continue;
            ++size;
        }
        return JavaType.getArgumentTypes(buf, size);
    }

    @Nonnegative
    private static int findNextTypeTerminatorCharacter(@Nonnull char[] desc, @Nonnegative int i) {
        while (desc[i++] != ';') {
        }
        return i;
    }

    @Nonnull
    private static JavaType[] getArgumentTypes(@Nonnull char[] buf, @Nonnegative int argCount) {
        if (argCount == 0) {
            return NO_ARGS;
        }
        JavaType[] argTypes = new JavaType[argCount];
        int off = 1;
        int i = 0;
        while (buf[off] != ')') {
            JavaType argType;
            argTypes[i] = argType = JavaType.getType(buf, off);
            off += argType.len + (argType instanceof ObjectType ? 2 : 0);
            ++i;
        }
        return argTypes;
    }

    @Nonnull
    public static JavaType getReturnType(@Nonnull String methodDescriptor) {
        char[] buf = methodDescriptor.toCharArray();
        return JavaType.getType(buf, methodDescriptor.indexOf(41) + 1);
    }

    public static int getArgumentsAndReturnSizes(@Nonnull String desc) {
        int argSize = 1;
        int i = 1;
        block5: while (true) {
            char currentChar = desc.charAt(i);
            ++i;
            switch (currentChar) {
                case ')': {
                    char nextChar = desc.charAt(i);
                    return argSize << 2 | (nextChar == 'V' ? 0 : (JavaType.isDoubleSizePrimitiveType(nextChar) ? 2 : 1));
                }
                case 'L': {
                    i = JavaType.findNextTypeTerminatorCharacter(desc, i);
                    ++argSize;
                    continue block5;
                }
                case '[': {
                    char arrayElementType = desc.charAt(i = JavaType.findStartOfArrayElementType(desc, i));
                    if (!JavaType.isDoubleSizePrimitiveType(arrayElementType)) continue block5;
                    --argSize;
                    continue block5;
                }
            }
            if (JavaType.isDoubleSizePrimitiveType(currentChar)) {
                argSize += 2;
                continue;
            }
            ++argSize;
        }
    }

    private static boolean isDoubleSizePrimitiveType(char typeCode) {
        return typeCode == 'D' || typeCode == 'J';
    }

    @Nonnegative
    private static int findNextTypeTerminatorCharacter(@Nonnull String desc, @Nonnegative int i) {
        while (desc.charAt(i++) != ';') {
        }
        return i;
    }

    @Nonnegative
    private static int findStartOfArrayElementType(@Nonnull String desc, @Nonnegative int i) {
        while (desc.charAt(i) == '[') {
            ++i;
        }
        return i;
    }

    @Nonnull
    static JavaType getType(@Nonnull char[] buf, @Nonnegative int off) {
        PrimitiveType primitiveType = PrimitiveType.getPrimitiveType(buf[off]);
        if (primitiveType != null) {
            return primitiveType;
        }
        return ReferenceType.getReferenceType(buf, off);
    }

    @Nonnull
    public abstract String getClassName();

    @Nonnull
    public final String getDescriptor() {
        StringBuilder buf = new StringBuilder();
        this.getDescriptor(buf);
        return buf.toString();
    }

    abstract void getDescriptor(@Nonnull StringBuilder var1);

    @Nonnull
    public static String getInternalName(@Nonnull Class<?> aClass) {
        return aClass.getName().replace('.', '/');
    }

    @Nonnull
    public static String getConstructorDescriptor(@Nonnull Constructor<?> constructor) {
        StringBuilder buf = JavaType.getMemberDescriptor(constructor.getParameterTypes());
        buf.append('V');
        return buf.toString();
    }

    @Nonnull
    private static StringBuilder getMemberDescriptor(@Nonnull Class<?>[] parameterTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (Class<?> parameterType : parameterTypes) {
            JavaType.getDescriptor(buf, parameterType);
        }
        buf.append(')');
        return buf;
    }

    @Nonnull
    public static String getMethodDescriptor(@Nonnull Method method) {
        StringBuilder buf = JavaType.getMemberDescriptor(method.getParameterTypes());
        JavaType.getDescriptor(buf, method.getReturnType());
        return buf.toString();
    }

    private static void getDescriptor(@Nonnull StringBuilder buf, @Nonnull Class<?> aClass) {
        Class<?> d = aClass;
        while (true) {
            if (d.isPrimitive()) {
                char typeCode = PrimitiveType.getPrimitiveType(d).getTypeCode();
                buf.append(typeCode);
                return;
            }
            if (!d.isArray()) {
                ReferenceType.getDescriptor(buf, d);
                return;
            }
            buf.append('[');
            d = d.getComponentType();
        }
    }

    @Nonnegative
    public abstract int getSize();

    public abstract int getOpcode(int var1);

    public abstract int getLoadOpcode();

    public abstract int getConstOpcode();

    public final String toString() {
        return this.getDescriptor();
    }
}

