/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.AccretionFile;
import mockit.coverage.Configuration;
import mockit.coverage.DataFileMerging;
import mockit.coverage.XmlFile;
import mockit.coverage.data.CoverageData;
import mockit.coverage.reporting.CoverageReport;

final class OutputFileGenerator {
    private static final String[] ALL_SOURCE_DIRS = new String[0];
    @Nonnull
    private final String[] outputFormats = OutputFileGenerator.getOutputFormat();
    @Nonnull
    private final String outputDir = Configuration.getProperty("outputDir", "");
    @Nullable
    private final String[] sourceDirs;

    OutputFileGenerator() {
        String commaSeparatedDirs = Configuration.getProperty("srcDirs");
        this.sourceDirs = commaSeparatedDirs == null ? ALL_SOURCE_DIRS : (commaSeparatedDirs.isEmpty() ? null : commaSeparatedDirs.split("\\s*,\\s*"));
    }

    @Nonnull
    private static String[] getOutputFormat() {
        String[] stringArray;
        String format = Configuration.getProperty("output", "");
        if (format.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "html";
        } else {
            stringArray = format.trim().split("\\s*,\\s*|\\s+");
        }
        return stringArray;
    }

    boolean isOutputToBeGenerated() {
        return this.isHTMLWithNoCallPoints() || this.isWithCallPoints() || this.hasOutputFormat("serial") || this.hasOutputFormat("serial-append") || this.hasOutputFormat("xml");
    }

    private boolean isHTMLWithNoCallPoints() {
        return this.hasOutputFormat("html") || this.hasOutputFormat("html-nocp");
    }

    boolean isWithCallPoints() {
        return this.hasOutputFormat("html-cp");
    }

    private boolean hasOutputFormat(@Nonnull String format) {
        for (String outputFormat : this.outputFormats) {
            if (!format.equals(outputFormat)) continue;
            return true;
        }
        return false;
    }

    void generate() {
        CoverageData coverageData = CoverageData.instance();
        if (coverageData.isEmpty()) {
            System.out.print("JMockit: No classes were instrumented for coverage; please make sure that ");
            String classesRegexp = Configuration.getProperty("classes");
            if (classesRegexp == null) {
                System.out.print("classes exercised by tests are in a directory included in the runtime classpath");
            } else {
                System.out.print("classes selected for coverage through the regular expression \"" + classesRegexp + "\" are available from the runtime classpath");
            }
            System.out.println(", and that they have been compiled with debug information.");
            return;
        }
        boolean outputDirCreated = this.createOutputDirIfSpecifiedButNotExists();
        try {
            this.generateAccretionDataFileIfRequested(coverageData);
            this.generateXmlDataFileIfRequested(coverageData);
            this.generateHTMLReportIfRequested(coverageData, outputDirCreated);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void generateAggregateReportFromInputFiles(@Nonnull String[] inputPaths) {
        boolean outputDirCreated = this.createOutputDirIfSpecifiedButNotExists();
        try {
            CoverageData coverageData = new DataFileMerging(inputPaths).merge();
            this.generateHTMLReportIfRequested(coverageData, outputDirCreated);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean createOutputDirIfSpecifiedButNotExists() {
        if (this.outputDir.isEmpty()) {
            return false;
        }
        File outDir = new File(this.outputDir);
        return outDir.mkdirs();
    }

    private void generateAccretionDataFileIfRequested(@Nonnull CoverageData newData) throws IOException {
        if (this.hasOutputFormat("serial")) {
            new AccretionFile(this.outputDir, newData).generate();
        } else if (this.hasOutputFormat("serial-append")) {
            AccretionFile accretionFile = new AccretionFile(this.outputDir, newData);
            accretionFile.mergeDataFromExistingFileIfAny();
            accretionFile.generate();
        }
    }

    private void generateXmlDataFileIfRequested(@Nonnull CoverageData newData) throws IOException {
        if (this.hasOutputFormat("xml")) {
            new XmlFile(this.outputDir, newData).generate();
        }
    }

    private void generateHTMLReportIfRequested(@Nonnull CoverageData coverageData, boolean outputDirCreated) throws IOException {
        if (this.isHTMLWithNoCallPoints()) {
            new CoverageReport(this.outputDir, outputDirCreated, this.sourceDirs, coverageData, false).generate();
        } else if (this.isWithCallPoints()) {
            new CoverageReport(this.outputDir, outputDirCreated, this.sourceDirs, coverageData, true).generate();
        }
    }
}

