/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.coverage.CallPoint;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.testRedundancy.TestCoverage;

public final class TestRun {
    private static final Object LOCK = new Object();
    private static boolean terminated;

    private TestRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lineExecuted(@Nonnegative int fileIndex, @Nonnegative int line) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            CallPoint callPoint = null;
            if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line)) {
                callPoint = CallPoint.create(new Throwable());
            }
            int previousExecutionCount = fileData.registerExecution(line, callPoint);
            TestRun.recordNewLineOrSegmentAsCoveredIfApplicable(previousExecutionCount);
        }
    }

    private static void recordNewLineOrSegmentAsCoveredIfApplicable(@Nonnegative int previousExecutionCount) {
        TestCoverage testCoverage = TestCoverage.INSTANCE;
        if (testCoverage != null) {
            testCoverage.recordNewItemCoveredByTestIfApplicable(previousExecutionCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void branchExecuted(@Nonnegative int fileIndex, @Nonnegative int line, @Nonnegative int branchIndex) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            if (fileData.hasValidBranch(line, branchIndex)) {
                CallPoint callPoint = null;
                if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line, branchIndex)) {
                    callPoint = CallPoint.create(new Throwable());
                }
                int previousExecutionCount = fileData.registerExecution(line, branchIndex, callPoint);
                TestRun.recordNewLineOrSegmentAsCoveredIfApplicable(previousExecutionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToStaticField(classAndFieldNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfStaticField(classAndFieldNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@Nonnull Object instance, @Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToInstanceField(instance, classAndFieldNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@Nonnull Object instance, @Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfInstanceField(instance, classAndFieldNames);
        }
    }

    static void terminate() {
        terminated = true;
    }

    public static boolean isTerminated() {
        return terminated;
    }
}

