/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.coverage.Configuration;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;

final class XmlFile {
    @Nonnull
    private final String srcDir;
    @Nonnull
    private final File outputFile;
    @Nonnull
    private final CoverageData coverageData;

    XmlFile(@Nonnull String outputDir, @Nonnull CoverageData coverageData) {
        String firstSrcDir = Configuration.getProperty("srcDirs", "").split("\\s*,\\s*")[0];
        this.srcDir = firstSrcDir.isEmpty() ? "" : firstSrcDir + "/";
        String parentDir = Configuration.getOrChooseOutputDirectory(outputDir);
        this.outputFile = new File(parentDir, "coverage.xml");
        this.coverageData = coverageData;
    }

    void generate() throws IOException {
        try (FileWriter out = new FileWriter(this.outputFile, StandardCharsets.UTF_8);){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<coverage version=\"1\">\n");
            for (Map.Entry<String, FileCoverageData> fileAndData : this.coverageData.getFileToFileData().entrySet()) {
                String sourceFileName = fileAndData.getKey();
                this.writeOpeningXmlElementForSourceFile(out, sourceFileName);
                PerFileLineCoverage lineInfo = fileAndData.getValue().lineCoverageInfo;
                XmlFile.writeXmlElementsForExecutableLines(out, lineInfo);
                out.write("\t</file>\n");
            }
            out.write("</coverage>\n");
        }
        System.out.println("JMockit: Coverage data written to " + this.outputFile.getCanonicalPath());
    }

    private void writeOpeningXmlElementForSourceFile(@Nonnull Writer out, @Nonnull String sourceFileName) throws IOException {
        out.write("\t<file path=\"");
        out.write(this.srcDir);
        out.write(sourceFileName);
        out.write("\">\n");
    }

    private static void writeXmlElementsForExecutableLines(@Nonnull Writer out, @Nonnull PerFileLineCoverage lineInfo) throws IOException {
        int lineCount = lineInfo.getLineCount();
        for (int lineNum = 1; lineNum <= lineCount; ++lineNum) {
            if (!lineInfo.hasLineData(lineNum)) continue;
            LineCoverageData lineData = lineInfo.getLineData(lineNum);
            out.write("\t\t<lineToCover lineNumber=\"");
            XmlFile.writeNumber(out, lineNum);
            out.write("\" covered=\"");
            out.write(Boolean.toString(lineData.isCovered()));
            if (lineData.containsBranches()) {
                out.write("\" branchesToCover=\"");
                XmlFile.writeNumber(out, lineData.getNumberOfBranchingSourcesAndTargets());
                out.write("\" coveredBranches=\"");
                XmlFile.writeNumber(out, lineData.getNumberOfCoveredBranchingSourcesAndTargets());
            }
            out.write("\"/>\n");
        }
    }

    private static void writeNumber(@Nonnull Writer out, @Nonnegative int value) throws IOException {
        out.write(Integer.toString(value));
    }
}

