/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.controlFlow.Label;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.modification.MethodModifier;

final class CFGTracking {
    @Nonnull
    private final PerFileLineCoverage lineCoverageInfo;
    @Nonnull
    private final List<Label> visitedLabels;
    @Nonnull
    private final List<Label> jumpTargetsForCurrentLine;
    @Nonnull
    private final List<Integer> pendingBranches;
    @Nonnegative
    private int lineExpectingInstructionAfterJump;
    private boolean assertFoundInCurrentLine;
    private boolean ignoreUntilNextLabel;
    @Nonnegative
    private int foundPotentialBooleanExpressionValue;
    @Nonnegative
    private int ignoreUntilNextSwitch;

    CFGTracking(@Nonnull PerFileLineCoverage lineCoverageInfo) {
        this.lineCoverageInfo = lineCoverageInfo;
        this.visitedLabels = new ArrayList<Label>();
        this.jumpTargetsForCurrentLine = new ArrayList<Label>(4);
        this.pendingBranches = new ArrayList<Integer>(6);
    }

    void startNewLine() {
        if (!this.pendingBranches.isEmpty()) {
            this.pendingBranches.clear();
        }
        this.jumpTargetsForCurrentLine.clear();
    }

    void afterNewLabel(@Nonnegative int currentLine, @Nonnull Label label) {
        if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
            this.ignoreUntilNextLabel = false;
            return;
        }
        this.visitedLabels.add(label);
        int jumpTargetIndex = this.jumpTargetsForCurrentLine.indexOf(label);
        if (jumpTargetIndex >= 0) {
            label.jumpTargetLine = label.line > 0 ? label.line : currentLine;
            int targetBranchIndex = 2 * jumpTargetIndex + 1;
            this.pendingBranches.add(targetBranchIndex);
            this.assertFoundInCurrentLine = false;
        }
        this.foundPotentialBooleanExpressionValue = 0;
    }

    void afterGoto() {
        this.assertFoundInCurrentLine = false;
        if (this.foundPotentialBooleanExpressionValue == 1) {
            this.foundPotentialBooleanExpressionValue = 2;
        }
    }

    void afterConditionalJump(@Nonnull MethodModifier methodModifier, @Nonnull Label jumpSource, @Nonnull Label jumpTarget) {
        int currentLine = methodModifier.currentLine;
        if (currentLine == 0 || this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0 || this.visitedLabels.contains(jumpTarget)) {
            this.assertFoundInCurrentLine = false;
            return;
        }
        jumpSource.jumpTargetLine = currentLine;
        if (!this.jumpTargetsForCurrentLine.contains(jumpTarget)) {
            this.jumpTargetsForCurrentLine.add(jumpTarget);
        }
        LineCoverageData lineData = this.lineCoverageInfo.getOrCreateLineData(currentLine);
        int sourceBranchIndex = lineData.addBranchingPoint(jumpSource, jumpTarget);
        this.pendingBranches.add(sourceBranchIndex);
        if (this.assertFoundInCurrentLine) {
            BranchCoverageData branchData = this.lineCoverageInfo.getBranchData(currentLine, sourceBranchIndex + 1);
            branchData.markAsUnreachable();
        }
        this.lineExpectingInstructionAfterJump = 0;
        this.generateCallToRegisterBranchTargetExecutionIfPending(methodModifier);
        this.lineExpectingInstructionAfterJump = currentLine;
    }

    void generateCallToRegisterBranchTargetExecutionIfPending(@Nonnull MethodModifier methodModifier) {
        if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
            return;
        }
        this.foundPotentialBooleanExpressionValue = 0;
        if (!this.pendingBranches.isEmpty()) {
            for (Integer pendingBranchIndex : this.pendingBranches) {
                methodModifier.generateCallToRegisterBranchTargetExecution(pendingBranchIndex);
            }
            this.pendingBranches.clear();
        }
        if (this.lineExpectingInstructionAfterJump > 0) {
            if (methodModifier.currentLine > this.lineExpectingInstructionAfterJump) {
                this.lineCoverageInfo.markLastLineSegmentAsEmpty(this.lineExpectingInstructionAfterJump);
            }
            this.lineExpectingInstructionAfterJump = 0;
        }
    }

    boolean hasOnlyOneLabelBeingVisited() {
        return this.visitedLabels.size() == 1;
    }

    void registerAssertFoundInCurrentLine() {
        this.assertFoundInCurrentLine = true;
        this.ignoreUntilNextLabel = true;
    }

    void beforeNoOperandInstruction(@Nonnull MethodModifier methodModifier, @Nonnegative int opcode) {
        if ((opcode == 3 || opcode == 4) && this.foundPotentialBooleanExpressionValue == 0) {
            this.generateCallToRegisterBranchTargetExecutionIfPending(methodModifier);
            this.foundPotentialBooleanExpressionValue = 1;
        } else {
            this.generateCallToRegisterBranchTargetExecutionIfPending(methodModifier);
        }
    }

    void afterMethodInstruction(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name) {
        if (opcode == 182 && "hashCode".equals(name) && "java/lang/String".equals(owner) && this.ignoreUntilNextSwitch == 0) {
            this.ignoreUntilNextSwitch = 1;
        }
    }

    void beforeLookupSwitchInstruction() {
        if (this.ignoreUntilNextSwitch == 1) {
            this.ignoreUntilNextSwitch = 2;
        }
    }
}

